/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.DoubleConverter;
import java.awt.geom.AffineTransform;
import java.text.MessageFormat;

public class AffineTransformConverter
implements Converter<AffineTransform> {
    @Override
    public Class<? extends AffineTransform> getValueType() {
        return AffineTransform.class;
    }

    @Override
    public AffineTransform parse(String text) throws ConversionException {
        double[] array;
        if (text.isEmpty()) {
            return null;
        }
        try {
            array = (double[])new ArrayConverter(double[].class, new DoubleConverter()).parse(text);
        }
        catch (ConversionException e) {
            throw new ConversionException(MessageFormat.format("Cannot parse ''{0}'' into an affine transform: {1}", text, e.getMessage()), e);
        }
        if (array.length != 4 && array.length != 6) {
            throw new ConversionException(MessageFormat.format("Cannot parse ''{0}'' into an affine transform.", text));
        }
        return new AffineTransform(array);
    }

    @Override
    public String format(AffineTransform transform) {
        if (transform == null) {
            return "";
        }
        double[] array = new double[6];
        transform.getMatrix(array);
        return new ArrayConverter(double[].class, new DoubleConverter()).format(array);
    }
}

