/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.tools.DatabaseRecord;
import org.esa.snap.statistics.tools.GeometryID;
import org.esa.snap.statistics.tools.MapInverter;
import org.esa.snap.statistics.tools.ObservationYear;
import org.esa.snap.statistics.tools.ParameterName;
import org.esa.snap.statistics.tools.StatisticalMappingAnalyser;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class StatisticsDatabase {
    private final TreeMap<ObservationYear, Map<ParameterName, Map<GeometryID, DatabaseRecord>>> yearMap = new TreeMap();
    private final String nameColumn;

    public StatisticsDatabase(String nameColumn) {
        this.nameColumn = nameColumn;
    }

    public ObservationYear[] getYears() {
        Set<ObservationYear> years = this.yearMap.keySet();
        return years.toArray(new ObservationYear[years.size()]);
    }

    public ParameterName[] getParameterNames(ObservationYear year) {
        if (!this.yearMap.containsKey(year)) {
            return new ParameterName[0];
        }
        Set<ParameterName> parameterNames = this.yearMap.get(year).keySet();
        return parameterNames.toArray(new ParameterName[parameterNames.size()]);
    }

    public static void main(String[] args) {
        ObservationYear year = new ObservationYear(2002);
        String string = "No data for year '" + year + "'.";
        System.out.println("string = " + string);
    }

    public DatabaseRecord[] getData(ObservationYear year, ParameterName parameterName) {
        if (!this.yearMap.containsKey(year)) {
            throw new IllegalArgumentException("No data for year '" + year + "'.");
        }
        Map<ParameterName, Map<GeometryID, DatabaseRecord>> parameterMap = this.yearMap.get(year);
        if (!parameterMap.containsKey(parameterName)) {
            throw new IllegalArgumentException("No data for parameter '" + parameterName + "'.");
        }
        Collection<DatabaseRecord> databaseRecords = parameterMap.get(parameterName).values();
        return databaseRecords.toArray(new DatabaseRecord[databaseRecords.size()]);
    }

    public void append(ProductData.UTC date, FeatureCollection<SimpleFeatureType, SimpleFeature> shapeCollection, Properties mapping) {
        Calendar utcCalendar = date.getAsCalendar();
        ObservationYear year = new ObservationYear(utcCalendar.get(1));
        Map<ParameterName, Map<GeometryID, DatabaseRecord>> parameterMap = this.getParameterMap(year);
        Map<String, String> invertedMapping = MapInverter.createInvertedTreeMap(mapping);
        StatisticalMappingAnalyser mappingAnalyser = new StatisticalMappingAnalyser(invertedMapping.keySet());
        String[] geophysicalParameterNames = mappingAnalyser.getGeophysicalParameterNames();
        String[] statisticalMeasureNames = mappingAnalyser.getStatisticalMeasureNames();
        for (String geophysicalParameterName : geophysicalParameterNames) {
            ParameterName parameterName = new ParameterName(geophysicalParameterName);
            if (parameterMap.containsKey(parameterName)) continue;
            parameterMap.put(parameterName, new TreeMap());
        }
        FeatureIterator features = shapeCollection.features();
        while (features.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)features.next();
            String geomIdStr = simpleFeature.getID();
            String geomId = geomIdStr.contains(".") ? geomIdStr.substring(geomIdStr.lastIndexOf(".") + 1) : geomIdStr;
            GeometryID geometryID = new GeometryID(geomId);
            for (String geophysicalParameterName : geophysicalParameterNames) {
                DatabaseRecord geomRecord;
                ParameterName parameterName = new ParameterName(geophysicalParameterName);
                Map<GeometryID, DatabaseRecord> geomDatabaseRecordMap = parameterMap.get(parameterName);
                if (geomDatabaseRecordMap.containsKey(geometryID)) {
                    geomRecord = geomDatabaseRecordMap.get(geometryID);
                } else {
                    String geomName = StatisticsDatabase.getGeomName(this.nameColumn, simpleFeature, geomId);
                    geomRecord = new DatabaseRecord(geometryID, geomName);
                    geomDatabaseRecordMap.put(geometryID, geomRecord);
                }
                TreeMap<String, String> statData = new TreeMap<String, String>();
                String[] stringArray = statisticalMeasureNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String statisticalMeasureName;
                    String fullName = (statisticalMeasureName = stringArray[i]) + "_" + geophysicalParameterName;
                    String shortName = invertedMapping.get(fullName);
                    Object value = simpleFeature.getAttribute(shortName);
                    statData.put(statisticalMeasureName, value == null ? "" : value.toString());
                }
                geomRecord.addStatisticalData(utcCalendar.getTime(), statData);
            }
        }
        features.close();
    }

    private Map<ParameterName, Map<GeometryID, DatabaseRecord>> getParameterMap(ObservationYear year) {
        HashMap<ParameterName, Map<GeometryID, DatabaseRecord>> parameterMap;
        if (this.yearMap.containsKey(year)) {
            parameterMap = this.yearMap.get(year);
        } else {
            parameterMap = new HashMap();
            this.yearMap.put(year, parameterMap);
        }
        return parameterMap;
    }

    public static String getGeomName(String nameColumn, SimpleFeature simpleFeature, String geomId) {
        Object simpleFeatureAttribute = simpleFeature.getAttribute(nameColumn);
        String geomName = simpleFeatureAttribute != null ? simpleFeatureAttribute.toString() : geomId;
        return geomName;
    }
}

