/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.esa.snap.statistics.StatisticsOp;

public class StatisticalMappingAnalyser {
    private final TreeSet<String> statisticalMeasure;
    private final TreeSet<String> geophysicalParameter;

    public StatisticalMappingAnalyser(Set<String> fullNames) {
        int[] defaultPercentiles = StatisticsOp.DEFAULT_PERCENTILES_INTS;
        String[] algorithmNames = StatisticsOp.getAlgorithmNames(defaultPercentiles);
        StatisticalMappingAnalyser.sortAlongLength_BiggestFirst(algorithmNames);
        this.geophysicalParameter = new TreeSet();
        this.statisticalMeasure = new TreeSet();
        block0: for (String fullName : fullNames) {
            for (String algorithmName : algorithmNames) {
                if (!fullName.startsWith(algorithmName)) continue;
                this.statisticalMeasure.add(algorithmName);
                String paramName = fullName.substring(algorithmName.length());
                this.geophysicalParameter.add(this.trimWithUnderscores(paramName));
                continue block0;
            }
        }
    }

    public String[] getStatisticalMeasureNames() {
        return this.toStrings(this.statisticalMeasure);
    }

    public String[] getGeophysicalParameterNames() {
        return this.toStrings(this.geophysicalParameter);
    }

    private String trimWithUnderscores(String s) {
        while (s.startsWith("_") && s.length() > 1) {
            s = s.substring(1);
            s = s.trim();
        }
        while (s.endsWith("_") && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
            s = s.trim();
        }
        return s;
    }

    private String[] toStrings(Set<String> set) {
        return set.toArray(new String[set.size()]);
    }

    public static void sortAlongLength_BiggestFirst(String[] algorithmNames) {
        Arrays.sort(algorithmNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
    }
}

