/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import com.bc.ceres.binding.ValidationException;
import java.io.File;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.TimeStampExtractor;

public class FilenameDateExtractor {
    private final TimeStampExtractor timeStampExtractor = new TimeStampExtractor("yyyyMMdd", "${startDate}_*.shp");

    public boolean isValidFilename(File file) {
        try {
            this.timeStampExtractor.extractTimeStamps(file.getName());
            return true;
        }
        catch (ValidationException ignored) {
            return false;
        }
    }

    public ProductData.UTC getDate(File file) {
        try {
            if (this.isValidFilename(file)) {
                return this.timeStampExtractor.extractTimeStamps(file.getName())[0];
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return null;
    }
}

