/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import java.util.List;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.BandConfiguration;

public class ProductValidator {
    final ProductData.UTC startDate;
    final ProductData.UTC endDate;
    final List<BandConfiguration> bandConfigurations;
    private final Logger logger;

    public ProductValidator(List<BandConfiguration> bandConfigurations, ProductData.UTC startDate, ProductData.UTC endDate, Logger logger) {
        this.bandConfigurations = bandConfigurations;
        this.startDate = startDate;
        this.endDate = endDate;
        this.logger = logger;
    }

    public boolean isValid(Product product) {
        return this.containsGeocoding(product) && this.canHandleBandConfigurations(product) && this.isInDateRange(product);
    }

    private boolean containsGeocoding(Product product) {
        boolean valid;
        boolean bl = valid = product.getSceneGeoCoding() != null;
        if (!valid) {
            this.logSkipped("The product '" + product.getName() + "' does not contain a geo coding.");
        }
        return valid;
    }

    private boolean canHandleBandConfigurations(Product product) {
        for (BandConfiguration bandConfiguration : this.bandConfigurations) {
            String bandName = bandConfiguration.sourceBandName;
            String expression = bandConfiguration.expression;
            if (bandName != null) {
                if (product.containsBand(bandName)) continue;
                this.logSkipped("The product '" + product.getName() + "' does not contain the band '" + bandName + "'");
                return false;
            }
            if (!product.isCompatibleBandArithmeticExpression(expression)) {
                this.logSkipped("The product '" + product.getName() + "' can not resolve the band arithmetic expression '" + expression + "'");
                return false;
            }
            String replacedExpression = expression.replace(" ", "_");
            if (!product.containsBand(replacedExpression)) continue;
            this.logSkipped("The product '" + product.getName() + "' already contains a band '" + replacedExpression + "'");
            return false;
        }
        return true;
    }

    private boolean isInDateRange(Product product) {
        if (this.startDate == null && this.endDate == null) {
            return true;
        }
        ProductData.UTC productStartDate = product.getStartTime();
        ProductData.UTC productEndDate = product.getEndTime();
        if (productStartDate == null && productEndDate == null) {
            return false;
        }
        if (this.startDate != null) {
            if (productStartDate != null) {
                long startDateMillis = this.startDate.getAsDate().getTime();
                long productStartDateMillis = productStartDate.getAsDate().getTime();
                if (productStartDateMillis < startDateMillis) {
                    this.logSkippedDueToTimeRange(product);
                    return false;
                }
            } else {
                this.logSkippedDueToTimeRange(product);
                return false;
            }
        }
        if (this.endDate != null) {
            if (productEndDate != null) {
                long endDateMillis = this.endDate.getAsDate().getTime();
                long productEndDateMillis = productEndDate.getAsDate().getTime();
                if (productEndDateMillis > endDateMillis) {
                    this.logSkippedDueToTimeRange(product);
                    return false;
                }
            } else {
                this.logSkippedDueToTimeRange(product);
                return false;
            }
        }
        return true;
    }

    private void logSkippedDueToTimeRange(Product product) {
        this.logSkipped("The product '" + product.getName() + "' is not inside the date range" + this.formatDateRange());
    }

    private String formatDateRange() {
        return (this.startDate != null ? " from " + this.startDate.format() : " ") + (this.endDate != null ? " to " + this.endDate.format() : "");
    }

    private void logSkipped(String message) {
        this.logger.warning("Product skipped. " + message);
    }
}

