/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.ProductLoader;
import org.esa.snap.statistics.ProductValidator;
import org.esa.snap.statistics.StatisticComputer;

public class ProductLoop {
    private final ProductLoader loader;
    private final Logger logger;
    private final StatisticComputer statisticComputer;
    private List<String> productNames;
    private ProductData.UTC newestDate;
    private ProductData.UTC oldestDate;
    private final ProductValidator productValidator;

    public ProductLoop(ProductLoader loader, ProductValidator productValidator, StatisticComputer statisticComputer, Logger logger) {
        this.loader = loader;
        this.productValidator = productValidator;
        this.logger = logger;
        this.statisticComputer = statisticComputer;
        this.productNames = new ArrayList<String>();
        this.newestDate = null;
        this.oldestDate = null;
    }

    public void loop(Product[] alreadyLoadedProducts, File[] productFilesToLoad) {
        if (alreadyLoadedProducts != null) {
            for (Product product : alreadyLoadedProducts) {
                this.compute(product);
            }
        }
        for (File file : productFilesToLoad) {
            if (file == null || ProductLoop.isProductAlreadyOpened(alreadyLoadedProducts, file)) continue;
            this.loadProductAndCompute(file);
        }
    }

    public String[] getProductNames() {
        return this.productNames.toArray(new String[this.productNames.size()]);
    }

    private void loadProductAndCompute(File productFile) {
        try {
            Product product = this.loader.loadProduct(productFile);
            if (product == null) {
                this.logReadProductError(productFile);
                return;
            }
            try {
                this.compute(product);
            }
            finally {
                product.dispose();
            }
        }
        catch (IOException e) {
            this.logReadProductError(productFile);
        }
    }

    private void compute(Product product) {
        if (product == null || !this.productValidator.isValid(product)) {
            return;
        }
        String path = product.getFileLocation() != null ? product.getFileLocation().getAbsolutePath() : product.getName();
        this.logger.info("    current product: " + path);
        this.statisticComputer.computeStatistic(product);
        this.productNames.add(path);
        this.logger.fine("    " + this.productNames.size() + " computed:");
        this.logger.fine("        product: " + path);
    }

    private void logReadProductError(File productFile) {
        this.logger.severe(String.format("Failed to read from '%s' (not a data product or reader missing)", productFile));
    }

    static boolean isProductAlreadyOpened(Product[] alreadyLoadedProducts, File file) {
        if (alreadyLoadedProducts != null) {
            for (Product product : alreadyLoadedProducts) {
                File fileLocation;
                if (product == null || (fileLocation = product.getFileLocation()) == null || !fileLocation.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }

    public ProductData.UTC getNewestDate() {
        return this.newestDate;
    }

    public ProductData.UTC getOldestDate() {
        return this.oldestDate;
    }
}

