/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.resample;

import java.awt.event.ActionEvent;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Resampler;
import org.esa.snap.core.gpf.common.resample.ResamplingOp;
import org.esa.snap.core.gpf.ui.resample.Bundle;
import org.esa.snap.core.gpf.ui.resample.ResamplingDialog;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.ui.AppContext;

public class ResamplingAction
extends AbstractSnapAction
implements Resampler {
    public void actionPerformed(ActionEvent e) {
        Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        this.resample(product, false);
    }

    public String getName() {
        return Bundle.CTL_ResamplingAction_OpName();
    }

    public String getDescription() {
        return Bundle.CTL_ResamplingAction_Description();
    }

    public boolean canResample(Product multiSizeProduct) {
        return ResamplingOp.canBeApplied((Product)multiSizeProduct);
    }

    public Product resample(Product multiSizeProduct) {
        return this.resample(multiSizeProduct, true);
    }

    public Product resample(Product product, boolean modal) {
        AppContext appContext = SnapApp.getDefault().getAppContext();
        ResamplingDialog resamplingDialog = new ResamplingDialog(appContext, product, modal);
        resamplingDialog.show();
        return resamplingDialog.getTargetProduct();
    }
}

