/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.reproject;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageGeometry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.gpf.ui.CollocationCrsForm;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.param.ParamParseException;
import org.esa.snap.core.param.ParamValidateException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DemSelector;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsSelectionPanel;
import org.esa.snap.ui.crs.CustomCrsForm;
import org.esa.snap.ui.crs.OutputGeometryForm;
import org.esa.snap.ui.crs.OutputGeometryFormModel;
import org.esa.snap.ui.crs.PredefinedCrsForm;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.referencing.CRS;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

class ReprojectionForm
extends JTabbedPane {
    private static final String[] RESAMPLING_IDENTIFIER = new String[]{"Nearest", "Bilinear", "Bicubic"};
    private final boolean orthoMode;
    private final String targetProductSuffix;
    private final AppContext appContext;
    private final SourceProductSelector sourceProductSelector;
    private final TargetProductSelector targetProductSelector;
    private final Model reprojectionModel;
    private final PropertyContainer reprojectionContainer;
    private DemSelector demSelector;
    private CrsSelectionPanel crsSelectionPanel;
    private OutputGeometryFormModel outputGeometryModel;
    private JButton outputParamButton;
    private InfoForm infoForm;
    private CoordinateReferenceSystem crs;
    private CollocationCrsForm collocationCrsUI;
    private CustomCrsForm customCrsUI;

    ReprojectionForm(TargetProductSelector targetProductSelector, boolean orthorectify, AppContext appContext) {
        this.targetProductSelector = targetProductSelector;
        this.orthoMode = orthorectify;
        this.appContext = appContext;
        this.sourceProductSelector = new SourceProductSelector(appContext, "Source Product:");
        if (this.orthoMode) {
            this.targetProductSuffix = "orthorectified";
            this.sourceProductSelector.setProductFilter(new OrthorectifyProductFilter());
        } else {
            this.targetProductSuffix = "reprojected";
            this.sourceProductSelector.setProductFilter(new GeoCodingProductFilter());
        }
        this.reprojectionModel = new Model();
        this.reprojectionContainer = PropertyContainer.createObjectBacked((Object)this.reprojectionModel);
        this.createUI();
    }

    void updateParameterMap(Map<String, Object> parameterMap) {
        CoordinateReferenceSystem selectedCrs;
        parameterMap.clear();
        parameterMap.put("resamplingName", this.reprojectionModel.resamplingName);
        parameterMap.put("includeTiePointGrids", this.reprojectionModel.includeTiePointGrids);
        parameterMap.put("addDeltaBands", this.reprojectionModel.addDeltaBands);
        parameterMap.put("noDataValue", this.reprojectionModel.noDataValue);
        if (!this.collocationCrsUI.getRadioButton().isSelected() && (selectedCrs = this.getSelectedCrs()) != null) {
            if (selectedCrs instanceof AbstractReferenceSystem) {
                parameterMap.put("crs", ((AbstractReferenceSystem)selectedCrs).toWKT(2, false));
            } else {
                parameterMap.put("crs", selectedCrs.toWKT());
            }
        }
        if (this.orthoMode) {
            parameterMap.put("orthorectify", this.orthoMode);
            if (this.demSelector.isUsingExternalDem()) {
                parameterMap.put("elevationModelName", this.demSelector.getDemName());
            } else {
                parameterMap.put("elevationModelName", null);
            }
        }
        if (!this.reprojectionModel.preserveResolution && this.outputGeometryModel != null) {
            PropertySet container = this.outputGeometryModel.getPropertySet();
            parameterMap.put("referencePixelX", container.getValue("referencePixelX"));
            parameterMap.put("referencePixelY", container.getValue("referencePixelY"));
            parameterMap.put("easting", container.getValue("easting"));
            parameterMap.put("northing", container.getValue("northing"));
            parameterMap.put("orientation", container.getValue("orientation"));
            parameterMap.put("pixelSizeX", container.getValue("pixelSizeX"));
            parameterMap.put("pixelSizeY", container.getValue("pixelSizeY"));
            parameterMap.put("width", container.getValue("width"));
            parameterMap.put("height", container.getValue("height"));
        }
    }

    public void updateFormModel(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
        Object crsAsWKT;
        Object elevationModelName;
        Property[] properties;
        for (Property property : properties = this.reprojectionContainer.getProperties()) {
            String propertyName = property.getName();
            Object newValue = parameterMap.get(propertyName);
            if (newValue == null) continue;
            property.setValue(newValue);
        }
        if (this.orthoMode && (elevationModelName = parameterMap.get("elevationModelName")) instanceof String) {
            try {
                this.demSelector.setDemName((String)elevationModelName);
            }
            catch (ParamValidateException e) {
                throw new ValidationException(e.getMessage(), (Throwable)e);
            }
            catch (ParamParseException e) {
                throw new ConversionException(e.getMessage(), (Throwable)e);
            }
        }
        if ((crsAsWKT = parameterMap.get("crs")) instanceof String) {
            try {
                CoordinateReferenceSystem crs = CRS.parseWKT((String)((String)crsAsWKT));
                if (!(crs instanceof ProjectedCRS)) {
                    throw new ConversionException("Failed to convert CRS from WKT.");
                }
                ProjectedCRS projectedCRS = (ProjectedCRS)crs;
                Projection conversionFromBase = projectedCRS.getConversionFromBase();
                OperationMethod operationMethod = conversionFromBase.getMethod();
                ParameterValueGroup parameterValues = conversionFromBase.getParameterValues();
                GeodeticDatum geodeticDatum = projectedCRS.getDatum();
                this.customCrsUI.setCustom(geodeticDatum, operationMethod, parameterValues);
            }
            catch (FactoryException e) {
                throw new ConversionException("Failed to convert CRS from WKT.", (Throwable)e);
            }
        }
        if (parameterMap.containsKey("referencePixelX")) {
            PropertyContainer propertySet = PropertyContainer.createMapBacked(parameterMap);
            this.outputGeometryModel = new OutputGeometryFormModel((PropertySet)propertySet);
            this.reprojectionContainer.setValue("preserveResolution", (Object)false);
        } else {
            this.outputGeometryModel = null;
            this.reprojectionContainer.setValue("preserveResolution", (Object)true);
        }
        this.updateCRS();
    }

    Map<String, Product> getProductMap() {
        HashMap<String, Product> productMap = new HashMap<String, Product>(5);
        productMap.put("source", this.getSourceProduct());
        if (this.collocationCrsUI.getRadioButton().isSelected()) {
            productMap.put("collocateWith", this.collocationCrsUI.getCollocationProduct());
        }
        return productMap;
    }

    Product getSourceProduct() {
        return this.sourceProductSelector.getSelectedProduct();
    }

    CoordinateReferenceSystem getSelectedCrs() {
        return this.crs;
    }

    void prepareShow() {
        this.sourceProductSelector.initProducts();
        this.crsSelectionPanel.prepareShow();
    }

    void prepareHide() {
        this.sourceProductSelector.releaseProducts();
        this.crsSelectionPanel.prepareHide();
        if (this.outputGeometryModel != null) {
            this.outputGeometryModel.setSourceProduct(null);
        }
    }

    String getExternalDemName() {
        if (this.orthoMode && this.demSelector.isUsingExternalDem()) {
            return this.demSelector.getDemName();
        }
        return null;
    }

    private void createUI() {
        this.addTab("I/O Parameters", this.createIOPanel());
        this.addTab("Reprojection Parameters", this.createParametersPanel());
    }

    private JPanel createIOPanel() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(3, 3);
        JPanel ioPanel = new JPanel((LayoutManager)tableLayout);
        ioPanel.add(this.createSourceProductPanel());
        ioPanel.add(this.targetProductSelector.createDefaultPanel());
        ioPanel.add(tableLayout.createVerticalSpacer());
        return ioPanel;
    }

    private JPanel createParametersPanel() {
        JPanel parameterPanel = new JPanel();
        TableLayout layout = new TableLayout(1);
        layout.setTablePadding(4, 4);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableWeightX(Double.valueOf(1.0));
        parameterPanel.setLayout((LayoutManager)layout);
        this.customCrsUI = new CustomCrsForm(this.appContext);
        PredefinedCrsForm predefinedCrsUI = new PredefinedCrsForm(this.appContext);
        this.collocationCrsUI = new CollocationCrsForm(this.appContext);
        CrsForm[] crsForms = new CrsForm[]{this.customCrsUI, predefinedCrsUI, this.collocationCrsUI};
        this.crsSelectionPanel = new CrsSelectionPanel(crsForms);
        this.sourceProductSelector.addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                Product product = (Product)event.getSelection().getSelectedValue();
                ReprojectionForm.this.crsSelectionPanel.setReferenceProduct(product);
            }
        });
        parameterPanel.add((Component)this.crsSelectionPanel);
        if (this.orthoMode) {
            this.demSelector = new DemSelector();
            parameterPanel.add((Component)this.demSelector);
        }
        parameterPanel.add(this.createOuputSettingsPanel());
        this.infoForm = new InfoForm();
        parameterPanel.add(this.infoForm.createUI());
        this.crsSelectionPanel.addPropertyChangeListener("crs", evt -> this.updateCRS());
        this.updateCRS();
        return parameterPanel;
    }

    private void updateCRS() {
        Product sourceProduct = this.getSourceProduct();
        try {
            if (sourceProduct != null) {
                this.crs = this.crsSelectionPanel.getCrs(ProductUtils.getCenterGeoPos((Product)sourceProduct));
                if (this.crs != null) {
                    this.infoForm.setCrsInfoText(this.crs.getName().getCode(), this.crs.toString());
                } else {
                    this.infoForm.setCrsErrorText("No valid 'Coordinate Reference System' selected.");
                }
            } else {
                this.infoForm.setCrsErrorText("No source product selected.");
                this.crs = null;
            }
        }
        catch (FactoryException e) {
            this.infoForm.setCrsErrorText(e.getMessage());
            this.crs = null;
        }
        if (this.outputGeometryModel != null) {
            this.outputGeometryModel.setTargetCrs(this.crs);
        }
        this.updateOutputParameterState();
    }

    private void updateProductSize() {
        int width = 0;
        int height = 0;
        Product sourceProduct = this.getSourceProduct();
        if (sourceProduct != null && this.crs != null) {
            if (!this.reprojectionModel.preserveResolution && this.outputGeometryModel != null) {
                PropertySet container = this.outputGeometryModel.getPropertySet();
                width = (Integer)container.getValue("width");
                height = (Integer)container.getValue("height");
            } else {
                Product collocationProduct = this.collocationCrsUI.getCollocationProduct();
                ImageGeometry iGeometry = this.collocationCrsUI.getRadioButton().isSelected() && collocationProduct != null ? ImageGeometry.createCollocationTargetGeometry((Product)sourceProduct, (Product)collocationProduct) : ImageGeometry.createTargetGeometry((Product)sourceProduct, (CoordinateReferenceSystem)this.crs, null, null, null, null, null, null, null, null, null);
                Rectangle imageRect = iGeometry.getImageRect();
                width = imageRect.width;
                height = imageRect.height;
            }
        }
        this.infoForm.setWidth(width);
        this.infoForm.setHeight(height);
    }

    private JPanel createOuputSettingsPanel() {
        TableLayout tableLayout = new TableLayout(3);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnFill(0, TableLayout.Fill.NONE);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setColumnPadding(0, new Insets(4, 4, 4, 20));
        tableLayout.setColumnWeightX(0, Double.valueOf(0.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
        tableLayout.setColumnWeightX(2, Double.valueOf(1.0));
        tableLayout.setCellColspan(0, 1, Integer.valueOf(2));
        tableLayout.setCellPadding(1, 0, new Insets(4, 24, 4, 20));
        JPanel outputSettingsPanel = new JPanel((LayoutManager)tableLayout);
        outputSettingsPanel.setBorder(BorderFactory.createTitledBorder("Output Settings"));
        BindingContext context = new BindingContext((PropertySet)this.reprojectionContainer);
        JCheckBox preserveResolutionCheckBox = new JCheckBox("Preserve resolution");
        context.bind("preserveResolution", preserveResolutionCheckBox);
        this.collocationCrsUI.getCrsUI().addPropertyChangeListener("collocate", evt -> {
            boolean collocate = (Boolean)evt.getNewValue();
            this.reprojectionContainer.setValue("preserveResolution", (Object)(collocate || this.reprojectionModel.preserveResolution ? 1 : 0));
            preserveResolutionCheckBox.setEnabled(!collocate);
        });
        outputSettingsPanel.add(preserveResolutionCheckBox);
        JCheckBox includeTPcheck = new JCheckBox("Reproject tie-point grids", true);
        context.bind("includeTiePointGrids", includeTPcheck);
        outputSettingsPanel.add(includeTPcheck);
        this.outputParamButton = new JButton("Output Parameters...");
        this.outputParamButton.setEnabled(!this.reprojectionModel.preserveResolution);
        this.outputParamButton.addActionListener(new OutputParamActionListener());
        outputSettingsPanel.add(this.outputParamButton);
        outputSettingsPanel.add(new JLabel("No-data value:"));
        JTextField noDataField = new JTextField();
        outputSettingsPanel.add(noDataField);
        context.bind("noDataValue", noDataField);
        JCheckBox addDeltaBandsChecker = new JCheckBox("Add delta lat/lon bands");
        outputSettingsPanel.add(addDeltaBandsChecker);
        context.bind("addDeltaBands", addDeltaBandsChecker);
        outputSettingsPanel.add(new JLabel("Resampling method:"));
        JComboBox<String> resampleComboBox = new JComboBox<String>(RESAMPLING_IDENTIFIER);
        resampleComboBox.setPrototypeDisplayValue(RESAMPLING_IDENTIFIER[0]);
        context.bind("resamplingName", resampleComboBox);
        outputSettingsPanel.add(resampleComboBox);
        this.reprojectionContainer.addPropertyChangeListener("preserveResolution", evt -> this.updateOutputParameterState());
        return outputSettingsPanel;
    }

    private void updateOutputParameterState() {
        this.outputParamButton.setEnabled(!this.reprojectionModel.preserveResolution && this.crs != null);
        this.updateProductSize();
    }

    private JPanel createSourceProductPanel() {
        JPanel panel = this.sourceProductSelector.createDefaultPanel();
        this.sourceProductSelector.getProductNameLabel().setText("Name:");
        this.sourceProductSelector.getProductNameComboBox().setPrototypeDisplayValue("MER_RR__1PPBCM20030730_071000_000003972018_00321_07389_0000.N1");
        this.sourceProductSelector.addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                Product sourceProduct = ReprojectionForm.this.getSourceProduct();
                ReprojectionForm.this.updateTargetProductName(sourceProduct);
                GeoPos centerGeoPos = null;
                if (sourceProduct != null) {
                    centerGeoPos = ProductUtils.getCenterGeoPos((Product)sourceProduct);
                }
                ReprojectionForm.this.infoForm.setCenterPos(centerGeoPos);
                if (ReprojectionForm.this.outputGeometryModel != null) {
                    ReprojectionForm.this.outputGeometryModel.setSourceProduct(sourceProduct);
                }
                ReprojectionForm.this.updateCRS();
            }
        });
        return panel;
    }

    private void updateTargetProductName(Product selectedProduct) {
        TargetProductSelectorModel selectorModel = this.targetProductSelector.getModel();
        if (selectedProduct != null) {
            String productName = MessageFormat.format("{0}_" + this.targetProductSuffix, selectedProduct.getName());
            selectorModel.setProductName(productName);
        } else if (selectorModel.getProductName() == null) {
            selectorModel.setProductName(this.targetProductSuffix);
        }
    }

    private void showWarningMessage(String message) {
        AbstractDialog.showWarningDialog((Component)this.getParent(), (String)message, (String)"Reprojection");
    }

    static /* synthetic */ String[] access$2000() {
        return RESAMPLING_IDENTIFIER;
    }

    private static class GeoCodingProductFilter
    implements ProductFilter {
        private GeoCodingProductFilter() {
        }

        public boolean accept(Product product) {
            GeoCoding geoCoding = product.getSceneGeoCoding();
            return geoCoding != null && geoCoding.canGetGeoPos() && geoCoding.canGetPixelPos();
        }
    }

    private static class OrthorectifyProductFilter
    implements ProductFilter {
        private OrthorectifyProductFilter() {
        }

        public boolean accept(Product product) {
            return product.canBeOrthorectified();
        }
    }

    private static class Model {
        private static final String PRESERVE_RESOLUTION = "preserveResolution";
        private static final String REPROJ_TIEPOINTS = "includeTiePointGrids";
        private static final String ADD_DELTA_BANDS = "addDeltaBands";
        private static final String NO_DATA_VALUE = "noDataValue";
        private static final String RESAMPLING_NAME = "resamplingName";
        private boolean preserveResolution = true;
        private boolean includeTiePointGrids = true;
        private boolean addDeltaBands = false;
        private double noDataValue = Double.NaN;
        private String resamplingName = ReprojectionForm.access$2000()[0];

        private Model() {
        }
    }

    private class OutputParametersDialog
    extends ModalDialog {
        private static final String TITLE = "Output Parameters";
        private final Product sourceProduct;
        private final OutputGeometryFormModel outputGeometryFormModel;

        public OutputParametersDialog(Window parent, Product sourceProduct, OutputGeometryFormModel outputGeometryFormModel) {
            super(parent, TITLE, 97, null);
            this.sourceProduct = sourceProduct;
            this.outputGeometryFormModel = outputGeometryFormModel;
        }

        protected void onReset() {
            Product collocationProduct = ReprojectionForm.this.collocationCrsUI.getCollocationProduct();
            ImageGeometry imageGeometry = ReprojectionForm.this.collocationCrsUI.getRadioButton().isSelected() && collocationProduct != null ? ImageGeometry.createCollocationTargetGeometry((Product)this.sourceProduct, (Product)collocationProduct) : ImageGeometry.createTargetGeometry((Product)this.sourceProduct, (CoordinateReferenceSystem)ReprojectionForm.this.crs, null, null, null, null, null, null, null, null, null);
            this.outputGeometryFormModel.resetToDefaults(imageGeometry);
        }
    }

    private class OutputParamActionListener
    implements ActionListener {
        private OutputParamActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                OutputGeometryFormModel workCopy;
                Product sourceProduct = ReprojectionForm.this.getSourceProduct();
                if (sourceProduct == null) {
                    ReprojectionForm.this.showWarningMessage("Please select a product to reproject.\n");
                    return;
                }
                if (ReprojectionForm.this.crs == null) {
                    ReprojectionForm.this.showWarningMessage("Please specify a 'Coordinate Reference System' first.\n");
                    return;
                }
                if (ReprojectionForm.this.outputGeometryModel != null) {
                    workCopy = new OutputGeometryFormModel(ReprojectionForm.this.outputGeometryModel);
                } else {
                    Product collocationProduct = ReprojectionForm.this.collocationCrsUI.getCollocationProduct();
                    workCopy = ReprojectionForm.this.collocationCrsUI.getRadioButton().isSelected() && collocationProduct != null ? new OutputGeometryFormModel(sourceProduct, collocationProduct) : new OutputGeometryFormModel(sourceProduct, ReprojectionForm.this.crs);
                }
                OutputGeometryForm form = new OutputGeometryForm(workCopy);
                OutputParametersDialog outputParametersDialog = new OutputParametersDialog(ReprojectionForm.this.appContext.getApplicationWindow(), sourceProduct, workCopy);
                outputParametersDialog.setContent((Component)form);
                if (outputParametersDialog.show() == 1) {
                    ReprojectionForm.this.outputGeometryModel = workCopy;
                    ReprojectionForm.this.updateProductSize();
                }
            }
            catch (Exception e) {
                ReprojectionForm.this.appContext.handleError("Could not create a 'Coordinate Reference System'.\n" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private class InfoForm {
        private JLabel widthLabel;
        private JLabel heightLabel;
        private JLabel centerLatLabel;
        private JLabel centerLonLabel;
        private JLabel crsLabel;
        private String wkt;
        private JButton wktButton;

        private InfoForm() {
        }

        void setWidth(int width) {
            this.widthLabel.setText(Integer.toString(width));
        }

        void setHeight(int height) {
            this.heightLabel.setText(Integer.toString(height));
        }

        void setCenterPos(GeoPos geoPos) {
            if (geoPos != null) {
                this.centerLatLabel.setText(geoPos.getLatString());
                this.centerLonLabel.setText(geoPos.getLonString());
            } else {
                this.centerLatLabel.setText("");
                this.centerLonLabel.setText("");
            }
        }

        void setCrsErrorText(String infoText) {
            this.setCrsInfoText("<html><b>" + infoText + "</b>", null);
        }

        void setCrsInfoText(String infoText, String wkt) {
            this.wkt = wkt;
            this.crsLabel.setText(infoText);
            boolean hasWKT = wkt != null;
            this.wktButton.setEnabled(hasWKT);
        }

        JPanel createUI() {
            this.widthLabel = new JLabel();
            this.heightLabel = new JLabel();
            this.centerLatLabel = new JLabel();
            this.centerLonLabel = new JLabel();
            this.crsLabel = new JLabel();
            TableLayout tableLayout = new TableLayout(5);
            tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
            tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
            tableLayout.setTablePadding(4, 4);
            tableLayout.setColumnWeightX(0, Double.valueOf(0.0));
            tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
            tableLayout.setColumnWeightX(2, Double.valueOf(1.0));
            tableLayout.setColumnWeightX(3, Double.valueOf(0.0));
            tableLayout.setColumnWeightX(4, Double.valueOf(1.0));
            tableLayout.setCellColspan(2, 1, Integer.valueOf(3));
            tableLayout.setCellPadding(0, 3, new Insets(4, 24, 4, 20));
            tableLayout.setCellPadding(1, 3, new Insets(4, 24, 4, 20));
            JPanel panel = new JPanel((LayoutManager)tableLayout);
            panel.setBorder(BorderFactory.createTitledBorder("Output Information"));
            panel.add(new JLabel("Scene width:"));
            panel.add(this.widthLabel);
            panel.add(new JLabel("pixel"));
            panel.add(new JLabel("Center longitude:"));
            panel.add(this.centerLonLabel);
            panel.add(new JLabel("Scene height:"));
            panel.add(this.heightLabel);
            panel.add(new JLabel("pixel"));
            panel.add(new JLabel("Center latitude:"));
            panel.add(this.centerLatLabel);
            panel.add(new JLabel("CRS:"));
            panel.add(this.crsLabel);
            this.wktButton = new JButton("Show WKT");
            this.wktButton.addActionListener(e -> {
                JTextArea wktArea = new JTextArea(30, 40);
                wktArea.setEditable(false);
                wktArea.setText(this.wkt);
                JScrollPane scrollPane = new JScrollPane(wktArea);
                ModalDialog dialog = new ModalDialog(ReprojectionForm.this.appContext.getApplicationWindow(), "Coordinate reference system as well known text", (Object)scrollPane, 1, null);
                dialog.show();
            });
            this.wktButton.setEnabled(false);
            panel.add(this.wktButton);
            return panel;
        }
    }
}

