/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.reproject;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValidationException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.ParameterUpdater;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.reproject.ReprojectionForm;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DefaultAppContext;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ReprojectionDialog
extends SingleTargetProductDialog {
    private static final String OPERATOR_NAME = "Reproject";
    private final ReprojectionForm form;

    public static void main(String[] args) {
        DefaultAppContext context = new DefaultAppContext("Reproj");
        ReprojectionDialog dialog = new ReprojectionDialog(true, "ReproTestDialog", null, (AppContext)context);
        dialog.show();
    }

    ReprojectionDialog(boolean orthorectify, String title, String helpID, AppContext appContext) {
        super(appContext, title, 24, helpID);
        this.form = new ReprojectionForm(this.getTargetProductSelector(), orthorectify, appContext);
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(OPERATOR_NAME);
        ReprojectionParameterUpdater parameterUpdater = new ReprojectionParameterUpdater();
        OperatorParameterSupport parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor(), null, null, (ParameterUpdater)parameterUpdater);
        OperatorMenu operatorMenu = new OperatorMenu(this.getJDialog(), operatorSpi.getOperatorDescriptor(), parameterSupport, appContext, helpID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
    }

    protected boolean verifyUserInput() {
        ElevationModelRegistry elevationModelRegistry;
        ElevationModelDescriptor demDescriptor;
        if (this.form.getSourceProduct() == null) {
            this.showErrorDialog("No product to reproject selected.");
            return false;
        }
        CoordinateReferenceSystem crs = this.form.getSelectedCrs();
        if (crs == null) {
            this.showErrorDialog("No 'Coordinate Reference System' selected.");
            return false;
        }
        String externalDemName = this.form.getExternalDemName();
        if (externalDemName != null && (demDescriptor = (elevationModelRegistry = ElevationModelRegistry.getInstance()).getDescriptor(externalDemName)) == null) {
            this.showErrorDialog("The DEM '" + externalDemName + "' is not supported.");
            this.close();
            return false;
        }
        return true;
    }

    @Override
    protected Product createTargetProduct() throws Exception {
        Map<String, Product> productMap = this.form.getProductMap();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        this.form.updateParameterMap(parameterMap);
        return GPF.createProduct((String)OPERATOR_NAME, parameterMap, productMap);
    }

    public int show() {
        this.form.prepareShow();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareHide();
        super.hide();
    }

    private class ReprojectionParameterUpdater
    implements ParameterUpdater {
        private ReprojectionParameterUpdater() {
        }

        @Override
        public void handleParameterSaveRequest(Map<String, Object> parameterMap) {
            ReprojectionDialog.this.form.updateParameterMap(parameterMap);
        }

        @Override
        public void handleParameterLoadRequest(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
            ReprojectionDialog.this.form.updateFormModel(parameterMap);
        }
    }
}

