/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.accessors.MapEntryAccessor;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.common.MosaicOp;
import org.esa.snap.core.gpf.ui.mosaic.MosaicForm;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.ui.WorldMapPaneDataModel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class MosaicFormModel {
    public static final String PROPERTY_UPDATE_PRODUCT = "updateProduct";
    public static final String PROPERTY_UPDATE_MODE = "updateMode";
    public static final String PROPERTY_SHOW_SOURCE_PRODUCTS = "showSourceProducts";
    public static final String PROPERTY_ELEVATION_MODEL_NAME = "elevationModelName";
    public static final String PROPERTY_ORTHORECTIFY = "orthorectify";
    public static final String PROPERTY_WEST_BOUND = "westBound";
    public static final String PROPERTY_NORTH_BOUND = "northBound";
    public static final String PROPERTY_EAST_BOUND = "eastBound";
    public static final String PROPERTY_SOUTH_BOUND = "southBound";
    public static final String PROPERTY_CRS = "crs";
    public static final String PROPERTY_PIXEL_SIZE_X = "pixelSizeX";
    public static final String PROPERTY_PIXEL_SIZE_Y = "pixelSizeY";
    public static final String PROPERTY_MAX_VALUE = "maxValue";
    public static final String PROPERTY_MIN_VALUE = "minValue";
    private final PropertySet container;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();
    private final Map<File, Product> sourceProductMap = Collections.synchronizedMap(new HashMap());
    private final WorldMapPaneDataModel worldMapModel = new WorldMapPaneDataModel();
    private MosaicForm parentForm;

    MosaicFormModel(MosaicForm parentForm) {
        this.parentForm = parentForm;
        this.container = ParameterDescriptorFactory.createMapBackedOperatorPropertyContainer((String)"Mosaic", this.parameterMap);
        this.addTransientProperty(PROPERTY_UPDATE_PRODUCT, Product.class);
        this.addTransientProperty(PROPERTY_UPDATE_MODE, Boolean.class);
        this.addTransientProperty(PROPERTY_SHOW_SOURCE_PRODUCTS, Boolean.class);
        this.container.setDefaultValues();
        this.container.setValue(PROPERTY_UPDATE_MODE, (Object)false);
        this.container.setValue(PROPERTY_SHOW_SOURCE_PRODUCTS, (Object)false);
        this.container.addPropertyChangeListener(PROPERTY_SHOW_SOURCE_PRODUCTS, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    Collection products = MosaicFormModel.this.sourceProductMap.values();
                    MosaicFormModel.this.worldMapModel.setProducts(products.toArray(new Product[products.size()]));
                } else {
                    MosaicFormModel.this.worldMapModel.setProducts(null);
                }
            }
        });
    }

    private void addTransientProperty(String propertyName, Class<?> propertyType) {
        PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, propertyType);
        descriptor.setTransient(true);
        this.container.addProperty(new Property(descriptor, (PropertyAccessor)new MapEntryAccessor(this.parameterMap, propertyName)));
    }

    void setSourceProducts(File[] files) throws IOException {
        boolean changeSourceProducts = false;
        if (files != null && files.length > 0) {
            List<File> fileList = Arrays.asList(files);
            Iterator<Map.Entry<File, Product>> iterator = this.sourceProductMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, Product> entry = iterator.next();
                if (fileList.contains(entry.getKey())) continue;
                Product product = entry.getValue();
                this.worldMapModel.removeProduct(product);
                iterator.remove();
                product.dispose();
                changeSourceProducts = true;
            }
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                Product product = this.sourceProductMap.get(file);
                if (product == null) {
                    product = ProductIO.readProduct((File)file);
                    this.sourceProductMap.put(file, product);
                    if (Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_SHOW_SOURCE_PRODUCTS))) {
                        this.worldMapModel.addProduct(product);
                    }
                    changeSourceProducts = true;
                }
                int refNo = i + 1;
                if (product.getRefNo() == refNo) continue;
                product.resetRefNo();
                product.setRefNo(refNo);
            }
        }
        if (changeSourceProducts) {
            this.updateRegionSelectableMapBounds(files);
        }
    }

    void updateRegionSelectableMapBounds(File[] files) {
        double southBoundVal = 35.0;
        double northBoundVal = 75.0;
        double westBoundVal = -15.0;
        double eastBoundVal = 30.0;
        if (files.length >= 1 && this.sourceProductMap.get(files[0]) != null) {
            southBoundVal = this.computeLatitude(this.sourceProductMap.get(files[0]), PROPERTY_MIN_VALUE);
            northBoundVal = this.computeLatitude(this.sourceProductMap.get(files[0]), PROPERTY_MAX_VALUE);
            westBoundVal = this.computeLongitude(this.sourceProductMap.get(files[0]), PROPERTY_MIN_VALUE);
            eastBoundVal = this.computeLongitude(this.sourceProductMap.get(files[0]), PROPERTY_MAX_VALUE);
        }
        for (int i = 1; i < files.length; ++i) {
            if (this.sourceProductMap.get(files[i]) == null) continue;
            double southBoundValTemp = this.computeLatitude(this.sourceProductMap.get(files[i]), PROPERTY_MIN_VALUE);
            double northBoundValTemp = this.computeLatitude(this.sourceProductMap.get(files[i]), PROPERTY_MAX_VALUE);
            double westBoundValTemp = this.computeLongitude(this.sourceProductMap.get(files[i]), PROPERTY_MIN_VALUE);
            double eastBoundValTemp = this.computeLongitude(this.sourceProductMap.get(files[i]), PROPERTY_MAX_VALUE);
            if (southBoundValTemp < southBoundVal) {
                southBoundVal = southBoundValTemp;
            }
            if (northBoundValTemp > northBoundVal) {
                northBoundVal = northBoundValTemp;
            }
            if (westBoundValTemp < westBoundVal) {
                westBoundVal = westBoundValTemp;
            }
            if (!(eastBoundValTemp > eastBoundVal)) continue;
            eastBoundVal = eastBoundValTemp;
        }
        this.parentForm.setCardinalBounds(southBoundVal, northBoundVal, westBoundVal, eastBoundVal);
    }

    double computeLatitude(Product product, String level) {
        Double[] latitudePoints = new Double[]{product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, 0.0), null).getLat(), product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, (double)product.getSceneRasterHeight()), null).getLat(), product.getSceneGeoCoding().getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), 0.0), null).getLat(), product.getSceneGeoCoding().getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight()), null).getLat()};
        switch (level) {
            case "minValue": {
                return Collections.min(Arrays.asList(latitudePoints));
            }
            case "maxValue": {
                return Collections.max(Arrays.asList(latitudePoints));
            }
        }
        return Double.MAX_VALUE;
    }

    double computeLongitude(Product product, String level) {
        Double[] longitudePoints = new Double[]{product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, 0.0), null).getLon(), product.getSceneGeoCoding().getGeoPos(new PixelPos(0.0, (double)product.getSceneRasterHeight()), null).getLon(), product.getSceneGeoCoding().getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), 0.0), null).getLon(), product.getSceneGeoCoding().getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight()), null).getLon()};
        switch (level) {
            case "minValue": {
                return Collections.min(Arrays.asList(longitudePoints));
            }
            case "maxValue": {
                return Collections.max(Arrays.asList(longitudePoints));
            }
        }
        return Double.MAX_VALUE;
    }

    Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    Map<String, Product> getSourceProductMap() {
        Product updateProduct;
        HashMap<String, Product> map = new HashMap<String, Product>(this.sourceProductMap.size());
        for (Product product : this.sourceProductMap.values()) {
            map.put("sourceProduct" + product.getRefNo(), product);
        }
        if (Boolean.TRUE.equals(this.container.getValue(PROPERTY_UPDATE_MODE)) && (updateProduct = this.getUpdateProduct()) != null) {
            map.put(PROPERTY_UPDATE_PRODUCT, updateProduct);
        }
        return map;
    }

    boolean isUpdateMode() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_UPDATE_MODE));
    }

    Product getUpdateProduct() {
        Object value = this.getPropertyValue(PROPERTY_UPDATE_PRODUCT);
        if (value instanceof Product) {
            return (Product)value;
        }
        return null;
    }

    void setUpdateProduct(Product product) {
        this.setPropertyValue(PROPERTY_UPDATE_PRODUCT, product);
        if (product != null && product.getSceneGeoCoding() != null && product.getSceneGeoCoding().getMapCRS() != null) {
            this.setTargetCRS(product.getSceneGeoCoding().getMapCRS().toWKT());
        }
    }

    MosaicOp.Variable[] getVariables() {
        return (MosaicOp.Variable[])this.getPropertyValue("variables");
    }

    MosaicOp.Condition[] getConditions() {
        return (MosaicOp.Condition[])this.getPropertyValue("conditions");
    }

    PropertySet getPropertySet() {
        return this.container;
    }

    public Object getPropertyValue(String propertyName) {
        return this.container.getValue(propertyName);
    }

    public void setPropertyValue(String propertyName, Object value) {
        this.container.setValue(propertyName, value);
    }

    public Product getReferenceProduct() throws IOException {
        for (Product product : this.sourceProductMap.values()) {
            if (product.getRefNo() != 1) continue;
            return product;
        }
        return null;
    }

    public Product getBoundaryProduct() throws FactoryException, TransformException {
        CoordinateReferenceSystem mapCRS = this.getTargetCRS();
        if (mapCRS != null) {
            ReferencedEnvelope envelope = this.getTargetEnvelope();
            ReferencedEnvelope mapEnvelope = envelope.transform(mapCRS, true);
            double pixelSizeX = (Double)this.getPropertyValue(PROPERTY_PIXEL_SIZE_X);
            double pixelSizeY = (Double)this.getPropertyValue(PROPERTY_PIXEL_SIZE_Y);
            int w = MathUtils.floorInt((double)(mapEnvelope.getSpan(0) / pixelSizeX));
            int h = MathUtils.floorInt((double)(mapEnvelope.getSpan(1) / pixelSizeY));
            Product product = new Product("mosaic", "MosaicBounds", w, h);
            CrsGeoCoding geoCoding = new CrsGeoCoding(mapCRS, w, h, mapEnvelope.getMinimum(0), mapEnvelope.getMaximum(1), pixelSizeX, pixelSizeY);
            product.setSceneGeoCoding((GeoCoding)geoCoding);
            return product;
        }
        return null;
    }

    void setTargetCRS(String crs) {
        this.setPropertyValue(PROPERTY_CRS, crs);
    }

    CoordinateReferenceSystem getTargetCRS() throws FactoryException {
        String crs = (String)this.getPropertyValue(PROPERTY_CRS);
        if (crs == null) {
            return null;
        }
        try {
            return CRS.parseWKT((String)crs);
        }
        catch (FactoryException ignored) {
            return CRS.decode((String)crs, (boolean)true);
        }
    }

    ReferencedEnvelope getTargetEnvelope() {
        double west = (Double)this.getPropertyValue(PROPERTY_WEST_BOUND);
        double north = (Double)this.getPropertyValue(PROPERTY_NORTH_BOUND);
        double east = (Double)this.getPropertyValue(PROPERTY_EAST_BOUND);
        double south = (Double)this.getPropertyValue(PROPERTY_SOUTH_BOUND);
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        bounds.setFrameFromDiagonal(west, north, east, south);
        return new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public WorldMapPaneDataModel getWorldMapModel() {
        return this.worldMapModel;
    }

    public String getElevationModelName() {
        boolean orthorectify = (Boolean)this.getPropertyValue(PROPERTY_ORTHORECTIFY);
        if (orthorectify) {
            return (String)this.getPropertyValue(PROPERTY_ELEVATION_MODEL_NAME);
        }
        return null;
    }
}

