/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui.mosaic;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.mosaic.ConditionsTableAdapter;
import org.esa.snap.core.gpf.ui.mosaic.MosaicFormModel;
import org.esa.snap.core.gpf.ui.mosaic.VariablesTableAdapter;
import org.esa.snap.core.jexp.impl.Tokenizer;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.core.util.MouseEventFilterFactory;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.BandChooser;
import org.esa.snap.ui.product.ProductExpressionPane;
import org.esa.snap.ui.tool.ToolButtonFactory;

class MosaicExpressionsPanel
extends JPanel {
    private static final int PREFERRED_TABLE_WIDTH = 520;
    private final AppContext appContext;
    private final BindingContext bindingCtx;
    private JTable variablesTable;
    private JTable conditionsTable;
    private MosaicFormModel mosaicModel;

    MosaicExpressionsPanel(AppContext appContext, MosaicFormModel model) {
        this.appContext = appContext;
        this.mosaicModel = model;
        this.bindingCtx = new BindingContext(model.getPropertySet());
        this.init();
    }

    private void init() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        tableLayout.setTablePadding(3, 3);
        this.setLayout((LayoutManager)tableLayout);
        this.add(this.createVariablesPanel());
        this.add(this.createConditionsPanel());
    }

    private Component createVariablesPanel() {
        String labelName = "Variables";
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTablePadding(3, 3);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(1.0));
        layout.setRowWeightY(0, Double.valueOf(0.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Variables"));
        panel.setName("Variables");
        panel.add(this.createVariablesButtonPanel("Variables"));
        panel.add(this.createVariablesTable("Variables"));
        return panel;
    }

    private JPanel createVariablesButtonPanel(String labelName) {
        JPanel variableButtonsPanel = new JPanel(new FlowLayout(0, 5, 0));
        variableButtonsPanel.setName(labelName);
        final Component bandFilterButton = this.createBandFilterButton();
        bandFilterButton.setName(labelName + "_bandFilter");
        variableButtonsPanel.add(bandFilterButton);
        final Component newVariableButton = this.createNewVariableButton();
        newVariableButton.setName(labelName + "_newVariable");
        variableButtonsPanel.add(newVariableButton);
        final Component removeVariableButton = this.createRemoveVariableButton();
        removeVariableButton.setName(labelName + "_removeVariable");
        variableButtonsPanel.add(removeVariableButton);
        final Component moveVariableUpButton = this.createMoveVariableUpButton();
        moveVariableUpButton.setName(labelName + "moveVariableUp");
        variableButtonsPanel.add(moveVariableUpButton);
        final Component moveVariableDownButton = this.createMoveVariableDownButton();
        moveVariableDownButton.setName(labelName + "moveVariableDown");
        variableButtonsPanel.add(moveVariableDownButton);
        this.bindingCtx.addPropertyChangeListener("updateMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = Boolean.FALSE.equals(evt.getNewValue());
                bandFilterButton.setEnabled(enabled);
                newVariableButton.setEnabled(enabled);
                removeVariableButton.setEnabled(enabled);
                moveVariableUpButton.setEnabled(enabled);
                moveVariableDownButton.setEnabled(enabled);
            }
        });
        return variableButtonsPanel;
    }

    private Component createConditionsPanel() {
        String labelName = "Conditions";
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTablePadding(3, 3);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setRowWeightY(1, Double.valueOf(1.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setName("Conditions");
        panel.setBorder(BorderFactory.createTitledBorder("Conditions"));
        JPanel conditionsButtonsPanel = this.createConditionsButtonPanel("Conditions");
        panel.add(conditionsButtonsPanel);
        panel.add(this.createConditionsTable("Conditions"));
        panel.add(this.createCombinePanel());
        return panel;
    }

    private JPanel createConditionsButtonPanel(String labelName) {
        JPanel conditionButtonsPanel = new JPanel(new FlowLayout(0, 5, 0));
        conditionButtonsPanel.setName(labelName);
        final Component newConditionButton = this.createNewConditionButton();
        newConditionButton.setName(labelName + "_newCondition");
        conditionButtonsPanel.add(newConditionButton);
        final Component removeConditionButton = this.createRemoveConditionButton();
        removeConditionButton.setName(labelName + "_removeCondition");
        conditionButtonsPanel.add(removeConditionButton);
        final Component moveConditionUpButton = this.createMoveConditionUpButton();
        moveConditionUpButton.setName(labelName + "moveConditionUp");
        conditionButtonsPanel.add(moveConditionUpButton);
        final Component moveConditionDownButton = this.createMoveConditionDownButton();
        moveConditionDownButton.setName(labelName + "moveConditionDown");
        conditionButtonsPanel.add(moveConditionDownButton);
        this.bindingCtx.addPropertyChangeListener("updateMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = Boolean.FALSE.equals(evt.getNewValue());
                newConditionButton.setEnabled(enabled);
                removeConditionButton.setEnabled(enabled);
                moveConditionUpButton.setEnabled(enabled);
                moveConditionDownButton.setEnabled(enabled);
            }
        });
        return conditionButtonsPanel;
    }

    private JPanel createCombinePanel() {
        JPanel combinePanel = new JPanel(new FlowLayout(0));
        JComboBox combineComboBox = new JComboBox();
        this.bindingCtx.bind("combine", combineComboBox);
        this.bindingCtx.bindEnabledState("combine", false, "updateMode", (Object)true);
        String displayName = this.bindingCtx.getPropertySet().getDescriptor("combine").getDisplayName();
        combinePanel.add(new JLabel(displayName + ":"));
        combinePanel.add(combineComboBox);
        return combinePanel;
    }

    private Component createNewConditionButton() {
        AbstractButton newConditionsButton = MosaicExpressionsPanel.createButton("icons/Plus24.gif", "newCondition");
        newConditionsButton.setToolTipText("Add new processing condition");
        newConditionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rows = MosaicExpressionsPanel.this.conditionsTable.getRowCount();
                MosaicExpressionsPanel.addRow(MosaicExpressionsPanel.this.conditionsTable, new Object[]{"condition_" + rows, "", false});
            }
        });
        return newConditionsButton;
    }

    private Component createRemoveConditionButton() {
        AbstractButton removeConditionButton = MosaicExpressionsPanel.createButton("icons/Minus24.gif", "removeCondition");
        removeConditionButton.setToolTipText("Remove selected rows.");
        removeConditionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MosaicExpressionsPanel.removeRows(MosaicExpressionsPanel.this.conditionsTable, MosaicExpressionsPanel.this.conditionsTable.getSelectedRows());
            }
        });
        return removeConditionButton;
    }

    private Component createMoveConditionUpButton() {
        AbstractButton moveConditionUpButton = MosaicExpressionsPanel.createButton("icons/MoveUp24.gif", "moveConditionUp");
        moveConditionUpButton.setToolTipText("Move up selected rows.");
        moveConditionUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MosaicExpressionsPanel.moveRowsUp(MosaicExpressionsPanel.this.conditionsTable, MosaicExpressionsPanel.this.conditionsTable.getSelectedRows());
            }
        });
        return moveConditionUpButton;
    }

    private Component createMoveConditionDownButton() {
        AbstractButton moveConditionDownButton = MosaicExpressionsPanel.createButton("icons/MoveDown24.gif", "moveConditionDown");
        moveConditionDownButton.setToolTipText("Move down selected rows.");
        moveConditionDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MosaicExpressionsPanel.moveRowsDown(MosaicExpressionsPanel.this.conditionsTable, MosaicExpressionsPanel.this.conditionsTable.getSelectedRows());
            }
        });
        return moveConditionDownButton;
    }

    private JScrollPane createConditionsTable(String labelName) {
        this.conditionsTable = new JTable(){
            private static final long serialVersionUID = 1L;

            public Class getColumnClass(int column) {
                if (column == 2) {
                    return Boolean.class;
                }
                return super.getColumnClass(column);
            }
        };
        this.conditionsTable.setName(labelName);
        this.conditionsTable.setRowSelectionAllowed(true);
        this.bindingCtx.bind("conditions", (ComponentAdapter)new ConditionsTableAdapter(this.conditionsTable));
        this.bindingCtx.bindEnabledState("conditions", false, "updateMode", (Object)true);
        this.conditionsTable.addMouseListener(this.createExpressionEditorMouseListener(this.conditionsTable, true));
        JTableHeader tableHeader = this.conditionsTable.getTableHeader();
        tableHeader.setName(labelName);
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(true);
        TableColumnModel columnModel = this.conditionsTable.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setPreferredWidth(100);
        nameColumn.setCellRenderer(new TCR());
        TableColumn expressionColumn = columnModel.getColumn(1);
        expressionColumn.setPreferredWidth(360);
        expressionColumn.setCellRenderer(new TCR());
        final ExprEditor cellEditor = new ExprEditor(true);
        expressionColumn.setCellEditor(cellEditor);
        this.bindingCtx.addPropertyChangeListener("updateMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = Boolean.FALSE.equals(evt.getNewValue());
                cellEditor.button.setEnabled(enabled);
            }
        });
        TableColumn outputColumn = columnModel.getColumn(2);
        outputColumn.setPreferredWidth(40);
        JScrollPane pane = new JScrollPane(this.conditionsTable);
        pane.setName(labelName);
        pane.setPreferredSize(new Dimension(520, 80));
        return pane;
    }

    private Component createBandFilterButton() {
        AbstractButton variableFilterButton = MosaicExpressionsPanel.createButton("icons/Copy16.gif", "bandButton");
        variableFilterButton.setToolTipText("Choose the bands to process");
        variableFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product product;
                try {
                    product = MosaicExpressionsPanel.this.mosaicModel.getReferenceProduct();
                }
                catch (IOException ioe) {
                    MosaicExpressionsPanel.this.appContext.handleError(ioe.getMessage(), (Throwable)ioe);
                    return;
                }
                if (product != null) {
                    String[] availableBandNames = product.getBandNames();
                    Band[] allBands = product.getBands();
                    Vector<Vector> dataVector = ((DefaultTableModel)MosaicExpressionsPanel.this.variablesTable.getModel()).getDataVector();
                    ArrayList<Band> existingBands = new ArrayList<Band>(dataVector.size());
                    for (Object e2 : dataVector) {
                        Band[] row = (Band[])e2;
                        String name = (String)row.get(0);
                        String expression = (String)row.get(1);
                        if (name == null || expression == null || !StringUtils.contains((String[])availableBandNames, (String)name.trim()) || !name.trim().equals(expression.trim())) continue;
                        existingBands.add(product.getBand(name.trim()));
                    }
                    BandChooser bandChooser = new BandChooser(MosaicExpressionsPanel.this.appContext.getApplicationWindow(), "Band Chooser", null, allBands, existingBands.toArray(new Band[existingBands.size()]), true);
                    if (bandChooser.show() == 1) {
                        Band[] bandArray;
                        for (Band selectedBand : bandArray = bandChooser.getSelectedBands()) {
                            if (!existingBands.contains(selectedBand)) {
                                String name = selectedBand.getName();
                                String expression = Tokenizer.createExternalName((String)name);
                                MosaicExpressionsPanel.addRow(MosaicExpressionsPanel.this.variablesTable, new Object[]{name, expression});
                                continue;
                            }
                            existingBands.remove(selectedBand);
                        }
                        int[] rowsToRemove = new int[]{};
                        Vector<Vector> newDataVector = ((DefaultTableModel)MosaicExpressionsPanel.this.variablesTable.getModel()).getDataVector();
                        for (Band existingBand : existingBands) {
                            String bandName = existingBand.getName();
                            int rowIndex = MosaicExpressionsPanel.getBandRow(newDataVector, bandName);
                            if (rowIndex <= -1) continue;
                            ArrayUtils.addToArray((int[])rowsToRemove, (int)rowIndex);
                        }
                        MosaicExpressionsPanel.removeRows(MosaicExpressionsPanel.this.variablesTable, rowsToRemove);
                    }
                }
            }
        });
        return variableFilterButton;
    }

    private static int getBandRow(List newDataVector, String bandName) {
        for (int i = 0; i < newDataVector.size(); ++i) {
            List row = (List)newDataVector.get(i);
            if (!bandName.equals(row.get(0)) || !bandName.equals(row.get(1))) continue;
            return i;
        }
        return -1;
    }

    private Component createNewVariableButton() {
        AbstractButton newVariableButton = MosaicExpressionsPanel.createButton("icons/Plus24.gif", "newVariable");
        newVariableButton.setToolTipText("Add new processing variable");
        newVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rows = MosaicExpressionsPanel.this.variablesTable.getRowCount();
                MosaicExpressionsPanel.addRow(MosaicExpressionsPanel.this.variablesTable, new Object[]{"variable_" + rows, ""});
            }
        });
        return newVariableButton;
    }

    private Component createRemoveVariableButton() {
        AbstractButton removeVariableButton = MosaicExpressionsPanel.createButton("icons/Minus24.gif", "removeVariable");
        removeVariableButton.setToolTipText("Remove selected rows.");
        removeVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MosaicExpressionsPanel.removeRows(MosaicExpressionsPanel.this.variablesTable, MosaicExpressionsPanel.this.variablesTable.getSelectedRows());
            }
        });
        return removeVariableButton;
    }

    private Component createMoveVariableUpButton() {
        AbstractButton moveVariableUpButton = MosaicExpressionsPanel.createButton("icons/MoveUp24.gif", "moveVariableUp");
        moveVariableUpButton.setToolTipText("Move up selected rows.");
        moveVariableUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MosaicExpressionsPanel.moveRowsUp(MosaicExpressionsPanel.this.variablesTable, MosaicExpressionsPanel.this.variablesTable.getSelectedRows());
            }
        });
        return moveVariableUpButton;
    }

    private Component createMoveVariableDownButton() {
        AbstractButton moveVariableDownButton = MosaicExpressionsPanel.createButton("icons/MoveDown24.gif", "moveVariableDown");
        moveVariableDownButton.setToolTipText("Move down selected rows.");
        moveVariableDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MosaicExpressionsPanel.moveRowsDown(MosaicExpressionsPanel.this.variablesTable, MosaicExpressionsPanel.this.variablesTable.getSelectedRows());
            }
        });
        return moveVariableDownButton;
    }

    private JScrollPane createVariablesTable(String labelName) {
        this.variablesTable = new JTable();
        this.variablesTable.setName(labelName);
        this.variablesTable.setRowSelectionAllowed(true);
        this.bindingCtx.bind("variables", (ComponentAdapter)new VariablesTableAdapter(this.variablesTable));
        this.bindingCtx.bindEnabledState("variables", false, "updateMode", (Object)true);
        this.variablesTable.addMouseListener(this.createExpressionEditorMouseListener(this.variablesTable, false));
        JTableHeader tableHeader = this.variablesTable.getTableHeader();
        tableHeader.setName(labelName);
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(true);
        TableColumnModel columnModel = this.variablesTable.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setPreferredWidth(100);
        nameColumn.setCellRenderer(new TCR());
        TableColumn expressionColumn = columnModel.getColumn(1);
        expressionColumn.setPreferredWidth(400);
        expressionColumn.setCellRenderer(new TCR());
        final ExprEditor exprEditor = new ExprEditor(false);
        expressionColumn.setCellEditor(exprEditor);
        this.bindingCtx.addPropertyChangeListener("updateMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = Boolean.FALSE.equals(evt.getNewValue());
                exprEditor.button.setEnabled(enabled);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.variablesTable);
        scrollPane.setName(labelName);
        scrollPane.setPreferredSize(new Dimension(520, 150));
        return scrollPane;
    }

    private static AbstractButton createButton(String path, String name) {
        AbstractButton button = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)path), (boolean)false);
        button.setName(name);
        return button;
    }

    private MouseListener createExpressionEditorMouseListener(final JTable table, final boolean booleanExpected) {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column;
                if (e.getClickCount() == 2 && (column = table.getSelectedColumn()) == 1) {
                    table.removeEditor();
                    int row = table.getSelectedRow();
                    String[] value = new String[]{(String)table.getValueAt(row, column)};
                    int i = MosaicExpressionsPanel.this.editExpression(value, booleanExpected);
                    if (1 == i) {
                        table.setValueAt(value[0], row, column);
                    }
                }
            }
        };
        return MouseEventFilterFactory.createFilter((MouseListener)mouseListener);
    }

    private int editExpression(String[] value, boolean booleanExpected) {
        Product product;
        try {
            product = this.mosaicModel.getReferenceProduct();
        }
        catch (IOException ioe) {
            this.appContext.handleError(ioe.getMessage(), (Throwable)ioe);
            return 0;
        }
        if (product == null) {
            String msg = "No source product specified.";
            this.appContext.handleError("No source product specified.", (Throwable)new IllegalStateException("No source product specified."));
            return 0;
        }
        ProductExpressionPane pep = booleanExpected ? ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{product}, (Product)product, (PropertyMap)this.appContext.getPreferences()) : ProductExpressionPane.createGeneralExpressionPane((Product[])new Product[]{product}, (Product)product, (PropertyMap)this.appContext.getPreferences());
        pep.setCode(value[0]);
        int i = pep.showModalDialog(this.appContext.getApplicationWindow(), value[0]);
        if (i == 1) {
            value[0] = pep.getCode();
        }
        return i;
    }

    private static void addRow(JTable table, Object[] rowData) {
        table.removeEditor();
        ((DefaultTableModel)table.getModel()).addRow(rowData);
        int row = table.getRowCount() - 1;
        int numCols = table.getColumnModel().getColumnCount();
        for (int i = 0; i < Math.min(numCols, rowData.length); ++i) {
            Object o = rowData[i];
            table.setValueAt(o, row, i);
        }
        MosaicExpressionsPanel.selectRows(table, row, row);
    }

    private static void moveRowsDown(JTable table, int[] rows) {
        int maxRow = table.getRowCount() - 1;
        for (int row1 : rows) {
            if (row1 != maxRow) continue;
            return;
        }
        table.removeEditor();
        int[] selectedRows = (int[])rows.clone();
        for (int i = rows.length - 1; i > -1; --i) {
            int row = rows[i];
            ((DefaultTableModel)table.getModel()).moveRow(row, row, row + 1);
            selectedRows[i] = row + 1;
        }
        MosaicExpressionsPanel.selectRows(table, selectedRows);
    }

    private static void moveRowsUp(JTable table, int[] rows) {
        for (int row1 : rows) {
            if (row1 != 0) continue;
            return;
        }
        table.removeEditor();
        int[] selectedRows = (int[])rows.clone();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            ((DefaultTableModel)table.getModel()).moveRow(row, row, row - 1);
            selectedRows[i] = row - 1;
        }
        MosaicExpressionsPanel.selectRows(table, selectedRows);
    }

    private static void removeRows(JTable table, int[] rows) {
        table.removeEditor();
        for (int i = rows.length - 1; i > -1; --i) {
            int row = rows[i];
            ((DefaultTableModel)table.getModel()).removeRow(row);
        }
    }

    private static void selectRows(JTable table, int[] rows) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.clearSelection();
        for (int row : rows) {
            selectionModel.addSelectionInterval(row, row);
        }
    }

    private static void selectRows(JTable table, int min, int max) {
        int numRows = max + 1 - min;
        if (numRows <= 0) {
            return;
        }
        MosaicExpressionsPanel.selectRows(table, MosaicExpressionsPanel.prepareRows(numRows, min));
    }

    private static int[] prepareRows(int numRows, int min) {
        int[] rows = new int[numRows];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = min + i;
        }
        return rows;
    }

    private static class TCR
    extends JLabel
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        private TCR() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean enabled = table.isEnabled();
            this.setText((String)value);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else if (!enabled) {
                super.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                super.setBackground(table.getBackground());
            } else {
                super.setForeground(table.getForeground());
                super.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setValue(value);
            return this;
        }

        private void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }

    private class ExprEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button = new JButton("...");
        private String[] value;

        private ExprEditor(final boolean booleanExpected) {
            Dimension preferredSize = this.button.getPreferredSize();
            preferredSize.setSize(25.0, preferredSize.getHeight());
            this.button.setPreferredSize(preferredSize);
            this.value = new String[1];
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = MosaicExpressionsPanel.this.editExpression(ExprEditor.this.value, booleanExpected);
                    if (i == 1) {
                        ExprEditor.this.fireEditingStopped();
                    } else {
                        ExprEditor.this.fireEditingCanceled();
                    }
                }
            };
            this.button.addActionListener(actionListener);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value[0];
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JPanel renderPanel = new JPanel(new BorderLayout());
            DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
            Component label = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            renderPanel.add(label);
            renderPanel.add((Component)this.button, "East");
            this.value[0] = (String)value;
            return renderPanel;
        }
    }
}

