/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.ui.ModelessDialog;

public class DefaultOperatorAction
extends AbstractSnapAction {
    private static final Set<String> KNOWN_KEYS = new HashSet<String>(Arrays.asList("displayName", "operatorName", "dialogTitle", "helpId", "targetProductNameSuffix"));
    private ModelessDialog dialog;

    public static DefaultOperatorAction create(Map<String, Object> properties) {
        DefaultOperatorAction action = new DefaultOperatorAction();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!KNOWN_KEYS.contains(entry.getKey())) continue;
            action.putValue(entry.getKey(), entry.getValue());
        }
        return action;
    }

    public String getOperatorName() {
        Object value = this.getValue("operatorName");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setOperatorName(String operatorName) {
        this.putValue("operatorName", operatorName);
    }

    public String getDialogTitle() {
        Object value = this.getValue("dialogTitle");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setDialogTitle(String dialogTitle) {
        this.putValue("dialogTitle", dialogTitle);
    }

    public String getTargetProductNameSuffix() {
        Object value = this.getValue("targetProductNameSuffix");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setTargetProductNameSuffix(String targetProductNameSuffix) {
        this.putValue("targetProductNameSuffix", targetProductNameSuffix);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = this.createOperatorDialog();
        }
        this.dialog.show();
    }

    protected ModelessDialog createOperatorDialog() {
        DefaultSingleTargetProductDialog productDialog = new DefaultSingleTargetProductDialog(this.getOperatorName(), this.getAppContext(), this.getDialogTitle(), this.getHelpId());
        if (this.getTargetProductNameSuffix() != null) {
            productDialog.setTargetProductNameSuffix(this.getTargetProductNameSuffix());
        }
        return productDialog;
    }
}

