/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractSequenceOfCollections;
import com.bc.ceres.binio.internal.CollectionInstance;
import com.bc.ceres.binio.internal.InstanceFactory;
import java.io.IOException;
import java.util.Arrays;

final class FixSequenceOfVarCollections
extends AbstractSequenceOfCollections {
    private final Type unresolvedElementType;
    private long[] elementOffsets;
    private int maxResolvedElementIndex;
    private CollectionInstance maxResolvedElementInstance;
    private int lastAccessedElementIndex;
    private CollectionInstance lastAccessedElementInstance;
    private long size;

    FixSequenceOfVarCollections(DataContext context, CollectionData parent, SequenceType sequenceType, long position) {
        super(context, parent, sequenceType, position);
        this.unresolvedElementType = sequenceType.getElementType();
        if (this.unresolvedElementType.isSizeKnown()) {
            throw new IllegalArgumentException("sequenceType");
        }
        this.maxResolvedElementIndex = -1;
        this.lastAccessedElementIndex = -1;
        this.size = -1L;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isSizeResolved(int index) {
        return index <= this.maxResolvedElementIndex;
    }

    @Override
    public void resolveSize() throws IOException {
        this.resolveSize(this.getElementCount() - 1);
    }

    @Override
    public void resolveSize(int index) throws IOException {
        if (this.isSizeResolved(index)) {
            return;
        }
        this.ensureElementOffsetsCreated();
        CollectionInstance elementInstance = null;
        int i = this.maxResolvedElementIndex + 1;
        while (i <= index) {
            elementInstance = i == this.lastAccessedElementIndex ? this.lastAccessedElementInstance : this.createElementInstance(this.elementOffsets[i]);
            if (!elementInstance.isSizeResolved()) {
                elementInstance.resolveSize();
            }
            this.elementOffsets[i + 1] = this.elementOffsets[i] + elementInstance.getSize();
            this.maxResolvedElementIndex = i++;
            this.maxResolvedElementInstance = elementInstance;
        }
        if (index == this.getElementCount() - 1) {
            this.size = this.elementOffsets[this.getElementCount()] - this.elementOffsets[0];
        }
    }

    private void ensureElementOffsetsCreated() {
        if (this.elementOffsets == null) {
            this.elementOffsets = new long[this.getElementCount() + 1];
            Arrays.fill(this.elementOffsets, -1L);
            this.elementOffsets[0] = this.getPosition();
        }
    }

    @Override
    public int getElementCount() {
        return this.getType().getElementCount();
    }

    @Override
    public SequenceData getSequence(int index) throws IOException {
        return (SequenceData)((Object)this.createElementInstance(index));
    }

    @Override
    public CompoundData getCompound(int index) throws IOException {
        return (CompoundData)((Object)this.createElementInstance(index));
    }

    private synchronized CollectionInstance createElementInstance(int index) throws IOException {
        if (index > 0) {
            this.ensureSizeResolved(index - 1);
        } else {
            this.ensureElementOffsetsCreated();
        }
        if (index == this.lastAccessedElementIndex) {
            return this.lastAccessedElementInstance;
        }
        CollectionInstance elementInstance = index == this.maxResolvedElementIndex ? this.maxResolvedElementInstance : this.createElementInstance(this.elementOffsets[index]);
        this.lastAccessedElementIndex = index;
        this.lastAccessedElementInstance = elementInstance;
        return elementInstance;
    }

    private CollectionInstance createElementInstance(long position) throws IOException {
        return InstanceFactory.createCollection(this.getContext(), this, this.unresolvedElementType, position, this.getContext().getFormat().getByteOrder());
    }

    @Override
    public void flush() throws IOException {
    }
}

