/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.metadata.AbstractMetadataIO;
import org.esa.snap.raster.gpf.ReplaceMetadataOp;
import org.esa.snap.raster.rcp.actions.Bundle;
import org.esa.snap.raster.rcp.dialogs.StringSelectorDialog;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ReplaceMetadataAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;
    private Product product;

    public ReplaceMetadataAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ReplaceMetadataAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_ReplaceMetadataAction_Text());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ReplaceMetadataAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null) {
            this.product = productNode.getProduct();
            state = this.product.getMetadataRoot() != null;
        }
        this.setEnabled(state);
    }

    public void actionPerformed(ActionEvent event) {
        String[] compatibleProductNames = ReplaceMetadataAction.getCompatibleProducts(this.product);
        if (compatibleProductNames.length == 0) {
            Dialogs.showError((String)"There are not any compatible products currently opened\nDimensions must be the same");
            return;
        }
        StringSelectorDialog dlg = new StringSelectorDialog("Replace Metadata with", compatibleProductNames);
        dlg.show();
        if (dlg.IsOK()) {
            try {
                MetadataElement origAbsRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product);
                int isPolsar = origAbsRoot.getAttributeInt("polsar_data", 0);
                int isCalibrated = origAbsRoot.getAttributeInt("abs_calibration_flag", 0);
                String srcProductName = dlg.getSelectedItem();
                Product[] products = SnapApp.getDefault().getProductManager().getProducts();
                Product srcProduct = null;
                for (Product prod : products) {
                    if (!prod.getDisplayName().equals(srcProductName)) continue;
                    srcProduct = prod;
                    break;
                }
                MetadataElement srcAbsRoot = AbstractMetadata.getAbstractedMetadata(srcProduct);
                File tmpMetadataFile = new File(SystemUtils.getCacheDir(), srcProduct.getName() + "_metadata.xml");
                AbstractMetadataIO.Save((Product)srcProduct, (MetadataElement)srcAbsRoot, (File)tmpMetadataFile);
                String origName = this.product.getName();
                ReplaceMetadataAction.clearProductMetadata(this.product);
                MetadataElement destAbsRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product);
                AbstractMetadataIO.Load((Product)this.product, (MetadataElement)destAbsRoot, (File)tmpMetadataFile);
                this.product.setName(origName);
                ReplaceMetadataOp.resetPolarizations((MetadataElement)AbstractMetadata.getAbstractedMetadata((Product)this.product), (int)isPolsar, (int)isCalibrated);
                tmpMetadataFile.delete();
            }
            catch (Exception e) {
                Dialogs.showError((String)("Unable to save or load metadata\n" + e.getMessage()));
            }
        }
    }

    private static String[] getCompatibleProducts(Product destProduct) {
        Product[] products;
        ArrayList<String> prodList = new ArrayList<String>();
        for (Product p : products = SnapApp.getDefault().getProductManager().getProducts()) {
            if (p == destProduct || p.getSceneRasterWidth() != destProduct.getSceneRasterWidth() || p.getSceneRasterHeight() != destProduct.getSceneRasterHeight()) continue;
            prodList.add(p.getDisplayName());
        }
        return prodList.toArray(new String[prodList.size()]);
    }

    private static void clearProductMetadata(Product product) {
        MetadataElement[] elems;
        String[] tpgNames;
        for (String tpg : tpgNames = product.getTiePointGridNames()) {
            product.removeTiePointGrid(product.getTiePointGrid(tpg));
        }
        MetadataElement root = product.getMetadataRoot();
        for (MetadataElement e : elems = root.getElements()) {
            root.removeElement(e);
        }
        AbstractMetadata.addAbstractedMetadataHeader((MetadataElement)product.getMetadataRoot());
    }
}

