/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.raster.rcp.actions.Bundle;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class AmplitudeToIntensityAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;

    public AmplitudeToIntensityAction() {
        this(Utilities.actionsGlobalContext());
    }

    public AmplitudeToIntensityAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_AmplitudeToIntensityAction_Text());
        this.putValue("ShortDescription", Bundle.CTL_AmplitudeToIntensityAction_Description());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AmplitudeToIntensityAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public void actionPerformed(ActionEvent event) {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band) {
            Band band = (Band)productNode;
            Product product = band.getProduct();
            String bandName = band.getName();
            String unit = band.getUnit();
            if (unit != null && unit.contains("db")) {
                Dialogs.showWarning((String)("Please convert band " + bandName + " from dB to linear first"));
                return;
            }
            if (unit != null && unit.contains("amplitude")) {
                if (product.getBand(bandName = AmplitudeToIntensityAction.replaceName(bandName, "Amplitude", "Intensity")) != null) {
                    Dialogs.showWarning((String)(product.getName() + " already contains an " + bandName + " band"));
                    return;
                }
                if (Dialogs.requestDecision((String)"Convert to Intensity", (String)("Would you like to convert band " + band.getName() + " into Intensity in a new virtual band?"), (boolean)true, null) == Dialogs.Answer.YES) {
                    AmplitudeToIntensityAction.convert(product, band, false);
                }
            } else if (unit != null && unit.contains("intensity")) {
                if (product.getBand(bandName = AmplitudeToIntensityAction.replaceName(bandName, "Intensity", "Amplitude")) != null) {
                    Dialogs.showWarning((String)(product.getName() + " already contains an " + bandName + " band"));
                    return;
                }
                if (Dialogs.requestDecision((String)"Convert to Amplitude", (String)("Would you like to convert band " + band.getName() + " into Amplitude in a new virtual band?"), (boolean)true, null) == Dialogs.Answer.YES) {
                    AmplitudeToIntensityAction.convert(product, band, true);
                }
            }
        }
    }

    public void setEnableState() {
        Band band;
        String unit;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band && (unit = (band = (Band)productNode).getUnit()) != null && (unit.contains("amplitude") || unit.contains("intensity"))) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private static String replaceName(String bandName, String fromName, String toName) {
        bandName = bandName.contains(fromName) ? bandName.replace(fromName, toName) : (bandName.contains("Sigma0") ? bandName.replace("Sigma0", toName) : (bandName.contains("Gamma0") ? bandName.replace("Gamma0", toName) : (bandName.contains("Beta0") ? bandName.replace("Beta0", toName) : toName + '_' + bandName)));
        return bandName;
    }

    public static void convert(Product product, Band band, boolean toAmplitude) {
        String unit;
        String expression;
        String bandName = band.getName();
        if (toAmplitude) {
            expression = "sqrt(" + bandName + ')';
            bandName = AmplitudeToIntensityAction.replaceName(bandName, "Intensity", "Amplitude");
            unit = "amplitude";
        } else {
            expression = bandName + " * " + bandName;
            bandName = AmplitudeToIntensityAction.replaceName(bandName, "Amplitude", "Intensity");
            unit = "intensity";
        }
        VirtualBand virtBand = new VirtualBand(bandName, 30, band.getRasterWidth(), band.getRasterHeight(), expression);
        virtBand.setUnit(unit);
        virtBand.setDescription(band.getDescription());
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
    }
}

