/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.raster.gpf.FilterOperator;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class FilterOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private JTree tree = null;
    private DefaultMutableTreeNode root = null;
    private final JLabel filterLabel = new JLabel("Filters:");
    private final JLabel kernelFileLabel = new JLabel("User Defined Kernel File:");
    private final JTextField kernelFile = new JTextField("");
    private final JButton kernelFileBrowseButton = new JButton("...");

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.kernelFile.setColumns(30);
        this.kernelFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"User Defined Kernel File", (boolean)false, null, (String)"snap.filterDir");
                FilterOpUI.this.kernelFile.setText(file.getAbsolutePath());
            }
        });
        return panel;
    }

    public void initParameters() {
        File kFile;
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])this.getBandNames());
        String filterName = (String)this.paramMap.get("selectedFilterName");
        if (filterName != null) {
            this.setSelectedFilter(filterName);
        }
        if ((kFile = (File)this.paramMap.get("userDefinedKernelFile")) != null) {
            this.kernelFile.setText(kFile.getAbsolutePath());
        }
    }

    public UIValidation validateParameters() {
        if (this.sourceProducts != null && FilterOpUI.getSelectedFilter(this.tree) == null && this.kernelFile.getText().equals("")) {
            return new UIValidation(UIValidation.State.ERROR, "Filter not selected");
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        String kernelFileStr;
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        FilterOperator.Filter filter = FilterOpUI.getSelectedFilter(this.tree);
        if (filter != null) {
            this.paramMap.put("selectedFilterName", filter.toString());
        }
        if (!(kernelFileStr = this.kernelFile.getText()).isEmpty()) {
            this.paramMap.put("userDefinedKernelFile", new File(kernelFileStr));
        }
    }

    private static DefaultMutableTreeNode findItem(DefaultMutableTreeNode parentItem, String filterName) {
        if (!parentItem.isLeaf()) {
            Enumeration<TreeNode> enumeration = parentItem.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                DefaultMutableTreeNode found = FilterOpUI.findItem(treeNode, filterName);
                if (found == null) continue;
                return found;
            }
        }
        if (parentItem.toString().equals(filterName)) {
            return parentItem;
        }
        return null;
    }

    private JComponent createPanel() {
        this.tree = this.createTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeView = new JScrollPane(this.tree);
        JPanel contentPane = new JPanel(new BorderLayout(4, 4));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.weighty = 2.0;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.weighty = 4.0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.filterLabel, (JComponent)treeView);
        gbc.fill = 2;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.kernelFileLabel, (JComponent)this.kernelFile);
        DialogUtils.enableComponents((JComponent)this.kernelFileLabel, (JComponent)this.kernelFile, (boolean)true);
        gbc.gridx = 2;
        contentPane.add((Component)this.kernelFileBrowseButton, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private JTree createTree() {
        this.root = new DefaultMutableTreeNode("@root");
        this.root.add(FilterOpUI.createNodes("Detect Lines", FilterOperator.LINE_DETECTION_FILTERS));
        this.root.add(FilterOpUI.createNodes("Detect Gradients (Emboss)", FilterOperator.GRADIENT_DETECTION_FILTERS));
        this.root.add(FilterOpUI.createNodes("Smooth and Blurr", FilterOperator.SMOOTHING_FILTERS));
        this.root.add(FilterOpUI.createNodes("Sharpen", FilterOperator.SHARPENING_FILTERS));
        this.root.add(FilterOpUI.createNodes("Enhance Discontinuities", FilterOperator.LAPLACIAN_FILTERS));
        JTree tree = new JTree(this.root);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new MyDefaultTreeCellRenderer());
        tree.putClientProperty("JTree.lineStyle", "Angled");
        FilterOpUI.expandAll(tree);
        return tree;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setSelectedFilter(String filterName) {
        DefaultMutableTreeNode item = FilterOpUI.findItem(this.root, filterName);
        if (item != null) {
            this.tree.setSelectionPath(new TreePath(item.getPath()));
        }
    }

    public static FilterOperator.Filter getSelectedFilter(JTree tree) {
        DefaultMutableTreeNode treeNode;
        TreePath selectionPath = tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object[] path = selectionPath.getPath();
        if (path != null && path.length > 0 && (treeNode = (DefaultMutableTreeNode)path[path.length - 1]).getUserObject() instanceof FilterOperator.Filter) {
            return (FilterOperator.Filter)treeNode.getUserObject();
        }
        return null;
    }

    private static DefaultMutableTreeNode createNodes(String categoryName, FilterOperator.Filter[] filters) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(categoryName);
        for (FilterOperator.Filter filter : filters) {
            DefaultMutableTreeNode item = new DefaultMutableTreeNode(filter);
            category.add(item);
        }
        return category;
    }

    private static void expandAll(JTree tree) {
        for (DefaultMutableTreeNode actNode = (DefaultMutableTreeNode)tree.getModel().getRoot(); actNode != null; actNode = actNode.getNextNode()) {
            if (actNode.isLeaf()) continue;
            TreePath actPath = new TreePath(actNode.getPath());
            tree.expandRow(tree.getRowForPath(actPath));
        }
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Font _plainFont;
        private Font _boldFont;

        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this._plainFont == null) {
                this._plainFont = c.getFont().deriveFont(0);
                this._boldFont = c.getFont().deriveFont(1);
            }
            c.setFont(leaf ? this._plainFont : this._boldFont);
            c.setIcon(null);
            return c;
        }
    }
}

