/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Stroke;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;

public class DynamicLineStyle2D
extends LineStyle2D {
    protected SimpleFeature feature;
    protected LineSymbolizer ls;

    public DynamicLineStyle2D(SimpleFeature feature, LineSymbolizer sym) {
        this.feature = feature;
        this.ls = sym;
    }

    @Override
    public Stroke getStroke() {
        org.geotools.styling.Stroke stroke = this.ls.getStroke();
        if (stroke == null) {
            return null;
        }
        String joinType = this.evaluateExpression(stroke.getLineJoin(), this.feature, "miter");
        int joinCode = SLDStyleFactory.lookUpJoin(joinType);
        String capType = this.evaluateExpression(stroke.getLineCap(), this.feature, "square");
        int capCode = SLDStyleFactory.lookUpCap(capType);
        float[] dashes = null;
        if (stroke.dashArray() != null) {
            dashes = new float[stroke.dashArray().size()];
            int index = 0;
            for (Expression expression : stroke.dashArray()) {
                dashes[index] = ((Float)expression.evaluate((Object)this.feature, Float.class)).floatValue();
                ++index;
            }
        }
        float width = ((Float)stroke.getWidth().evaluate((Object)this.feature, Float.class)).floatValue();
        float dashOffset = ((Float)stroke.getDashOffset().evaluate((Object)this.feature, Float.class)).floatValue();
        if (width <= 1.0f) {
            width = 0.0f;
        }
        BasicStroke stroke2d = dashes != null && dashes.length > 0 ? new BasicStroke(width, capCode, joinCode, 1.0f, dashes, dashOffset) : new BasicStroke(width, capCode, joinCode, 1.0f);
        return stroke2d;
    }

    @Override
    public double getPerpendicularOffset() {
        if (this.ls.getPerpendicularOffset() == null) {
            return 0.0;
        }
        Double offset = (Double)this.ls.getPerpendicularOffset().evaluate((Object)this.feature, Double.class);
        if (offset == null) {
            return 0.0;
        }
        return offset;
    }

    @Override
    public Composite getContourComposite() {
        org.geotools.styling.Stroke stroke = this.ls.getStroke();
        if (stroke == null) {
            return null;
        }
        float opacity = ((Float)stroke.getOpacity().evaluate((Object)this.feature, Float.class)).floatValue();
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    @Override
    public Paint getContour() {
        String text;
        org.geotools.styling.Stroke stroke = this.ls.getStroke();
        if (stroke == null) {
            return null;
        }
        Paint contourPaint = (Color)stroke.getColor().evaluate((Object)this.feature, Color.class);
        if (contourPaint == null && (text = (String)stroke.getColor().evaluate((Object)this.feature, String.class)) != null) {
            contourPaint = Color.decode(text);
        }
        Graphic gr = stroke.getGraphicFill();
        SLDStyleFactory fac = new SLDStyleFactory();
        if (gr != null) {
            contourPaint = fac.getTexturePaint(gr, this.feature, (Symbolizer)this.ls);
        }
        return contourPaint;
    }

    private String evaluateExpression(Expression e, SimpleFeature feature, String defaultValue) {
        String result = defaultValue;
        if (e != null && (result = (String)e.evaluate((Object)feature, defaultValue.getClass())) == null) {
            result = defaultValue;
        }
        return result;
    }
}

