/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.composite;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.geotools.renderer.composite.ByteRgbAccessor;
import org.geotools.renderer.composite.IntegerBgrAccessor;
import org.geotools.renderer.composite.IntegerRgbAccessor;
import org.geotools.renderer.composite.PremultiplyAccessor;
import org.geotools.renderer.composite.RgbaAccessor;

public class BlendComposite
implements Composite {
    private static final int SHIFT8 = 8;
    private static final int UBYTE_MAX_VALUE = 255;
    private static final double D_UBYTE_MAX_VALUE = 255.0;
    static final int RED = 0;
    static final int GREEN = 1;
    static final int BLUE = 2;
    static final int ALPHA = 3;
    public static final BlendComposite MULTIPLY_COMPOSITE = new BlendComposite(BlendingMode.MULTIPLY);
    public static final BlendComposite SCREEN_COMPOSITE = new BlendComposite(BlendingMode.SCREEN);
    public static final BlendComposite OVERLAY_COMPOSITE = new BlendComposite(BlendingMode.OVERLAY);
    public static final BlendComposite DARKEN_COMPOSITE = new BlendComposite(BlendingMode.DARKEN);
    public static final BlendComposite LIGHTEN_COMPOSITE = new BlendComposite(BlendingMode.LIGHTEN);
    public static final BlendComposite COLOR_DODGE_COMPOSITE = new BlendComposite(BlendingMode.COLOR_DODGE);
    public static final BlendComposite COLOR_BURN_COMPOSITE = new BlendComposite(BlendingMode.COLOR_BURN);
    public static final BlendComposite HARD_LIGHT_COMPOSITE = new BlendComposite(BlendingMode.HARD_LIGHT);
    public static final BlendComposite SOFT_LIGHT_COMPOSITE = new BlendComposite(BlendingMode.SOFT_LIGHT);
    public static final BlendComposite DIFFERENCE_COMPOSITE = new BlendComposite(BlendingMode.DIFFERENCE);
    public static final BlendComposite EXCLUSION_COMPOSITE = new BlendComposite(BlendingMode.EXCLUSION);
    private final float alpha;
    private final BlendingMode blend;

    private BlendComposite(BlendingMode blend) {
        this(blend, 1.0f);
    }

    private BlendComposite(BlendingMode blend, float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha value out of range");
        }
        this.blend = blend;
        this.alpha = alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new BlendingContext(this, srcColorModel, dstColorModel);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public BlendingMode getBlend() {
        return this.blend;
    }

    public static Composite geteInstance(BlendingMode mode) {
        return BlendComposite.getInstance(mode, 1.0f);
    }

    public static Composite getInstance(BlendingMode mode, float opacity) {
        if (opacity == 1.0f) {
            switch (mode) {
                case MULTIPLY: {
                    return MULTIPLY_COMPOSITE;
                }
                case SCREEN: {
                    return SCREEN_COMPOSITE;
                }
                case OVERLAY: {
                    return OVERLAY_COMPOSITE;
                }
                case DARKEN: {
                    return DARKEN_COMPOSITE;
                }
                case LIGHTEN: {
                    return LIGHTEN_COMPOSITE;
                }
                case COLOR_DODGE: {
                    return COLOR_DODGE_COMPOSITE;
                }
                case COLOR_BURN: {
                    return COLOR_BURN_COMPOSITE;
                }
                case HARD_LIGHT: {
                    return HARD_LIGHT_COMPOSITE;
                }
                case SOFT_LIGHT: {
                    return SOFT_LIGHT_COMPOSITE;
                }
                case DIFFERENCE: {
                    return DIFFERENCE_COMPOSITE;
                }
                case EXCLUSION: {
                    return EXCLUSION_COMPOSITE;
                }
            }
        }
        return new BlendComposite(mode, opacity);
    }

    private static class BlendingContext
    implements CompositeContext {
        protected final BlendComposite composite;
        ColorModel srcColorModel;
        ColorModel dstColorModel;

        private BlendingContext(BlendComposite composite, ColorModel srcColorModel, ColorModel dstColorModel) {
            this.composite = composite;
            this.srcColorModel = srcColorModel;
            this.dstColorModel = dstColorModel;
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            float alpha = this.composite.getAlpha();
            int[] pixel = new int[4];
            RgbaAccessor srcAccessor = this.getAccessor(src, this.srcColorModel);
            RgbaAccessor dstAccessor = this.getAccessor(dstIn, this.dstColorModel);
            for (int y = 0; y < height; ++y) {
                srcAccessor.readRow(y);
                dstAccessor.readRow(y);
                for (int x = 0; x < width; ++x) {
                    srcAccessor.getColor(x, pixel);
                    int sr = pixel[0];
                    int sg = pixel[1];
                    int sb = pixel[2];
                    int sa = pixel[3];
                    dstAccessor.getColor(x, pixel);
                    int dr = pixel[0];
                    int dg = pixel[1];
                    int db = pixel[2];
                    int da = pixel[3];
                    this.composite.getBlend().perform(sr, sg, sb, sa, dr, dg, db, da, pixel);
                    int or = (int)((float)dr + (float)(pixel[0] - dr) * alpha);
                    int og = (int)((float)dg + (float)(pixel[1] - dg) * alpha);
                    int ob = (int)((float)db + (float)(pixel[2] - db) * alpha);
                    int oa = (int)((float)da + (float)(pixel[3] - da) * alpha);
                    dstAccessor.setColor(x, or, og, ob, oa);
                }
                dstAccessor.writeRow(y, dstOut);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private RgbaAccessor getAccessor(Raster raster, ColorModel cm) {
            void var3_8;
            void var3_10;
            if (cm instanceof DirectColorModel && cm.getTransferType() == 3) {
                DirectColorModel dcm = (DirectColorModel)cm;
                if (dcm.getRedMask() == 0xFF0000 && dcm.getGreenMask() == 65280 && dcm.getBlueMask() == 255 && (dcm.getNumComponents() == 3 || dcm.getAlphaMask() == -16777216)) {
                    IntegerRgbAccessor integerRgbAccessor = new IntegerRgbAccessor(raster, cm.hasAlpha());
                } else {
                    if (dcm.getRedMask() != 255 || dcm.getGreenMask() != 65280 || dcm.getBlueMask() != 0xFF0000 || dcm.getNumComponents() != 3 && dcm.getAlphaMask() != -16777216) throw new RasterFormatException("Color model " + cm + " is not supported, cannot perform color blending on it");
                    IntegerBgrAccessor integerBgrAccessor = new IntegerBgrAccessor(raster, cm.hasAlpha());
                }
            } else {
                if (!(cm instanceof ComponentColorModel) || cm.getNumColorComponents() != 3) throw new RasterFormatException("Color model " + cm + " is not supported, cannot perform color blending on it");
                ByteRgbAccessor byteRgbAccessor = new ByteRgbAccessor(raster, cm.hasAlpha());
            }
            if (cm.isAlphaPremultiplied()) return var3_10;
            PremultiplyAccessor premultiplyAccessor = new PremultiplyAccessor((RgbaAccessor)var3_8);
            return var3_10;
        }

        @Override
        public void dispose() {
        }
    }

    public static enum BlendingMode {
        MULTIPLY("multiply"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                result[0] = Math.min(255, sr * dr + sr * d1a + dr * s1a + 255 >> 8);
                result[1] = Math.min(255, sg * dg + sg * d1a + dg * s1a + 255 >> 8);
                result[2] = Math.min(255, sb * db + sb * d1a + db * s1a + 255 >> 8);
                result[3] = Math.min(255, sa + da - (sa * da + 255 >> 8));
            }
        }
        ,
        SCREEN("screen"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                result[0] = sr + dr - (sr * dr + 255 >> 8);
                result[1] = sg + dg - (sg * dg + 255 >> 8);
                result[2] = sb + db - (sb * db + 255 >> 8);
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        OVERLAY("overlay"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                int sada = sa * da;
                result[0] = (2 * dr < da ? 2 * sr * dr + sr * d1a + dr * s1a : sada - 2 * (da - dr) * (sa - sr) + sr * d1a + dr * s1a + 255) >> 8;
                result[1] = (2 * dg < da ? 2 * sg * dg + sg * d1a + dg * s1a : sada - 2 * (da - dg) * (sa - sg) + sg * d1a + dg * s1a + 255) >> 8;
                result[2] = (2 * db < da ? 2 * sb * db + sb * d1a + db * s1a : sada - 2 * (da - db) * (sa - sb) + sb * d1a + db * s1a + 255) >> 8;
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        DARKEN("darken"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                result[0] = Math.min(sr * da, dr * sa) + sr * d1a + dr * s1a + 255 >> 8;
                result[1] = Math.min(sg * da, dg * sa) + sg * d1a + dg * s1a + 255 >> 8;
                result[2] = Math.min(sb * da, db * sa) + sb * d1a + db * s1a + 255 >> 8;
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        LIGHTEN("lighten"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                result[0] = Math.max(sr * da, dr * sa) + sr * d1a + dr * s1a + 255 >> 8;
                result[1] = Math.max(sg * da, dg * sa) + sg * d1a + dg * s1a + 255 >> 8;
                result[2] = Math.max(sb * da, db * sa) + sb * d1a + db * s1a + 255 >> 8;
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        COLOR_DODGE("color-dodge"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                int drsa = dr * sa;
                int dgsa = dg * sa;
                int dbsa = db * sa;
                int srda = sr * da;
                int sgda = sg * da;
                int sbda = sb * da;
                int sada = sa * da;
                result[0] = srda + drsa >= sada ? sada + sr * d1a + dr * s1a + 255 >> 8 : drsa / (255 - (sr << 8) / sa) + (sr * d1a + dr * s1a + 255 >> 8);
                result[1] = sgda + dgsa >= sada ? sada + sg * d1a + dg * s1a + 255 >> 8 : dgsa / (255 - (sg << 8) / sa) + (sg * d1a + dg * s1a + 255 >> 8);
                result[2] = sbda + dbsa >= sada ? sada + sb * d1a + db * s1a + 255 >> 8 : dbsa / (255 - (sb << 8) / sa) + (sb * d1a + db * s1a + 255 >> 8);
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        COLOR_BURN("color-burn"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                int drsa = dr * sa;
                int dgsa = dg * sa;
                int dbsa = db * sa;
                int srda = sr * da;
                int sgda = sg * da;
                int sbda = sb * da;
                int sada = sa * da;
                result[0] = (srda + drsa <= sada ? sr * d1a + dr * s1a : (sr > 0 ? sa * (srda + drsa - sada) / sr + sr * d1a + dr * s1a + 255 : 0)) >> 8;
                result[1] = (sgda + dgsa <= sada ? sg * d1a + dg * s1a : (sg > 0 ? sa * (sgda + dgsa - sada) / sg + sg * d1a + dg * s1a + 255 : 0)) >> 8;
                result[2] = (sbda + dbsa <= sada ? sb * d1a + db * s1a : (sb > 0 ? sa * (sbda + dbsa - sada) / sb + sb * d1a + db * s1a + 255 : 0)) >> 8;
                result[3] = sa + da - (sada + 255 >> 8);
            }
        }
        ,
        HARD_LIGHT("hard-light"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                int sada = sa * da;
                result[0] = (2 * sr < sa ? 2 * sr * dr + sr * d1a + dr * s1a : sada - 2 * (da - dr) * (sa - sr) + sr * d1a + dr * s1a + 255) >> 8;
                result[1] = (2 * sg < sa ? 2 * sg * dg + sg * d1a + dg * s1a : sada - 2 * (da - dg) * (sa - sg) + sg * d1a + dg * s1a + 255) >> 8;
                result[2] = (2 * sb < sa ? 2 * sb * db + sb * d1a + db * s1a : sada - 2 * (da - db) * (sa - sb) + sb * d1a + db * s1a + 255) >> 8;
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        SOFT_LIGHT("soft-light"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                double usr = (double)sr * 1.0 / 255.0;
                double usg = (double)sg * 1.0 / 255.0;
                double usb = (double)sb * 1.0 / 255.0;
                double usa = (double)sa * 1.0 / 255.0;
                double udr = (double)dr * 1.0 / 255.0;
                double udg = (double)dg * 1.0 / 255.0;
                double udb = (double)db * 1.0 / 255.0;
                double uda = (da > 0 ? (double)da * 1.0 : 1.0) / 255.0;
                if (usa > 0.0) {
                    result[0] = (int)Math.round(this.softLight(usr, udr, usa, uda) * 255.0);
                    result[1] = (int)Math.round(this.softLight(usg, udg, usa, uda) * 255.0);
                    result[2] = (int)Math.round(this.softLight(usb, udb, usa, uda) * 255.0);
                    result[3] = sa + da - (sa * da + 255 >> 8);
                } else {
                    result[0] = dr;
                    result[1] = dg;
                    result[2] = db;
                    result[3] = da;
                }
            }

            private double softLight(double sc, double dc, double sa, double da) {
                double result = 2.0 * sc < sa ? dc * (sa + (1.0 - dc / da) * (2.0 * sc - sa)) + sc * (1.0 - da) + dc * (1.0 - sa) : (8.0 * dc <= da ? dc * (sa + (1.0 - dc / da) * (2.0 * sc - sa) * (3.0 - 8.0 * dc / da)) + sc * (1.0 - da) + dc * (1.0 - sa) : dc * sa + (Math.sqrt(dc / da) * da - dc) * (2.0 * sc - sa) + sc * (1.0 - da) + dc * (1.0 - sa));
                return result;
            }
        }
        ,
        DIFFERENCE("difference"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                result[0] = sr + dr - (2 * Math.min(sr * da, dr * sa) + 255 >> 8);
                result[1] = sg + dg - (2 * Math.min(sg * da, dg * sa) + 255 >> 8);
                result[2] = sb + db - (2 * Math.min(sb * da, db * sa) + 255 >> 8);
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        }
        ,
        EXCLUSION("exclusion"){

            @Override
            public void perform(int sr, int sg, int sb, int sa, int dr, int dg, int db, int da, int[] result) {
                int s1a = 255 - sa;
                int d1a = 255 - da;
                result[0] = sr * da + dr * sa - 2 * sr * dr + sr * d1a + dr * s1a + 255 >> 8;
                result[1] = sg * da + dg * sa - 2 * sg * dg + sg * d1a + dg * s1a + 255 >> 8;
                result[2] = sb * da + db * sa - 2 * sb * db + sb * d1a + db * s1a + 255 >> 8;
                result[3] = sa + da - (sa * da + 255 >> 8);
            }
        };

        String name;

        private BlendingMode(String name) {
            this.name = name;
        }

        public abstract void perform(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9);

        public String getName() {
            return this.name;
        }

        public static BlendingMode lookupByName(String name) {
            for (BlendingMode mode : BlendingMode.values()) {
                if (!mode.getName().equals(name)) continue;
                return mode;
            }
            return null;
        }

        public static List<String> getStandardNames() {
            ArrayList<String> result = new ArrayList<String>();
            for (BlendingMode mode : BlendingMode.values()) {
                result.add(mode.getName());
            }
            return result;
        }
    }
}

