/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CanceledException;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.swing.SwingHelper;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.bc.ceres.swing.update.CaselessKey;
import com.bc.ceres.swing.update.ConsistencyChecker;
import com.bc.ceres.swing.update.DefaultModuleManager;
import com.bc.ceres.swing.update.InfoPane;
import com.bc.ceres.swing.update.MissingDependencyInfo;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleManager;
import com.bc.ceres.swing.update.ModuleTableModel;
import com.bc.ceres.swing.update.ModuleTextFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ModuleManagerPane
extends JPanel {
    public static final Runnable NO_DONE_HANDLER = new Runnable(){

        @Override
        public void run() {
        }
    };
    static final String TITLE = "Module Manager";
    private ModuleManager moduleManager;
    private SyncAction syncAction;
    private ClearAction clearAction;
    private InstallAction installAction;
    private UpdateAction updateAction;
    private UninstallAction uninstallAction;
    private JTable[] modulesTables;
    private ModuleTableModel installedModulesTableModel;
    private ModuleTableModel updatableModulesTableModel;
    private ModuleTableModel availableModulesTableModel;
    private boolean syncPerformed;
    private JComboBox<CaselessKey> categories;
    private Set<CaselessKey> categoriesSet;
    private InfoPane infoPane;
    private JTabbedPane tabbedPane;
    private boolean confirmed;
    private String repositoryTroubleShootingMessage;
    private SelectAllAction selectAllAction;

    public ModuleManagerPane() {
        this(new DefaultModuleManager());
    }

    public ModuleManagerPane(ModuleManager moduleManager) {
        super(new BorderLayout(2, 2));
        Assert.notNull((Object)moduleManager, (String)"moduleManager");
        this.moduleManager = moduleManager;
        this.syncAction = new SyncAction();
        this.clearAction = new ClearAction();
        this.installAction = new InstallAction();
        this.updateAction = new UpdateAction();
        this.uninstallAction = new UninstallAction();
        this.selectAllAction = new SelectAllAction();
        this.categoriesSet = new HashSet<CaselessKey>(20);
        this.repositoryTroubleShootingMessage = "";
        this.initUi();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public String getRepositoryTroubleShootingMessage() {
        return this.repositoryTroubleShootingMessage;
    }

    public void setRepositoryTroubleShootingMessage(String repositoryTroubleShootingMessage) {
        Assert.notNull((Object)repositoryTroubleShootingMessage);
        this.repositoryTroubleShootingMessage = repositoryTroubleShootingMessage;
    }

    public boolean showDialog(Window parent, String title, Runnable doneHandler, HelpHandler helpHandler) {
        Assert.notNull((Object)parent, (String)"parent");
        Assert.notNull((Object)title, (String)"title");
        JDialog dialog = this.createDialog(parent, title, doneHandler, helpHandler);
        dialog.setSize(640, 512);
        SwingHelper.centerComponent(dialog, parent);
        dialog.setVisible(true);
        dialog.dispose();
        return this.isConfirmed();
    }

    public JDialog createDialog(Window parent, String title, final Runnable doneHandler, HelpHandler helpHandler) {
        Assert.notNull((Object)parent, (String)"parent");
        Assert.notNull((Object)title, (String)"title");
        final JDialog dialog = new JDialog(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        JPanel buttonPane = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.setName("okButton");
        okButton.setMnemonic('O');
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleManagerPane.this.onOk(dialog, doneHandler);
            }
        });
        buttonPane.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("cancelButton");
        cancelButton.setMnemonic('C');
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleManagerPane.this.onCancel(dialog, doneHandler);
            }
        });
        buttonPane.add(cancelButton);
        if (helpHandler != null) {
            JButton helpButton = new JButton("Help");
            helpButton.setMnemonic('H');
            helpHandler.configureHelpButton(helpButton);
            helpButton.setName("helpButton");
            buttonPane.add(helpButton);
        }
        JPanel contentPane = new JPanel(new BorderLayout(4, 4));
        contentPane.add((Component)this, "Center");
        contentPane.add((Component)buttonPane, "South");
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        okButton.setDefaultCapable(true);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModuleManagerPane.this.onCancel(dialog, doneHandler);
            }
        });
        dialog.setContentPane(contentPane);
        this.setConfirmed(false);
        return dialog;
    }

    private void onOk(JDialog dialog, Runnable doneHandler) {
        if (this.performUpdateActions(doneHandler)) {
            this.setConfirmed(true);
            dialog.setVisible(false);
        } else {
            this.setConfirmed(false);
            doneHandler.run();
        }
    }

    private void onCancel(JDialog dialog, Runnable doneHandler) {
        this.setConfirmed(false);
        dialog.setVisible(false);
        doneHandler.run();
    }

    private void initUi() {
        this.installedModulesTableModel = new ModuleTableModel(this.moduleManager.getInstalledModuleItems(), new String[]{"Name", "Version", "State", "Action"});
        this.updatableModulesTableModel = new ModuleTableModel(this.moduleManager.getUpdatableModuleItems(), new String[]{"Name", "Version", "New Version", "Date", "Size", "Action"});
        this.availableModulesTableModel = new ModuleTableModel(this.moduleManager.getAvailableModuleItems(), new String[]{"Name", "Version", "Date", "Size", "Action"});
        JTable installedModulesTable = this.createModuleTable(this.installedModulesTableModel);
        installedModulesTable.setName("installedModulesTable");
        JTable updatableModulesTable = this.createModuleTable(this.updatableModulesTableModel);
        updatableModulesTable.setName("updatableModulesTable");
        JTable availableModulesTable = this.createModuleTable(this.availableModulesTableModel);
        availableModulesTable.setName("availableModulesTable");
        this.modulesTables = new JTable[]{installedModulesTable, updatableModulesTable, availableModulesTable};
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setName("tabbedPane");
        Component installTab = this.tabbedPane.add("Installed Modules", new JScrollPane(installedModulesTable));
        installTab.setName("InstallTab");
        Component updateTab = this.tabbedPane.add("Module Updates", new JScrollPane(updatableModulesTable));
        updateTab.setName("UpdateTab");
        Component availableTab = this.tabbedPane.add("Available Modules", new JScrollPane(availableModulesTable));
        availableTab.setName("AvailableTab");
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ModuleManagerPane.this.onTabChanged();
            }
        });
        JToolBar actionBar = new JToolBar();
        actionBar.setName("actionBar");
        actionBar.setRollover(true);
        actionBar.setFloatable(false);
        JButton installButton = new JButton(this.installAction);
        installButton.setName("installButton");
        actionBar.add(installButton);
        JButton updateButton = new JButton(this.updateAction);
        updateButton.setName("updateButton");
        actionBar.add(updateButton);
        JButton uninstallButton = new JButton(this.uninstallAction);
        uninstallButton.setName("uninstallButton");
        actionBar.add(uninstallButton);
        JButton clearButton = new JButton(this.clearAction);
        clearButton.setName("clearButton");
        actionBar.add(clearButton);
        this.categories = new JComboBox();
        this.categories.setName("categoriesComboBox");
        this.categories.setEditable(true);
        this.categories.setSelectedItem("");
        this.categories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleManagerPane.this.updateModuleTable();
                ModuleManagerPane.this.updateUiState();
            }
        });
        JPanel categoriesBar = new JPanel(new FlowLayout(0));
        categoriesBar.add(new JLabel("Filter category:"));
        categoriesBar.add(this.categories);
        JPanel tableActionBar = new JPanel(new BorderLayout(4, 4));
        tableActionBar.add((Component)actionBar, "West");
        tableActionBar.add((Component)categoriesBar, "East");
        this.infoPane = new InfoPane();
        JPanel tablePane = new JPanel(new BorderLayout(2, 2));
        tablePane.add((Component)tableActionBar, "North");
        tablePane.add((Component)this.tabbedPane, "Center");
        JSplitPane contentPane = new JSplitPane(0);
        contentPane.setContinuousLayout(true);
        contentPane.setResizeWeight(0.6);
        contentPane.setTopComponent(tablePane);
        contentPane.setBottomComponent(this.infoPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder());
        contentPane.setUI(this.createPlainDividerSplitPaneUI());
        this.add((Component)contentPane, "Center");
        this.setPreferredSize(new Dimension(400, 400));
        this.registerCategories(this.moduleManager.getInstalledModuleItems());
        this.updateCategories();
        this.updateUiState();
    }

    private void onTabChanged() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex != 0 && !this.syncPerformed) {
            this.syncAction.run();
            this.syncPerformed = true;
        }
        this.updateUiState();
    }

    private boolean performUpdateActions(final Runnable doneHandler) {
        ArrayList<ModuleItem> actionList = this.createActionList();
        if (actionList.isEmpty()) {
            doneHandler.run();
            return true;
        }
        MissingDependencyInfo[] missingModuleDependencies = this.getMissingModuleDependencies();
        if (missingModuleDependencies.length > 0) {
            String missingModuleDependenciesMessage = ModuleManagerPane.createMissingModuleDependenciesMessage(missingModuleDependencies);
            this.showErrorDialog(missingModuleDependenciesMessage);
            return false;
        }
        String m = ModuleTextFactory.getActionListText(actionList);
        int a = this.showOkCancelDialog(m);
        if (a != 0) {
            return false;
        }
        ActionPerformer performer = new ActionPerformer(actionList){

            /*
             * Loose catch block
             */
            @Override
            protected void done() {
                block10: {
                    try {
                        boolean success;
                        try {
                            success = (Boolean)this.get();
                        }
                        catch (InterruptedException e) {
                            ModuleManagerPane.this.showErrorDialog("Update action(s) failed:\n" + e.getMessage() + "\n" + "No changes will be performed.\n" + "Try running the software as administrator.");
                            doneHandler.run();
                            return;
                        }
                        catch (ExecutionException e) {
                            ModuleManagerPane.this.showErrorDialog("Update action(s) failed:\n" + e.getCause().getMessage() + "\n" + "No changes will be performed.\n" + "Try running the software as administrator.");
                            doneHandler.run();
                            return;
                        }
                        if (success) {
                            ModuleManagerPane.this.showInfoDialog("Changes will be effective after restart.");
                        } else {
                            ModuleManagerPane.this.showErrorDialog("Update action(s) canceled.\nNo changes will be performed.");
                        }
                        break block10;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        doneHandler.run();
                    }
                }
            }
        };
        performer.execute();
        return true;
    }

    private ArrayList<ModuleItem> createActionList() {
        ArrayList<ModuleItem> actionList = new ArrayList<ModuleItem>(10);
        for (ModuleItem moduleItem : this.moduleManager.getInstalledModuleItems()) {
            if (moduleItem.getAction() != ModuleItem.Action.UNINSTALL) continue;
            actionList.add(moduleItem);
        }
        for (ModuleItem moduleItem : this.moduleManager.getUpdatableModuleItems()) {
            if (moduleItem.getAction() != ModuleItem.Action.UPDATE) continue;
            actionList.add(moduleItem);
        }
        for (ModuleItem moduleItem : this.moduleManager.getAvailableModuleItems()) {
            if (moduleItem.getAction() != ModuleItem.Action.INSTALL) continue;
            actionList.add(moduleItem);
        }
        return actionList;
    }

    private BasicSplitPaneUI createPlainDividerSplitPaneUI() {
        return new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void paint(Graphics g) {
                    }
                };
            }
        };
    }

    private JTable createModuleTable(ModuleTableModel dm) {
        JTable table = new JTable(dm);
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setResizingAllowed(true);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ModuleManagerPane.this.updateUiState();
                }
            }
        });
        table.addMouseListener(new MouseAdapter(){
            private JPopupMenu popupMenu;

            @Override
            public void mouseClicked(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }

            private void checkPopup(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    this.popupMenu = new JPopupMenu();
                    if (ModuleManagerPane.this.installAction.isEnabled()) {
                        this.popupMenu.add(ModuleManagerPane.this.installAction);
                    } else if (ModuleManagerPane.this.updateAction.isEnabled()) {
                        this.popupMenu.add(ModuleManagerPane.this.updateAction);
                    } else if (ModuleManagerPane.this.uninstallAction.isEnabled()) {
                        this.popupMenu.add(ModuleManagerPane.this.uninstallAction);
                    } else if (ModuleManagerPane.this.clearAction.isEnabled()) {
                        this.popupMenu.add(ModuleManagerPane.this.clearAction);
                    }
                    if (this.popupMenu.getComponentCount() > 0) {
                        this.popupMenu.addSeparator();
                    }
                    this.popupMenu.add(ModuleManagerPane.this.selectAllAction);
                    this.popupMenu.show(me.getComponent(), me.getX(), me.getY());
                }
            }
        });
        return table;
    }

    private void updateModuleTable() {
        String filter = this.categories.getSelectedItem().toString();
        this.installedModulesTableModel.setModuleItems(ModuleManagerPane.filterModuleItems(this.moduleManager.getInstalledModuleItems(), filter));
        this.updatableModulesTableModel.setModuleItems(ModuleManagerPane.filterModuleItems(this.moduleManager.getUpdatableModuleItems(), filter));
        this.availableModulesTableModel.setModuleItems(ModuleManagerPane.filterModuleItems(this.moduleManager.getAvailableModuleItems(), filter));
        this.registerCategories(this.moduleManager.getAvailableModuleItems());
        this.updateCategories();
    }

    static ModuleItem[] filterModuleItems(ModuleItem[] moduleItems, String filter) {
        if (!filter.isEmpty()) {
            ArrayList<ModuleItem> filteredModuleItems = new ArrayList<ModuleItem>(moduleItems.length);
            for (ModuleItem moduleItem : moduleItems) {
                if (!ModuleManagerPane.matchesCategory(moduleItem, filter)) continue;
                filteredModuleItems.add(moduleItem);
            }
            moduleItems = filteredModuleItems.toArray(new ModuleItem[filteredModuleItems.size()]);
        }
        Arrays.sort(moduleItems);
        return moduleItems;
    }

    private static boolean matchesCategory(ModuleItem moduleItem, String filter) {
        String[] categories;
        boolean found = false;
        String filterLC = filter.toLowerCase();
        for (String category : categories = moduleItem.getModule().getCategories()) {
            if (!category.toLowerCase().startsWith(filterLC)) continue;
            found = true;
            break;
        }
        return found;
    }

    protected static boolean isCategory(Module module, String category) {
        String[] categories;
        String categoryLC = category.toLowerCase();
        for (String someCategory : categories = module.getCategories()) {
            if (!someCategory.toLowerCase().contains(categoryLC)) continue;
            return true;
        }
        return false;
    }

    private void updateCategories() {
        this.categoriesSet.add(new CaselessKey(""));
        Object[] keys = this.categoriesSet.toArray(new CaselessKey[this.categoriesSet.size()]);
        Arrays.sort(keys);
        String selectedItem = this.categories.getSelectedItem().toString();
        this.categories.setModel(new DefaultComboBoxModel<Object>(keys));
        this.categories.setSelectedItem(selectedItem);
    }

    private void registerCategories(ModuleItem[] moduleItems) {
        for (ModuleItem moduleItem : moduleItems) {
            String[] categories;
            for (String category : categories = moduleItem.getModule().getCategories()) {
                this.categoriesSet.add(new CaselessKey(category));
            }
        }
    }

    private int showOkCancelDialog(String m) {
        return JOptionPane.showConfirmDialog(this, m, TITLE, 2, 1);
    }

    private void showErrorDialog(String m) {
        JOptionPane.showMessageDialog(this, m, TITLE, 0);
    }

    private void showInfoDialog(String m) {
        JOptionPane.showMessageDialog(this, m, TITLE, 1);
    }

    private void updateUiState() {
        boolean clearEnabled = false;
        boolean installEnabled = false;
        boolean updateEnabled = false;
        boolean uninstallEnabled = false;
        ModuleItem[] selectedModuleItems = this.getSelectedModuleItems();
        if (selectedModuleItems.length != 0) {
            installEnabled = true;
            updateEnabled = true;
            uninstallEnabled = true;
            for (ModuleItem selectedModuleItem : selectedModuleItems) {
                if (!selectedModuleItem.getAction().equals((Object)ModuleItem.Action.NONE)) {
                    clearEnabled = true;
                }
                if (!ModuleManagerPane.isAvailableModule(selectedModuleItem)) {
                    installEnabled = false;
                }
                if (!ModuleManagerPane.isModuleUpdate(selectedModuleItem)) {
                    updateEnabled = false;
                }
                if (!ModuleManagerPane.isAvailableModule(selectedModuleItem) && !selectedModuleItem.getModule().getState().equals((Object)ModuleState.UNINSTALLED) && !ModuleManagerPane.isCategory((Module)selectedModuleItem.getModule(), "System")) continue;
                uninstallEnabled = false;
            }
            installEnabled = this.confirmActionEnabled(ModuleItem.Action.INSTALL, installEnabled);
            updateEnabled = this.confirmActionEnabled(ModuleItem.Action.UPDATE, updateEnabled);
            uninstallEnabled = this.confirmActionEnabled(ModuleItem.Action.UNINSTALL, uninstallEnabled);
        }
        this.clearAction.setEnabled(clearEnabled);
        this.installAction.setEnabled(installEnabled);
        this.updateAction.setEnabled(updateEnabled);
        this.uninstallAction.setEnabled(uninstallEnabled);
        this.syncAction.setEnabled(true);
        this.infoPane.setSelectedModuleItems(this.getSelectedModuleItems());
    }

    private boolean confirmActionEnabled(ModuleItem.Action action, boolean enabled) {
        if (enabled) {
            ModuleItem[] selectedModuleItems;
            enabled = false;
            for (ModuleItem moduleItem : selectedModuleItems = this.getSelectedModuleItems()) {
                if (moduleItem.getAction().equals((Object)action)) continue;
                return true;
            }
        }
        return enabled;
    }

    private static boolean isAvailableModule(ModuleItem selectedModuleItem) {
        return selectedModuleItem.getRepositoryModule() != null && selectedModuleItem.getModule() == selectedModuleItem.getRepositoryModule();
    }

    private static boolean isModuleUpdate(ModuleItem selectedModuleItem) {
        return selectedModuleItem.getRepositoryModule() != null && selectedModuleItem.getModule() != selectedModuleItem.getRepositoryModule();
    }

    private ModuleItem[] getSelectedModuleItems() {
        return ModuleManagerPane.getSelectedModuleItems(this.getSelectedTable());
    }

    private JTable getSelectedTable() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        return this.modulesTables[selectedIndex];
    }

    private static ModuleItem[] getSelectedModuleItems(JTable table) {
        int[] rows = table.getSelectedRows();
        ModuleItem[] moduleItems = new ModuleItem[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            moduleItems[i] = ((ModuleTableModel)table.getModel()).getModuleItem(row);
        }
        return moduleItems;
    }

    private MissingDependencyInfo[] getMissingModuleDependencies() {
        ConsistencyChecker consistencyChecker = new ConsistencyChecker(this.moduleManager);
        consistencyChecker.check();
        return consistencyChecker.getMissingDependencies();
    }

    private static String createMissingModuleDependenciesMessage(MissingDependencyInfo[] missingModuleDependencieses) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Inconsistent module set detected.\n\n");
        int lineCount = 0;
        block0: for (MissingDependencyInfo missingModuleDependency : missingModuleDependencieses) {
            Dependency dependency = missingModuleDependency.getDependency();
            Module[] missingDependencyList = missingModuleDependency.getDependentModules();
            sb.append(MessageFormat.format("Unresolved module [{0}], version {1} required by module(s)\n", ModuleTextFactory.getText(dependency.getModuleSymbolicName()), ModuleTextFactory.getText(dependency.getVersion())));
            ++lineCount;
            for (Module module : missingDependencyList) {
                sb.append("-   ");
                if (lineCount <= 8) {
                    sb.append(MessageFormat.format("{0} [{1}], version {2}\n", ModuleTextFactory.getNameText(module), ModuleTextFactory.getText(module.getSymbolicName()), ModuleTextFactory.getVersionText(module)));
                    ++lineCount;
                    continue;
                }
                sb.append("more...\n");
                continue block0;
            }
        }
        sb.append("\n");
        sb.append("Please check related install, update and uninstall actions.");
        return sb.toString();
    }

    private void setActionId(ModuleItem.Action action) {
        ModuleItem[] moduleItems;
        for (ModuleItem moduleItem : moduleItems = this.getSelectedModuleItems()) {
            moduleItem.setAction(action);
        }
        this.onActionChanged();
    }

    private void onActionChanged() {
        this.installedModulesTableModel.fireTableDataChanged();
        this.updatableModulesTableModel.fireTableDataChanged();
        this.availableModulesTableModel.fireTableDataChanged();
        this.updateUiState();
    }

    private void handleRepositoryConnectionFailed(String message) {
        String m = MessageFormat.format("Failed to download module list from module repository:\n{0}\n\n{1}", message, this.getRepositoryTroubleShootingMessage());
        this.showErrorDialog(m);
    }

    public static interface HelpHandler {
        public void configureHelpButton(JButton var1);
    }

    private class ActionPerformer
    extends ProgressMonitorSwingWorker<Boolean, Boolean> {
        private final List<ModuleItem> actionListList;

        public ActionPerformer(List<ModuleItem> actionListList) {
            super(ModuleManagerPane.this, ModuleManagerPane.TITLE);
            this.actionListList = actionListList;
        }

        @Override
        protected Boolean doInBackground(ProgressMonitor pm) throws Exception {
            pm.beginTask("Performing update actions", this.actionListList.size());
            try {
                ModuleManagerPane.this.moduleManager.startTransaction();
                for (ModuleItem actionItem : this.actionListList) {
                    String actionText = ModuleTextFactory.getActionItemText(actionItem);
                    pm.setTaskName(actionText);
                    if (actionItem.getAction() == ModuleItem.Action.INSTALL) {
                        ModuleManagerPane.this.moduleManager.installModule(actionItem.getRepositoryModule(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    } else if (actionItem.getAction() == ModuleItem.Action.UPDATE) {
                        ModuleManagerPane.this.moduleManager.updateModule((Module)actionItem.getModule(), actionItem.getRepositoryModule(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    } else if (actionItem.getAction() == ModuleItem.Action.UNINSTALL) {
                        ModuleManagerPane.this.moduleManager.uninstallModule((Module)actionItem.getModule(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    }
                    if (!pm.isCanceled()) continue;
                    throw new CanceledException();
                }
            }
            catch (CoreException e) {
                ModuleManagerPane.this.moduleManager.rollbackTransaction();
                throw e;
            }
            finally {
                pm.done();
            }
            ModuleManagerPane.this.moduleManager.endTransaction();
            return true;
        }
    }

    static class MissingModuleDependency {
        Dependency dependency;
        List<Module> modules = new ArrayList<Module>(10);

        public MissingModuleDependency(Dependency dependency) {
            this.dependency = dependency;
        }
    }

    private class ModuleListDownloader
    extends ProgressMonitorSwingWorker<Void, Void> {
        public ModuleListDownloader() {
            super(ModuleManagerPane.this, ModuleManagerPane.TITLE);
        }

        @Override
        protected Void doInBackground(ProgressMonitor pm) throws Exception {
            ModuleManagerPane.this.moduleManager.synchronizeWithRepository(pm);
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.get();
            }
            catch (InterruptedException e) {
                ModuleManagerPane.this.handleRepositoryConnectionFailed(e.getMessage());
                return;
            }
            catch (ExecutionException e) {
                ModuleManagerPane.this.handleRepositoryConnectionFailed(e.getCause().getMessage());
                return;
            }
            ModuleManagerPane.this.updateModuleTable();
            ModuleManagerPane.this.updateUiState();
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("ActionCommandKey", this.getClass().getName());
            this.putValue("Name", "Select All");
            this.putValue("MnemonicKey", 65);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
            this.putValue("ShortDescription", "Select all items in table");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/edit-select-all.png")));
            this.putValue("SwingLargeIconKey", this.getValue("SmallIcon"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ModuleManagerPane.this.getSelectedTable().selectAll();
        }
    }

    private class UninstallAction
    extends AbstractAction {
        public UninstallAction() {
            this.putValue("ActionCommandKey", this.getClass().getName());
            this.putValue("Name", "Uninstall");
            this.putValue("MnemonicKey", 78);
            this.putValue("ShortDescription", "Uninstall selected modules");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/list-remove.png")));
            this.putValue("SwingLargeIconKey", this.getValue("SmallIcon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModuleManagerPane.this.setActionId(ModuleItem.Action.UNINSTALL);
        }
    }

    private class UpdateAction
    extends AbstractAction {
        public UpdateAction() {
            this.putValue("ActionCommandKey", this.getClass().getName());
            this.putValue("Name", "Update");
            this.putValue("MnemonicKey", 85);
            this.putValue("ShortDescription", "Update selected modules");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/view-refresh.png")));
            this.putValue("SwingLargeIconKey", this.getValue("SmallIcon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModuleManagerPane.this.setActionId(ModuleItem.Action.UPDATE);
        }
    }

    private class InstallAction
    extends AbstractAction {
        public InstallAction() {
            this.putValue("ActionCommandKey", this.getClass().getName());
            this.putValue("Name", "Install");
            this.putValue("MnemonicKey", 73);
            this.putValue("ShortDescription", "Install the selected modules");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/list-add.png")));
            this.putValue("SwingLargeIconKey", this.getValue("SmallIcon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModuleManagerPane.this.setActionId(ModuleItem.Action.INSTALL);
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            this.putValue("ActionCommandKey", this.getClass().getName());
            this.putValue("Name", "Clear");
            this.putValue("MnemonicKey", 67);
            this.putValue("ShortDescription", "Clear a previous install, update or uninstall action");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/edit-clear.png")));
            this.putValue("SwingLargeIconKey", this.getValue("SmallIcon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModuleManagerPane.this.setActionId(ModuleItem.Action.NONE);
        }
    }

    private class SyncAction
    extends AbstractAction {
        public SyncAction() {
            this.putValue("ActionCommandKey", this.getClass().getName());
            this.putValue("Name", "Synchronize");
            this.putValue("ShortDescription", "Synchronize with remote repository");
            this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("icons/system-software-update.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.run();
        }

        public void run() {
            new ModuleListDownloader().execute();
        }
    }
}

