/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.swing.update.ModuleItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

class InfoPane
extends JPanel {
    private static final String NOT_AVAILABLE = "Not available.";
    private ModuleItem[] selectedModuleItems;
    private JEditorPane infoPanel;

    public InfoPane() {
        this.initUi();
    }

    public void setSelectedModuleItems(ModuleItem[] selectedModuleItems) {
        this.selectedModuleItems = selectedModuleItems;
        this.updateUiState();
    }

    public void updateUiState() {
        if (this.selectedModuleItems.length == 1) {
            ModuleItem currentModule = this.selectedModuleItems[0];
            Object module = currentModule.getRepositoryModule() != null ? currentModule.getRepositoryModule() : currentModule.getModule();
            StringBuilder html = new StringBuilder(1024);
            html.append("<html>");
            html.append("<body>");
            html.append("<p>");
            html.append("<u>Module description:</u><br/>");
            html.append(InfoPane.getTextValue(module.getDescription()));
            html.append("");
            html.append("<p>");
            html.append("<u>Changelog:</u><br/>");
            html.append(InfoPane.getTextValue(module.getChangelog()));
            html.append("");
            html.append("<p>");
            html.append("<u>Vendor information:</u><br/>");
            html.append("<ul>");
            InfoPane.addText(html, "Name", module.getVendor());
            InfoPane.addText(html, "Contact address", module.getContactAddress());
            InfoPane.addText(html, "Copyright", module.getCopyright());
            InfoPane.addUrl(html, "Home page", module.getUrl());
            InfoPane.addUrl(html, "License", module.getLicenseUrl());
            if (module.getFunding() != null && !module.getFunding().trim().isEmpty()) {
                InfoPane.addText(html, "Funding", module.getFunding());
            }
            InfoPane.addUrl(html, "About", module.getAboutUrl());
            html.append("</ul>");
            html.append("");
            html.append("</body>");
            html.append("</html>");
            HTMLDocument document = (HTMLDocument)this.infoPanel.getEditorKit().createDefaultDocument();
            try {
                document.insertAfterStart(document.getRootElements()[0].getElement(0), html.toString());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Can not show description", "Error", 0);
            }
            this.infoPanel.setDocument(document);
        } else if (this.selectedModuleItems.length > 1) {
            this.infoPanel.setText("<html><body></body></html>");
        } else {
            this.infoPanel.setText("<html><body></body></html>");
        }
    }

    private static void addUrl(StringBuilder html, String label, String url) {
        InfoPane.addItem(html, label, InfoPane.getUrlValue(url));
    }

    private static void addText(StringBuilder html, String label, String text) {
        InfoPane.addItem(html, label, InfoPane.getTextValue(text));
    }

    private static void addItem(StringBuilder html, String label, String value) {
        html.append("<li><b>");
        html.append(label);
        html.append(":</b> ");
        html.append(value);
        html.append("</li>");
    }

    private static String getUrlValue(String url) {
        if (!InfoPane.isTextAvailable(url)) {
            return NOT_AVAILABLE;
        }
        StringBuilder html = new StringBuilder(32);
        html.append("<a href=\"");
        html.append(url);
        html.append("\">");
        html.append(url);
        html.append("</a>");
        return html.toString();
    }

    private static String getTextValue(String text) {
        if (!InfoPane.isTextAvailable(text)) {
            return NOT_AVAILABLE;
        }
        return text;
    }

    private static boolean isTextAvailable(String text) {
        return text != null && text.length() != 0;
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.infoPanel = new JEditorPane("text/html", null);
        this.infoPanel.setEditable(false);
        this.infoPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(InfoPane.this, "Failed to open URL:\n" + e.getURL() + ":\n" + e1.getMessage(), "Error", 0);
                    }
                }
            }
        });
        JScrollPane infoPanelScrollPane = new JScrollPane(this.infoPanel);
        this.setBorder(BorderFactory.createTitledBorder("Module Information"));
        this.add((Component)infoPanelScrollPane, "Center");
    }
}

