/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.undo.support;

import com.bc.ceres.swing.undo.UndoContext;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class DefaultUndoContext
implements UndoContext {
    private final UndoManager undoManager;
    private final UndoableEditSupport undoableEditSupport;

    public DefaultUndoContext(Object source) {
        this(source, new UndoManager());
    }

    public DefaultUndoContext(Object source, UndoManager undoManager) {
        this.undoManager = undoManager;
        this.undoableEditSupport = new UndoableEditSupport(source != null ? source : this);
        this.undoableEditSupport.addUndoableEditListener(undoManager);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    @Override
    public void undo() {
        this.undoManager.undo();
    }

    @Override
    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    @Override
    public void redo() {
        this.undoManager.redo();
    }

    @Override
    public void postEdit(UndoableEdit edit) {
        this.undoableEditSupport.postEdit(edit);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditSupport.addUndoableEditListener(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditSupport.removeUndoableEditListener(listener);
    }

    @Override
    public UndoableEditListener[] getUndoableEditListeners() {
        return this.undoableEditSupport.getUndoableEditListeners();
    }
}

