/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.AbstractSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableSelectionContext
extends AbstractSelectionContext {
    private final ListSelectionListener tableSelectionListener;
    private final TableSelectionModelChangeListener selectionModelChangeListener = new TableSelectionModelChangeListener();
    private JTable table;

    public TableSelectionContext(JTable table) {
        this.tableSelectionListener = new TableSelectionListener();
        this.table = table;
        this.installTableListeners();
    }

    @Override
    public Selection getSelection() {
        int[] indexes = this.table.getSelectedRows();
        if (indexes.length == 0) {
            return DefaultSelection.EMPTY;
        }
        Integer[] elements = new Integer[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            elements[i] = indexes[i];
        }
        return new DefaultSelection<Integer>(elements);
    }

    @Override
    public void setSelection(Selection selection) {
        if (selection.isEmpty()) {
            this.table.getSelectionModel().clearSelection();
            return;
        }
        Object[] elements = selection.getSelectedValues();
        this.table.getSelectionModel().setValueIsAdjusting(true);
        this.table.getSelectionModel().clearSelection();
        for (Object element : elements) {
            int index = (Integer)element;
            this.table.addRowSelectionInterval(index, index);
        }
        this.table.getSelectionModel().setValueIsAdjusting(false);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        if (table != this.table) {
            this.uninstallTableListeners();
            this.table = table;
            this.installTableListeners();
            this.fireSelectionChange(this.getSelection());
        }
    }

    protected void handleTableSelectionChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.fireSelectionChange(this.getSelection());
        }
    }

    private void installTableListeners() {
        this.table.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        this.table.addPropertyChangeListener("selectionModel", this.selectionModelChangeListener);
    }

    private void uninstallTableListeners() {
        this.table.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        this.table.removePropertyChangeListener("selectionModel", this.selectionModelChangeListener);
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TableSelectionContext.this.handleTableSelectionChanged(e);
        }
    }

    private class TableSelectionModelChangeListener
    implements PropertyChangeListener {
        private TableSelectionModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ListSelectionModel newSelectionModel;
            ListSelectionModel oldSelectionModel = (ListSelectionModel)evt.getOldValue();
            if (oldSelectionModel != null) {
                oldSelectionModel.removeListSelectionListener(TableSelectionContext.this.tableSelectionListener);
            }
            if ((newSelectionModel = (ListSelectionModel)evt.getNewValue()) != null) {
                newSelectionModel.addListSelectionListener(TableSelectionContext.this.tableSelectionListener);
            }
        }
    }
}

