/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection;

import com.bc.ceres.core.ExtensibleObject;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.support.SelectionChangeSupport;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public abstract class AbstractSelectionContext
extends ExtensibleObject
implements SelectionContext {
    private final SelectionChangeSupport selectionChangeSupport;

    protected AbstractSelectionContext() {
        this(null);
    }

    protected AbstractSelectionContext(Object selectionSource) {
        Object realSource = selectionSource != null ? selectionSource : this;
        this.selectionChangeSupport = new SelectionChangeSupport(realSource);
    }

    @Override
    public boolean canInsert(Transferable contents) {
        return false;
    }

    @Override
    public void insert(Transferable transferable) throws IOException, UnsupportedFlavorException {
        throw new IllegalStateException("Unsupported operation.");
    }

    @Override
    public boolean canDeleteSelection() {
        return false;
    }

    @Override
    public void deleteSelection() {
        throw new IllegalStateException("Unsupported operation.");
    }

    @Override
    public boolean canSelectAll() {
        return false;
    }

    @Override
    public void selectAll() {
        throw new IllegalStateException("Unsupported operation.");
    }

    @Override
    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.addSelectionChangeListener(listener);
    }

    @Override
    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.removeSelectionChangeListener(listener);
    }

    @Override
    public SelectionChangeListener[] getSelectionChangeListeners() {
        return this.selectionChangeSupport.getSelectionChangeListeners();
    }

    protected void fireSelectionChange(Selection selection) {
        this.selectionChangeSupport.fireSelectionChange(this, selection);
    }
}

