/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.AbstractHandle;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.StyleDefaults;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class RotateHandle
extends AbstractHandle {
    private final double radius;
    private double theta = 0.0;

    public RotateHandle(Figure figure, FigureStyle style) {
        super(figure, style, style);
        this.radius = 80.0;
        this.setLocation();
        this.setShape(RotateHandle.createHandleShape(this.radius, this.theta));
    }

    @Override
    public void updateLocation() {
        this.setLocation();
    }

    private void setLocation() {
        Rectangle2D bounds = this.getFigure().getBounds();
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        this.setLocation(centerX, centerY);
    }

    @Override
    public void move(double dx, double dy) {
        this.setLocation(this.getX() + dx, this.getY() + dy);
        RectangularShape handleShape = (RectangularShape)this.getShape();
        double ax = handleShape.getCenterX() - this.getX();
        double ay = handleShape.getCenterY() - this.getY();
        double theta1 = Math.atan2(ay, ax);
        double theta2 = Math.atan2(ay += dy, ax += dx);
        double delta = theta2 - theta1;
        this.theta += delta;
        this.getFigure().rotate(this.getLocation(), delta);
    }

    @Override
    public void drawHandle(Graphics2D g) {
        RectangularShape handleShape = (RectangularShape)this.getShape();
        Ellipse2D.Double anchorShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        Line2D.Double connectionLine = new Line2D.Double(0.0, 0.0, handleShape.getCenterX(), handleShape.getCenterY());
        g.setPaint(StyleDefaults.SELECTION_STROKE_PAINT);
        g.setStroke(StyleDefaults.SELECTION_STROKE);
        g.draw(connectionLine);
        g.setPaint(this.getNormalStyle().getFillPaint());
        g.fill(anchorShape);
        g.setPaint(this.getNormalStyle().getStrokePaint());
        g.setStroke(this.getNormalStyle().getStroke());
        g.draw(anchorShape);
        g.draw(new Line2D.Double(0.0, 0.0, 0.0, 0.0));
        super.drawHandle(g);
    }

    private static Shape createHandleShape(double radius, double theta) {
        Point2D rotateHandleCenter = new Point2D.Double(0.0, -radius);
        rotateHandleCenter = AffineTransform.getRotateInstance(theta).transform(rotateHandleCenter, null);
        return new Ellipse2D.Double(rotateHandleCenter.getX() - 4.0, rotateHandleCenter.getY() - 4.0, 8.0, 8.0);
    }
}

