/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class FigureInsertEdit
extends AbstractUndoableEdit {
    private FigureEditor figureEditor;
    private Figure[] addedFigures;

    public FigureInsertEdit(FigureEditor figureEditor, boolean performInsert, Figure ... figuresToInsert) {
        this.figureEditor = figureEditor;
        this.addedFigures = performInsert ? figureEditor.getFigureCollection().addFigures(figuresToInsert) : (Figure[])figuresToInsert.clone();
        figureEditor.getFigureSelection().removeAllFigures();
        figureEditor.getFigureSelection().addFigures(this.addedFigures);
        figureEditor.getFigureSelection().setSelectionStage(1);
    }

    @Override
    public String getPresentationName() {
        return this.addedFigures.length == 1 ? "Insert Figure" : "Insert Figures";
    }

    @Override
    public void die() {
        super.die();
        this.figureEditor = null;
        this.addedFigures = null;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.figureEditor.getFigureSelection().removeAllFigures();
        this.figureEditor.getFigureSelection().setSelectionStage(0);
        this.figureEditor.getFigureCollection().removeFigures(this.addedFigures);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.figureEditor.getFigureSelection().removeAllFigures();
        this.figureEditor.getFigureSelection().setSelectionStage(0);
        this.figureEditor.getFigureCollection().addFigures(this.addedFigures);
    }
}

