/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureIterator
implements Iterator<SimpleFeature>,
SimpleFeatureIterator {
    FeatureIterator<SimpleFeature> reader;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();

    public ReprojectFeatureIterator(FeatureIterator<SimpleFeature> reader, SimpleFeatureType schema, MathTransform transform) {
        this.reader = reader;
        this.schema = schema;
        this.transformer.setMathTransform(transform);
        this.transformer.setCoordinateReferenceSystem(schema.getCoordinateReferenceSystem());
    }

    public SimpleFeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = (SimpleFeature)this.reader.next();
        Object[] attributes = next.getAttributes().toArray();
        try {
            for (int i = 0; i < attributes.length; ++i) {
                if (!(attributes[i] instanceof Geometry)) continue;
                attributes[i] = this.transformer.transform((Geometry)attributes[i]);
            }
        }
        catch (TransformException e) {
            throw (IllegalStateException)new IllegalStateException("A transformation exception occurred while reprojecting data on the fly").initCause(e);
        }
        return SimpleFeatureBuilder.build(this.schema, attributes, next.getID());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("On the fly reprojection disables remove");
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    public void close() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

