/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.esa.snap.core.gpf.descriptor.SystemDependentVariable;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.dialogs.SystemDependentVariableEditorDialog;
import org.esa.snap.ui.tooladapter.model.VariableChangedEvent;
import org.esa.snap.ui.tooladapter.model.VariableChangedListener;

public class VariablesTable
extends JTable {
    private static String[] columnNames = new String[]{"", "Shared", "Key", "Value"};
    private static int[] widths = new int[]{24, 40, 100, 250};
    private List<SystemVariable> variables;
    private MultiRenderer tableRenderer;
    private AppContext appContext;

    public VariablesTable(List<SystemVariable> variables, AppContext context) {
        this.variables = variables;
        this.appContext = context;
        this.tableRenderer = new MultiRenderer();
        this.setModel(new VariablesTableModel());
        this.setAutoResizeMode(3);
        for (int i = 0; i < widths.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(widths[i]);
        }
    }

    public void stopVariablesTableEditing() {
        int row = this.getEditingRow();
        int column = this.getEditingColumn();
        if (!(row < 0 || column < 0 || this.variables.get(row) instanceof SystemDependentVariable && column == 3)) {
            this.getCellEditor(this.getEditingRow(), this.getEditingColumn()).stopCellEditing();
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return this.tableRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        switch (column) {
            case 0: 
            case 2: 
            case 3: {
                return this.tableRenderer;
            }
            case 1: {
                return this.getDefaultEditor(Boolean.class);
            }
        }
        return this.getDefaultEditor(String.class);
    }

    class SystemDependentVariableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor,
    VariableChangedListener {
        private static final int CLICK_COUNT_TO_START = 2;
        private JButton button;
        private SystemDependentVariableEditorDialog dialog;
        private SystemDependentVariable variable;

        public SystemDependentVariableCellEditor(Window window, SystemDependentVariable variable, String helpID) {
            super(new JTextField());
            this.setClickCountToStart(2);
            this.button = new JButton();
            this.button.setBackground(Color.white);
            this.button.setFont(this.button.getFont().deriveFont(0));
            this.button.setBorder(null);
            this.button.setHorizontalAlignment(2);
            this.button.setText(variable.getValue());
            this.variable = variable;
            this.dialog = new SystemDependentVariableEditorDialog(window, this.variable, helpID);
            this.dialog.addListener(this);
            this.button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        SystemDependentVariableCellEditor.this.dialog.show();
                        SystemDependentVariableCellEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.variable.getValue();
        }

        @Override
        public Component getComponent() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }

        @Override
        public void variableChanged(VariableChangedEvent ev) {
            String currentOSValue = this.variable.getCurrentOSValue();
            this.button.setText(currentOSValue);
        }
    }

    class MultiRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        private AbstractButton delButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/DeleteShapeTool16.gif"), (boolean)false);
        private TableCellEditor lastEditor;

        public MultiRenderer() {
            this.delButton.addActionListener(e -> this.fireEditingStopped());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            switch (column) {
                case 0: {
                    return this.delButton;
                }
            }
            return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            switch (column) {
                case 0: {
                    this.lastEditor = null;
                    return this.delButton;
                }
                case 1: {
                    this.lastEditor = VariablesTable.this.getDefaultEditor(Boolean.class);
                    return this.lastEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
                case 3: {
                    SystemVariable variable = (SystemVariable)VariablesTable.this.variables.get(row);
                    if (variable instanceof SystemDependentVariable) {
                        this.lastEditor = new SystemDependentVariableCellEditor(VariablesTable.this.appContext.getApplicationWindow(), (SystemDependentVariable)variable, null);
                        return this.lastEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                    }
                    this.lastEditor = VariablesTable.this.getDefaultEditor(String.class);
                    return this.lastEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
            }
            this.lastEditor = VariablesTable.this.getDefaultEditor(String.class);
            return this.lastEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastEditor != null ? (((DefaultCellEditor)this.lastEditor).getComponent() instanceof JTextField ? ((JTextField)((DefaultCellEditor)this.lastEditor).getComponent()).getText() : this.lastEditor.getCellEditorValue()) : this.delButton;
        }
    }

    class VariablesTableModel
    extends AbstractTableModel {
        VariablesTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex != 1 ? String.class : Boolean.class;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return VariablesTable.this.variables.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return false;
                }
                case 1: {
                    return ((SystemVariable)VariablesTable.this.variables.get(row)).isShared();
                }
                case 2: {
                    return ((SystemVariable)VariablesTable.this.variables.get(row)).getKey();
                }
                case 3: {
                    return ((SystemVariable)VariablesTable.this.variables.get(row)).getValue();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null) {
                switch (columnIndex) {
                    case 0: {
                        VariablesTable.this.variables.remove(VariablesTable.this.variables.get(rowIndex));
                        this.fireTableDataChanged();
                        break;
                    }
                    case 1: {
                        ((SystemVariable)VariablesTable.this.variables.get(rowIndex)).setShared(Boolean.valueOf(aValue.toString()).booleanValue());
                        break;
                    }
                    case 2: {
                        ((SystemVariable)VariablesTable.this.variables.get(rowIndex)).setKey(aValue.toString());
                        break;
                    }
                    case 3: {
                        ((SystemVariable)VariablesTable.this.variables.get(rowIndex)).setValue(aValue.toString());
                    }
                }
            }
        }
    }
}

