/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.SwingUtilities;
import org.esa.snap.rcp.SnapApp;

public class ProgressWorker
extends ProgressMonitorSwingWorker {
    private static final SnapApp snapApp = SnapApp.getDefault();
    private String message;
    private Runnable task;

    public ProgressWorker(String title, String message, Runnable task) {
        super((Component)snapApp.getMainFrame(), title);
        this.message = message;
        this.task = task;
    }

    protected Object doInBackground(ProgressMonitor pm) throws Exception {
        try {
            pm.beginTask(this.message, 1);
            SwingUtilities.invokeLater(() -> {
                snapApp.setStatusBarMessage(this.message);
                snapApp.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            });
            if (this.task != null) {
                this.task.run();
            }
        }
        catch (Throwable e) {
            snapApp.handleError("The operation failed.", e);
        }
        finally {
            SwingUtilities.invokeLater(() -> snapApp.getMainFrame().setCursor(Cursor.getDefaultCursor()));
            snapApp.setStatusBarMessage("");
            pm.done();
        }
        return null;
    }
}

