/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.dependency.Bundle;
import org.esa.snap.tango.TangoIcons;

public class OperatorsTableModel
extends AbstractTableModel {
    private static ImageIcon STATUS_OK;
    private static ImageIcon STATUS_NOK;
    private String[] columnNames = new String[]{"Status", "Alias", "Description"};
    private List<ToolAdapterOperatorDescriptor> data = null;

    public OperatorsTableModel(List<ToolAdapterOperatorDescriptor> operators) {
        this.data = operators;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Bundle bundle = this.data.get(rowIndex).getBundle();
                return bundle != null && bundle.isInstalled() ? STATUS_OK : STATUS_NOK;
            }
            case 1: {
                return this.data.get(rowIndex).getAlias();
            }
            case 2: {
                return this.data.get(rowIndex).getDescription();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public ToolAdapterOperatorDescriptor getObjectAt(int rowIndex) {
        ToolAdapterOperatorDescriptor result = null;
        if (rowIndex >= 0 && rowIndex <= this.data.size() - 1) {
            result = this.data.get(rowIndex);
        }
        return result;
    }

    static {
        try {
            STATUS_OK = new ImageIcon(OperatorsTableModel.class.getResource("/org/esa/snap/ui/tooladapter/dialogs/check_ok.png"));
        }
        catch (Exception e) {
            Logger.getLogger(OperatorsTableModel.class.getName()).warning("Image resource not loaded");
        }
        STATUS_NOK = TangoIcons.emblems_emblem_important((TangoIcons.Res)TangoIcons.Res.R16);
    }
}

