/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.util.StringUtils;

public class FilePanel
extends JPanel {
    private final JTextField textField = new JTextField();
    private final JButton browseButton;

    public FilePanel() {
        super(new BorderLayout());
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.browseButton = new JButton("...");
        this.browseButton.setFocusable(false);
        Dimension size = new Dimension(26, 16);
        this.browseButton.setPreferredSize(size);
        this.browseButton.setMinimumSize(size);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                FilePanel.this.textField.requestFocusInWindow();
            }
        });
        this.add((Component)this.textField, "Center");
        this.add((Component)this.browseButton, "East");
    }

    public void addBrowseButtonActionListener(ActionListener actionListener) {
        this.browseButton.addActionListener(actionListener);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void addTextComponentFocusListener(FocusListener focusListener) {
        this.textField.addFocusListener(focusListener);
    }

    public File showFileChooserDialog(int selectionMode, FileFilter filter) {
        int resultState;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(selectionMode);
        String filePath = this.textField.getText();
        if (!StringUtils.isNullOrEmpty((String)filePath)) {
            File currentFile = new File(filePath);
            fileChooser.setSelectedFile(currentFile);
        }
        if (filter != null) {
            fileChooser.setFileFilter(filter);
        }
        if ((resultState = fileChooser.showDialog(this, "Select")) == 0 && fileChooser.getSelectedFile() != null) {
            this.textField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

