/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.internal.ListSelectionAdapter;
import java.awt.Dimension;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.utils.SpringUtilities;

public class FileListEditor
extends PropertyEditor {
    public boolean isValidFor(PropertyDescriptor propertyDescriptor) {
        return File[].class.isAssignableFrom(propertyDescriptor.getType());
    }

    public JComponent createEditorComponent(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        JPanel panel = new JPanel(new SpringLayout());
        DefaultListModel listModel = new DefaultListModel();
        final JList list = new JList(listModel);
        ListSelectionAdapter adapter = new ListSelectionAdapter(list){

            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting() || this.getBinding().isAdjustingComponents()) {
                    return;
                }
                Property model = this.getBinding().getContext().getPropertySet().getProperty(this.getBinding().getPropertyName());
                try {
                    List selectedValuesList = list.getSelectedValuesList();
                    model.setValue((Object)selectedValuesList.toArray(new File[selectedValuesList.size()]));
                    this.getBinding().clearProblem();
                }
                catch (ValidationException e) {
                    this.getBinding().reportProblem((BindingException)e);
                }
            }
        };
        Binding binding = bindingContext.bind(propertyDescriptor.getName(), (ComponentAdapter)adapter);
        list.setMinimumSize(new Dimension(250, 120));
        list.setPreferredSize(new Dimension(250, 120));
        panel.add(new JScrollPane(list, 20, 31));
        AbstractButton addFileBtn = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/Add16.png"), (boolean)false);
        addFileBtn.setMaximumSize(new Dimension(20, 20));
        addFileBtn.setAlignmentX(0.0f);
        addFileBtn.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int i = fileChooser.showDialog(panel, "Select");
            File selectedFile = fileChooser.getSelectedFile();
            if (i == 0 && selectedFile != null) {
                listModel.addElement(selectedFile);
                this.syncPropertyValue(binding, listModel);
            }
        });
        AbstractButton removeFileBtn = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/Remove16.png"), (boolean)false);
        removeFileBtn.setMaximumSize(new Dimension(20, 20));
        removeFileBtn.setAlignmentX(0.0f);
        removeFileBtn.addActionListener(e -> {
            Object selection = list.getSelectedValue();
            if (selection != null) {
                listModel.removeElement(selection);
                this.syncPropertyValue(binding, listModel);
            }
        });
        JPanel buttonsPannel = new JPanel(new SpringLayout());
        buttonsPannel.add(addFileBtn);
        buttonsPannel.add(removeFileBtn);
        SpringUtilities.makeCompactGrid(buttonsPannel, 2, 1, 0, 0, 0, 0);
        panel.add(buttonsPannel);
        SpringUtilities.makeCompactGrid(panel, 1, 2, 0, 0, 0, 0);
        return panel;
    }

    private void syncPropertyValue(Binding binding, DefaultListModel<File> listModel) {
        Object[] objects = listModel.toArray();
        binding.setPropertyValue((Object)Arrays.stream(objects).map(item -> new File(item.toString())).collect(Collectors.toList()).toArray(new File[objects.length]));
    }
}

