/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs.progress;

import com.bc.ceres.core.ProgressMonitor;
import org.esa.snap.ui.tooladapter.dialogs.progress.ConsoleConsumer;
import org.netbeans.api.progress.ProgressHandle;

public class ProgressHandler
implements ProgressMonitor {
    private ProgressHandle progressHandle;
    private boolean isIndeterminate;
    private ConsoleConsumer console;

    public ProgressHandler(ProgressHandle handle, boolean indeterminate) {
        this.progressHandle = handle;
        this.isIndeterminate = indeterminate;
        this.progressHandle.setInitialDelay(10);
    }

    public void setConsumer(ConsoleConsumer consumer) {
        this.console = consumer;
    }

    public void beginTask(String taskName, int totalWork) {
        this.progressHandle.setDisplayName(taskName);
        this.progressHandle.start(totalWork, -1L);
        if (this.isIndeterminate) {
            this.progressHandle.switchToIndeterminate();
        }
        if (this.console != null) {
            this.console.setVisible(true);
        }
    }

    public void done() {
        this.progressHandle.finish();
    }

    public void internalWorked(double work) {
        this.progressHandle.progress((int)work);
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean canceled) {
        this.progressHandle.suspend("Cancelled");
    }

    public void setTaskName(String taskName) {
        this.progressHandle.setDisplayName(taskName);
    }

    public void setSubTaskName(String subTaskName) {
        this.progressHandle.progress(subTaskName);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }
}

