/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs.progress;

import com.bc.ceres.core.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.esa.snap.core.gpf.operators.tooladapter.DefaultOutputConsumer;
import org.esa.snap.ui.tooladapter.dialogs.ConsolePane;

public class ConsoleConsumer
extends DefaultOutputConsumer {
    private ConsolePane consolePane;

    public ConsoleConsumer(String progressPattern, String errorPattern, String stepPattern, ProgressMonitor pm, ConsolePane consolePane) {
        super(progressPattern, errorPattern, stepPattern, pm);
        this.consolePane = consolePane;
    }

    public void consumeOutput(String line) {
        super.consumeOutput(line);
        if (this.consolePane != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.consume(line);
            } else {
                SwingUtilities.invokeLater(() -> this.consume(line));
            }
        }
    }

    void setVisible(boolean value) {
        if (this.consolePane != null) {
            this.consolePane.setVisible(value);
        }
    }

    private void consume(String line) {
        if (this.error == null || !this.error.matcher(line).matches()) {
            this.consolePane.appendInfo(line);
        } else {
            this.consolePane.appendError(line);
        }
    }
}

