/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs.components;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.gpf.descriptor.annotations.Folder;
import org.esa.snap.core.gpf.descriptor.annotations.ReadOnly;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.tooladapter.dialogs.components.FieldChangeTrigger;
import org.esa.snap.utils.UIUtils;

public class EntityForm<T> {
    private Class<T> entityType;
    private Map<String, FieldChangeTrigger[]> fieldMap;
    private Map<String, Annotation[]> annotatedFields;
    private T original;
    private T modified;
    private JPanel panel;
    private Map<String, Function<T, Void>> actions;

    public EntityForm(T object) {
        this(object, null, null);
    }

    public EntityForm(T object, Map<String, FieldChangeTrigger[]> dependentFieldsActions, Map<String, Function<T, Void>> additionalActions) {
        Assert.notNull(object);
        this.original = object;
        this.entityType = this.original.getClass();
        Field[] fields = this.entityType.getDeclaredFields();
        this.fieldMap = new HashMap<String, FieldChangeTrigger[]>();
        this.annotatedFields = new HashMap<String, Annotation[]>();
        for (Field field : fields) {
            String fieldName = field.getName();
            FieldChangeTrigger[] dependencies = dependentFieldsActions != null ? dependentFieldsActions.get(fieldName) : null;
            this.fieldMap.put(fieldName, dependencies);
            Annotation[] annotations = field.getAnnotations();
            if (annotations == null) continue;
            this.annotatedFields.put(fieldName, annotations);
        }
        try {
            this.modified = this.duplicate(this.original, this.modified, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.actions = new HashMap<String, Function<T, Void>>();
        if (additionalActions != null) {
            this.actions.putAll(additionalActions);
        }
        this.buildUI();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public T applyChanges() {
        try {
            this.original = this.duplicate(this.modified, this.original, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.original;
    }

    private T duplicate(T source, T target, boolean useSetters) throws Exception {
        if (target == null) {
            Constructor<T> constructor = this.entityType.getConstructor(new Class[0]);
            target = constructor.newInstance(new Object[0]);
        }
        for (String fieldName : this.fieldMap.keySet()) {
            Object sourceValue = EntityForm.getValue(source, fieldName);
            if (useSetters) {
                try {
                    EntityForm.invokeMethod(target, "set" + StringUtils.firstLetterUp((String)fieldName), sourceValue);
                }
                catch (Exception ignored) {
                    EntityForm.setValue(target, fieldName, sourceValue);
                }
                continue;
            }
            EntityForm.setValue(target, fieldName, sourceValue);
        }
        return target;
    }

    private void buildUI() {
        PropertyContainer propertyContainer = PropertyContainer.createObjectBacked(this.modified);
        for (String string : this.fieldMap.keySet()) {
            Annotation[] annotations;
            Optional<Annotation> annotation;
            if (!this.annotatedFields.containsKey(string) || !(annotation = Arrays.stream(annotations = this.annotatedFields.get(string)).filter(a -> a.annotationType().equals(Folder.class)).findFirst()).isPresent()) continue;
            try {
                if (!File.class.isAssignableFrom(this.entityType.getDeclaredField(string).getType())) continue;
                propertyContainer.getDescriptor(string).setAttribute("directory", (Object)true);
            }
            catch (NoSuchFieldException e2) {
                e2.printStackTrace();
            }
        }
        PropertyPane parametersPane = new PropertyPane((PropertySet)propertyContainer);
        this.panel = parametersPane.createPanel();
        for (Property property : propertyContainer.getProperties()) {
            Arrays.stream(parametersPane.getBindingContext().getBinding(property.getName()).getComponents()).forEach(c -> UIUtils.addPromptSupport(c, property));
            if (!this.annotatedFields.containsKey(property.getName())) continue;
            Optional<Annotation> annotation = Arrays.stream((Object[])this.annotatedFields.get(property.getName())).filter(a -> a.annotationType().equals(ReadOnly.class)).findFirst();
            annotation.ifPresent(annotation1 -> Arrays.stream(parametersPane.getBindingContext().getBinding(property.getName()).getComponents()).forEach(c -> c.setEnabled(false)));
        }
        propertyContainer.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            Object newValue = evt.getNewValue();
            try {
                EntityForm.invokeMethod(this.modified, "set" + StringUtils.firstLetterUp((String)propertyName), newValue);
            }
            catch (Exception e) {
                try {
                    EntityForm.setValue(this.modified, propertyName, newValue);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            FieldChangeTrigger[] dependencies = this.fieldMap.get(propertyName);
            if (dependencies != null && dependencies.length > 0) {
                for (FieldChangeTrigger dependency : dependencies) {
                    try {
                        if (!dependency.canApply(newValue)) continue;
                        Object newTargetValue = dependency.apply(newValue);
                        Binding binding = parametersPane.getBindingContext().getBinding(dependency.getTargetFieldName());
                        binding.setPropertyValue(newTargetValue);
                        binding.adjustComponents();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.panel.addPropertyChangeListener(evt -> {
            if (!(evt.getNewValue() instanceof JTextField)) {
                return;
            }
            JTextField field = (JTextField)evt.getNewValue();
            String text = field.getText();
            if (text != null && text.isEmpty()) {
                field.setCaretPosition(text.length());
            }
        });
        if (this.actions.size() > 0) {
            JPanel jPanel = new JPanel(new BorderLayout());
            for (Map.Entry<String, Function<T, Void>> action : this.actions.entrySet()) {
                JButton button = new JButton(action.getKey());
                button.addActionListener(e -> {
                    parametersPane.getBindingContext().adjustComponents();
                    ((Function)action.getValue()).apply(this.modified);
                });
                jPanel.add((Component)button, "East");
            }
            this.panel.add(jPanel);
        }
        this.panel.setBorder(new EmptyBorder(4, 4, 4, 4));
    }

    private static Object invokeMethod(Object instance, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methods;
        if (args == null) {
            args = new Object[]{};
        }
        Class[] classTypes = EntityForm.getClassArray(args);
        for (Method method : methods = instance.getClass().getMethods()) {
            Class[] paramTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || !EntityForm.compare(paramTypes, args)) continue;
            return method.invoke(instance, args);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("No method named ").append(methodName).append(" found in ").append(instance.getClass().getName()).append(" with parameters (");
        for (int x = 0; x < classTypes.length; ++x) {
            sb.append(classTypes[x].getName());
            if (x >= classTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        throw new NoSuchMethodException(sb.toString());
    }

    private static Class[] getClassArray(Object[] args) {
        Class[] classTypes = null;
        if (args != null) {
            classTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                classTypes[i] = args[i].getClass();
            }
        }
        return classTypes;
    }

    private static boolean compare(Class[] c, Object[] args) {
        if (c.length != args.length) {
            return false;
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    private static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = EntityForm.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    private static void setValue(Object instance, String fieldName, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = EntityForm.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        field.set(instance, value);
    }

    private static Field getField(Class thisClass, String fieldName) throws NoSuchFieldException {
        if (thisClass == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            return thisClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return EntityForm.getField(thisClass.getSuperclass(), fieldName);
        }
    }
}

