/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs.components;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.esa.snap.tango.TangoIcons;

public class AnchorLabel
extends JLabel {
    private JTabbedPane parentTabControl;
    private int tabIndex;
    private JComponent component;

    public AnchorLabel(String text, JTabbedPane parent, int index, JComponent anchoredComponent) {
        super(text);
        this.parentTabControl = parent;
        this.tabIndex = index;
        this.component = anchoredComponent;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.enableEvents(16L);
    }

    @Override
    public void setText(String text) {
        super.setText("<html><font color=\"#FF0000\">" + text + "</font></html>");
    }

    public void markError() {
        JLabel label = this.findLabelFor(this.component);
        if (label != null) {
            label.setIcon(TangoIcons.status_dialog_error((TangoIcons.Res)TangoIcons.Res.R16));
        }
    }

    public void clearError() {
        JLabel label = this.findLabelFor(this.component);
        if (label != null) {
            label.setIcon(null);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 500) {
            this.parentTabControl.setSelectedIndex(this.tabIndex);
            if (this.component instanceof JPanel && this.component.getComponents() != null && this.component.getComponents().length > 0) {
                Component comp = this.component.getComponent(0);
                comp.requestFocusInWindow();
            } else {
                this.component.requestFocusInWindow();
            }
            if (this.component instanceof JTextField) {
                SwingUtilities.invokeLater(() -> ((JTextField)this.component).setCaretPosition(((JTextField)this.component).getDocument().getLength()));
            }
        }
    }

    private JLabel findLabelFor(JComponent component) {
        Optional<Component> label = Arrays.stream(component.getParent().getComponents()).filter(c -> c instanceof JLabel && component.equals(((JLabel)c).getLabelFor())).findFirst();
        return label.map(component1 -> (JLabel)component1).orElse(null);
    }
}

