/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.converters.FloatConverter;
import com.bc.ceres.binding.converters.IntegerConverter;
import com.bc.ceres.binding.converters.NumberConverter;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.CheckBoxEditor;
import com.bc.ceres.swing.binding.internal.DirectoryEditor;
import com.bc.ceres.swing.binding.internal.FileEditor;
import com.bc.ceres.swing.binding.internal.MultiSelectionEditor;
import com.bc.ceres.swing.binding.internal.SingleSelectionEditor;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.dialogs.RequiredTextComponentAdapter;
import org.esa.snap.ui.tooladapter.dialogs.ToolAdapterEditorDialog;
import org.esa.snap.ui.tooladapter.dialogs.ValidateTextComponentAdapter;
import org.esa.snap.ui.tooladapter.model.OperatorParametersTable;

public class ToolParameterEditorDialog
extends ModalDialog {
    private static final Logger logger = Logger.getLogger(ToolAdapterEditorDialog.class.getName());
    public static final String helpID = "sta_editor";
    private static final Map<String, Class<?>> typesMap = new LinkedHashMap();
    private ToolParameterDescriptor parameter;
    private ToolParameterDescriptor oldParameter;
    private PropertyContainer container;
    private BindingContext valuesContext;
    private BindingContext paramContext;
    private JComponent defaultValueComponent;
    private JPanel mainPanel;
    private JTextField valueSetTextComponent;
    private final ToolAdapterOperatorDescriptor operator;

    public ToolParameterEditorDialog(AppContext appContext, ToolAdapterOperatorDescriptor operator, ToolParameterDescriptor inputParameter) {
        super(appContext.getApplicationWindow(), inputParameter.getName(), 33, helpID);
        this.operator = operator;
        this.oldParameter = inputParameter;
        this.parameter = new ToolParameterDescriptor((DefaultParameterDescriptor)inputParameter);
        this.parameter.setDeprecated(inputParameter.isDeprecated());
        this.container = PropertyContainer.createObjectBacked((Object)this.parameter);
        this.valuesContext = new BindingContext((PropertySet)this.container);
        this.addComponents();
        EscapeAction.register(this.getJDialog());
    }

    protected void onOK() {
        if (!OperatorParametersTable.checkUniqueParameterName(this.operator, this.parameter.getName(), this.oldParameter)) {
            return;
        }
        super.onOK();
        this.oldParameter.setName(this.parameter.getName());
        this.oldParameter.setAlias(this.parameter.getAlias());
        this.oldParameter.setDataType(this.parameter.getDataType());
        Object defaultValue = this.getProperty().getValue();
        String defaultValueAsString = ToolParameterEditorDialog.processDefaultValue(defaultValue);
        this.oldParameter.setDefaultValue(defaultValueAsString);
        this.oldParameter.setDescription(this.parameter.getDescription());
        this.oldParameter.setLabel(this.parameter.getLabel());
        this.oldParameter.setUnit(this.parameter.getUnit());
        this.oldParameter.setInterval(this.parameter.getInterval());
        this.oldParameter.setValueSet(this.parameter.getValueSet());
        this.oldParameter.setCondition(this.parameter.getCondition());
        this.oldParameter.setPattern(this.parameter.getPattern());
        this.oldParameter.setFormat(this.parameter.getFormat());
        this.oldParameter.setNotNull(this.parameter.isNotNull());
        this.oldParameter.setNotEmpty(this.parameter.isNotEmpty());
        this.oldParameter.setRasterDataNodeClass(this.parameter.getRasterDataNodeClass());
        this.oldParameter.setValidatorClass(this.parameter.getValidatorClass());
        this.oldParameter.setConverterClass(this.parameter.getConverterClass());
        this.oldParameter.setDomConverterClass(this.parameter.getDomConverterClass());
        this.oldParameter.setItemAlias(this.parameter.getItemAlias());
        this.oldParameter.setDeprecated(this.parameter.isDeprecated());
        this.oldParameter.setParameterType(this.parameter.getParameterType());
    }

    private void addComponents() {
        String itemNameToSelect;
        block2: {
            block1: {
                File f;
                GridBagLayout layout = new GridBagLayout();
                layout.columnWidths = new int[]{100, 390};
                this.mainPanel = new JPanel(layout);
                this.addTextPropertyEditor(this.mainPanel, "Name: ", "name", 0, "The 'Name' field is required.");
                this.addTextPropertyEditor(this.mainPanel, "Alias: ", "alias", 1, "The 'Alias' field is required.");
                itemNameToSelect = null;
                if (this.parameter.getDataType() != File.class) break block1;
                itemNameToSelect = "File";
                if (this.parameter.getDefaultValue() == null || !(f = new File(this.parameter.getDefaultValue())).isDirectory()) break block2;
                itemNameToSelect = "Folder";
                break block2;
            }
            for (Map.Entry<String, Class<?>> entry : typesMap.entrySet()) {
                if (entry.getValue() != this.parameter.getDataType()) continue;
                itemNameToSelect = entry.getKey();
                break;
            }
        }
        JComboBox<Object> comboEditor = new JComboBox<Object>(typesMap.keySet().toArray());
        comboEditor.setSelectedItem(itemNameToSelect);
        comboEditor.addActionListener(ev -> {
            JComboBox cb = (JComboBox)ev.getSource();
            String selectedTypeName = (String)cb.getSelectedItem();
            Class<?> selectedTypeClass = typesMap.get(selectedTypeName);
            if (!this.parameter.getDataType().equals(selectedTypeClass)) {
                Class previousTypeClass = this.parameter.getDataType();
                this.parameter.setDataType(selectedTypeClass);
                try {
                    this.valuesContext.getPropertySet().getProperty("defaultValue").setValue(null);
                }
                catch (ValidationException e) {
                    logger.warning(e.getMessage());
                }
                Object defaultValue = this.getProperty().getValue();
                String defaultValueAsString = ToolParameterEditorDialog.processDefaultValue(defaultValue);
                boolean canResetValueSet = true;
                if (selectedTypeClass == String.class || selectedTypeClass == String[].class) {
                    canResetValueSet = false;
                    if (previousTypeClass == Float.class) {
                        defaultValueAsString = null;
                    }
                } else if (selectedTypeClass == Integer.class) {
                    if ((previousTypeClass == Float.class || previousTypeClass == String.class || previousTypeClass == String[].class) && ToolParameterEditorDialog.canConvertArrayToNumber(new IntegerConverter(), this.parameter.getValueSet())) {
                        canResetValueSet = false;
                        if (previousTypeClass == Float.class) {
                            defaultValueAsString = null;
                        }
                    }
                } else if (selectedTypeClass == Float.class && (previousTypeClass == Integer.class || previousTypeClass == String.class || previousTypeClass == String[].class) && ToolParameterEditorDialog.canConvertArrayToNumber(new FloatConverter(), this.parameter.getValueSet())) {
                    canResetValueSet = false;
                }
                if (canResetValueSet) {
                    try {
                        this.valuesContext.getPropertySet().getProperty("valueSet").setValue(null);
                    }
                    catch (ValidationException e) {
                        logger.warning(e.getMessage());
                    }
                }
                this.newDataTypeSelected(selectedTypeName, selectedTypeClass, defaultValueAsString);
            }
        });
        this.mainPanel.add((Component)new JLabel("Data type"), ToolParameterEditorDialog.getConstraints(2, 0, 1));
        this.mainPanel.add(comboEditor, ToolParameterEditorDialog.getConstraints(2, 1, 1));
        this.addTextPropertyEditor(this.mainPanel, "Description: ", "description", 4, null);
        this.addTextPropertyEditor(this.mainPanel, "Label: ", "label", 5, null);
        this.addTextPropertyEditor(this.mainPanel, "Unit: ", "unit", 6, null);
        this.addTextPropertyEditor(this.mainPanel, "Interval: ", "interval", 7, null);
        this.valueSetTextComponent = new JTextField();
        ValidateTextComponentAdapter adapter = new ValidateTextComponentAdapter(this.valueSetTextComponent){

            @Override
            protected boolean validateText(String valueSetToValidate) {
                return ToolParameterEditorDialog.this.validateValueSetText(valueSetToValidate);
            }
        };
        this.addTextPropertyEditor(this.mainPanel, (ComponentAdapter)adapter, "Value set: ", "valueSet", 8);
        this.addTextPropertyEditor(this.mainPanel, "Condition: ", "condition", 9, null);
        this.addTextPropertyEditor(this.mainPanel, "Pattern: ", "pattern", 10, null);
        this.addTextPropertyEditor(this.mainPanel, "Format: ", "format", 11, null);
        this.addBoolPropertyEditor(this.mainPanel, "Not null", "notNull", 12);
        this.addBoolPropertyEditor(this.mainPanel, "Not empty", "notEmpty", 13);
        this.addTextPropertyEditor(this.mainPanel, "ItemAlias: ", "itemAlias", 14, null);
        this.addBoolPropertyEditor(this.mainPanel, "Deprecated", "deprecated", 15);
        JLabel label = new JLabel("Default value");
        label.setPreferredSize(new Dimension(150, 35));
        this.mainPanel.add((Component)label, ToolParameterEditorDialog.getConstraints(3, 0, 1));
        this.newDataTypeSelected(itemNameToSelect, this.parameter.getDataType(), this.parameter.getDefaultValue());
        this.setContent(this.mainPanel);
    }

    private boolean validateDefaultValueText(String textToValidate) {
        if (!StringUtils.isNullOrEmpty((String)textToValidate)) {
            if (this.parameter.getDataType() == Integer.class) {
                try {
                    Integer.parseInt(textToValidate);
                }
                catch (NumberFormatException ex) {
                    Dialogs.showError((String)("Failed to convert '" + textToValidate + "' to integer number."));
                    return false;
                }
            }
            if (this.parameter.getDataType() == Float.class) {
                try {
                    Float.parseFloat(textToValidate);
                }
                catch (NumberFormatException ex) {
                    Dialogs.showError((String)("Failed to convert '" + textToValidate + "' to decimal number."));
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateValueSetText(String valueSetToValidate) {
        Float[] numbers;
        Object wrongValue;
        block14: {
            FloatConverter floatConverter;
            Object[] valueSet;
            block15: {
                Integer[] numbers2;
                Object wrongValue2;
                block11: {
                    IntegerConverter integerConverter;
                    block12: {
                        block13: {
                            block10: {
                                valueSet = null;
                                if (!StringUtils.isNullOrEmpty((String)valueSetToValidate)) {
                                    valueSet = valueSetToValidate.split(",");
                                }
                                if (this.parameter.getDataType() != Integer.class) break block10;
                                wrongValue2 = null;
                                numbers2 = null;
                                if (valueSet == null || valueSet.length <= 0) break block11;
                                numbers2 = new Integer[valueSet.length];
                                integerConverter = new IntegerConverter();
                                break block12;
                            }
                            if (this.parameter.getDataType() != Float.class) break block13;
                            wrongValue = null;
                            numbers = null;
                            if (valueSet == null || valueSet.length <= 0) break block14;
                            numbers = new Float[valueSet.length];
                            floatConverter = new FloatConverter();
                            break block15;
                        }
                        if (this.parameter.getDataType() == String.class) {
                            this.populateDefaultValueComponent(valueSet, null);
                            return true;
                        }
                        if (this.parameter.getDataType() != String[].class) throw new IllegalArgumentException("Unknown parameter data type '" + this.parameter.getDataType().getName() + "'.");
                        this.populateListComponent((String[])valueSet);
                        return true;
                    }
                    for (int i = 0; i < valueSet.length && wrongValue2 == null; ++i) {
                        try {
                            numbers2[i] = (Integer)integerConverter.parse((String)valueSet[i]);
                            if (numbers2[i] != null) continue;
                            wrongValue2 = "";
                            continue;
                        }
                        catch (ConversionException ex) {
                            wrongValue2 = valueSet[i];
                        }
                    }
                }
                if (wrongValue2 == null) {
                    this.populateDefaultValueComponent(numbers2, null);
                    return true;
                }
                Dialogs.showError((String)("Failed to convert '" + wrongValue2 + "' to integer number."));
                return false;
            }
            for (int i = 0; i < valueSet.length && wrongValue == null; ++i) {
                try {
                    numbers[i] = (Float)floatConverter.parse((String)valueSet[i]);
                    if (numbers[i] != null) continue;
                    wrongValue = "";
                    continue;
                }
                catch (ConversionException ex) {
                    wrongValue = valueSet[i];
                }
            }
        }
        if (wrongValue == null) {
            this.populateDefaultValueComponent(numbers, null);
            return true;
        }
        Dialogs.showError((String)("Failed to convert '" + wrongValue + "' to decimal number."));
        return false;
    }

    private void populateDefaultValueComponent(Object[] valueSet, Object valueToSelect) {
        if (valueSet == null || valueSet.length == 0) {
            this.removeDefaultValueComponent();
            this.createDefaultValueTextComponent();
            this.addDefaultValueComponent();
        } else {
            if (!(this.defaultValueComponent instanceof JComboBox)) {
                this.removeDefaultValueComponent();
                this.createDefaultValueComboBoxComponent();
                this.addDefaultValueComponent();
            }
            this.populateDefaultValueComboBoxComponent(valueSet, valueToSelect);
        }
    }

    private void createDefaultValueTextComponent() {
        this.defaultValueComponent = new JTextField();
        ValidateTextComponentAdapter adapter = new ValidateTextComponentAdapter((JTextField)this.defaultValueComponent){

            @Override
            protected boolean validateText(String textToValidate) {
                return ToolParameterEditorDialog.this.validateDefaultValueText(textToValidate);
            }
        };
        PropertyDescriptor descriptor = this.getProperty().getDescriptor();
        this.paramContext.bind(descriptor.getName(), (ComponentAdapter)adapter);
    }

    private void createDefaultValueComboBoxComponent() {
        PropertyDescriptor descriptor = this.getProperty().getDescriptor();
        SingleSelectionEditor singleSelectionEditor = new SingleSelectionEditor();
        this.defaultValueComponent = singleSelectionEditor.createEditorComponent(descriptor, this.paramContext);
    }

    private void createDefaultValueComponent(Object[] valueSet, Object valueToSelect) {
        if (valueSet == null || valueSet.length == 0) {
            this.createDefaultValueTextComponent();
        } else {
            this.createDefaultValueComboBoxComponent();
        }
    }

    private void addDefaultValueComponent() {
        this.mainPanel.add((Component)this.defaultValueComponent, ToolParameterEditorDialog.getConstraints(3, 1, 1));
        this.mainPanel.revalidate();
    }

    private void removeDefaultValueComponent() {
        if (this.defaultValueComponent != null) {
            Property property = this.getProperty();
            Binding binding = this.paramContext.getBinding(property.getName());
            binding.getComponentAdapter().unbindComponents();
            this.mainPanel.remove(this.defaultValueComponent);
        }
    }

    private void populateDefaultValueComboBoxComponent(Object[] valueSet, Object valueToSelect) {
        JComboBox comboBox = (JComboBox)this.defaultValueComponent;
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        if (valueSet != null && valueSet.length > 0) {
            Object itemToSelect = null;
            for (int i = 0; i < valueSet.length; ++i) {
                model.addElement(valueSet[i]);
                if (valueToSelect == null || !valueToSelect.equals(valueSet[i])) continue;
                itemToSelect = valueSet[i];
            }
            model.setSelectedItem(itemToSelect);
        }
        comboBox.setModel(model);
    }

    private void populateListComponent(String[] valueSet) {
        JScrollPane scrollPane = (JScrollPane)this.defaultValueComponent;
        JList list = (JList)scrollPane.getViewport().getView();
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (valueSet != null) {
            for (int i = 0; i < valueSet.length; ++i) {
                model.addElement(valueSet[i]);
            }
        }
        list.setModel(model);
    }

    private Property getProperty() {
        Property[] properties = this.paramContext.getPropertySet().getProperties();
        return properties[0];
    }

    private void newDataTypeSelected(String typeName, Class<?> typeClass, String defaultValue) {
        this.removeDefaultValueComponent();
        try {
            if (this.paramContext != null) {
                PropertySet propertySet = this.paramContext.getPropertySet();
                Property property = this.getProperty();
                propertySet.removeProperty(property);
            }
            PropertyDescriptor propertyDescriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)this.parameter, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            propertySetDescriptor.addPropertyDescriptor(propertyDescriptor);
            PropertyContainer paramContainer = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            this.paramContext = new BindingContext((PropertySet)paramContainer);
        }
        catch (ConversionException e) {
            logger.warning(e.getMessage());
        }
        boolean enabled = false;
        String parameterType = "RegularParameter";
        if (typeClass == Boolean.class) {
            this.changeBooleanDataType(defaultValue);
        } else if (typeClass == String.class) {
            enabled = true;
            this.changeStringDataType(defaultValue);
        } else if (typeClass == String[].class) {
            enabled = true;
            this.changeListDataType(defaultValue);
        } else if (typeName.equals("File")) {
            this.changeFileDataType(defaultValue);
        } else if (typeName.equals("Folder")) {
            parameterType = "FolderParameter";
            this.changeFolderDataType(defaultValue);
        } else if (typeClass == Integer.class) {
            enabled = true;
            this.changeIntegerDataType(defaultValue);
        } else if (typeClass == Float.class) {
            enabled = true;
            this.changeFloatDataType(defaultValue);
        } else {
            throw new IllegalArgumentException("Unknown type name '" + typeName + "' and type class '" + typeClass.getName() + "'.");
        }
        this.parameter.setParameterType(parameterType);
        this.valueSetTextComponent.setEnabled(enabled);
        this.addDefaultValueComponent();
    }

    private void changeBooleanDataType(String defaultValue) {
        Property property = this.getProperty();
        ValueSet valueSet = new ValueSet(new Object[]{true, false});
        property.getDescriptor().setValueSet(valueSet);
        boolean isSelected = Boolean.parseBoolean(defaultValue);
        try {
            property.setValue((Object)isSelected);
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
        this.defaultValueComponent = checkBoxEditor.createEditorComponent(property.getDescriptor(), this.paramContext);
        this.defaultValueComponent.setBorder(new EmptyBorder(1, 0, 1, 0));
    }

    private void changeListDataType(String defaultValue) {
        String[] valueSet = null;
        if (!StringUtils.isNullOrEmpty((String)defaultValue)) {
            valueSet = defaultValue.split(",");
        }
        try {
            this.getProperty().setValue((Object)valueSet);
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        MultiSelectionEditor multiSelectionEditor = new MultiSelectionEditor();
        this.defaultValueComponent = multiSelectionEditor.createEditorComponent(this.getProperty().getDescriptor(), this.paramContext);
        JScrollPane scrollPane = (JScrollPane)this.defaultValueComponent;
        JList list = (JList)scrollPane.getViewport().getView();
        list.setVisibleRowCount(2);
        if (valueSet != null && valueSet.length > 0) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            block2: for (int i = 0; i < list.getModel().getSize(); ++i) {
                Object item = list.getModel().getElementAt(i);
                for (int k = 0; k < valueSet.length; ++k) {
                    if (!item.equals(valueSet[k])) continue;
                    selectedIndices.add(i);
                    continue block2;
                }
            }
            int[] indices = new int[selectedIndices.size()];
            for (int i = 0; i < selectedIndices.size(); ++i) {
                indices[i] = (Integer)selectedIndices.get(i);
            }
            list.setSelectedIndices(indices);
        }
    }

    private void changeStringDataType(String defaultValue) {
        try {
            this.getProperty().setValue((Object)defaultValue);
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        Object[] valueSet = (String[])this.valuesContext.getPropertySet().getProperty("valueSet").getValue();
        this.createDefaultValueComponent(valueSet, defaultValue);
    }

    private void changeFolderDataType(String defaultValue) {
        File file = null;
        if (!StringUtils.isNullOrEmpty((String)defaultValue)) {
            file = new File(defaultValue);
        }
        Property property = this.getProperty();
        try {
            property.setValue((Object)file);
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        DirectoryEditor folderEditor = new DirectoryEditor();
        this.defaultValueComponent = folderEditor.createEditorComponent(property.getDescriptor(), this.paramContext);
    }

    private void changeFileDataType(String defaultValue) {
        File file = null;
        if (!StringUtils.isNullOrEmpty((String)defaultValue)) {
            file = new File(defaultValue);
        }
        Property property = this.getProperty();
        try {
            property.setValue((Object)file);
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        FileEditor fileEditor = new FileEditor();
        this.defaultValueComponent = fileEditor.createEditorComponent(property.getDescriptor(), this.paramContext);
    }

    private void changeIntegerDataType(String defaultValue) {
        this.changeNumberDataType((NumberConverter)new IntegerConverter(), defaultValue);
    }

    private void changeFloatDataType(String defaultValue) {
        this.changeNumberDataType((NumberConverter)new FloatConverter(), defaultValue);
    }

    private <NumberType extends Number> void changeNumberDataType(NumberConverter<NumberType> converter, String defaultValue) {
        String[] valueSet = (String[])this.valuesContext.getPropertySet().getProperty("valueSet").getValue();
        Object[] numbers = null;
        if (valueSet != null && valueSet.length > 0) {
            numbers = new Number[valueSet.length];
            for (int i = 0; i < valueSet.length; ++i) {
                try {
                    numbers[i] = converter.parse(valueSet[i]);
                    continue;
                }
                catch (ConversionException conversionException) {
                    // empty catch block
                }
            }
        }
        Number defaultNumber = null;
        if (!StringUtils.isNullOrEmpty((String)defaultValue)) {
            try {
                defaultNumber = converter.parse(defaultValue);
            }
            catch (ConversionException e) {
                logger.warning(e.getMessage());
            }
        }
        try {
            this.getProperty().setValue((Object)defaultNumber);
        }
        catch (ValidationException e) {
            logger.warning(e.getMessage());
        }
        this.createDefaultValueComponent(numbers, defaultNumber);
    }

    private JComponent addTextPropertyEditor(JPanel parent, String label, String propertyName, int line, String requiredMessage) {
        PropertyDescriptor propertyDescriptor = this.container.getDescriptor(propertyName);
        JTextField editorComponent = new JTextField();
        Object adapter = null;
        adapter = StringUtils.isNullOrEmpty((String)requiredMessage) ? new TextComponentAdapter((JTextComponent)editorComponent) : new RequiredTextComponentAdapter(editorComponent, requiredMessage);
        this.valuesContext.bind(propertyDescriptor.getName(), (ComponentAdapter)adapter);
        parent.add((Component)new JLabel(label), ToolParameterEditorDialog.getConstraints(line, 0, 1));
        parent.add((Component)editorComponent, ToolParameterEditorDialog.getConstraints(line, 1, 1));
        return editorComponent;
    }

    private JComponent addTextPropertyEditor(JPanel parent, ComponentAdapter adapter, String label, String propertyName, int line) {
        JComponent editorComponent = adapter.getComponents()[0];
        PropertyDescriptor propertyDescriptor = this.container.getDescriptor(propertyName);
        this.valuesContext.bind(propertyDescriptor.getName(), adapter);
        parent.add((Component)new JLabel(label), ToolParameterEditorDialog.getConstraints(line, 0, 1));
        parent.add((Component)editorComponent, ToolParameterEditorDialog.getConstraints(line, 1, 1));
        return editorComponent;
    }

    private JComponent addBoolPropertyEditor(JPanel parent, String label, String propertyName, int line) {
        PropertyDescriptor propertyDescriptor = this.container.getDescriptor(propertyName);
        CheckBoxEditor boolEditor = new CheckBoxEditor();
        JCheckBox checkBoxComponent = (JCheckBox)boolEditor.createEditorComponent(propertyDescriptor, this.valuesContext);
        checkBoxComponent.setBorder(new EmptyBorder(1, 0, 1, 0));
        parent.add((Component)new JLabel(label), ToolParameterEditorDialog.getConstraints(line, 0, 1));
        parent.add((Component)checkBoxComponent, ToolParameterEditorDialog.getConstraints(line, 1, 1));
        return checkBoxComponent;
    }

    private static GridBagConstraints getConstraints(int row, int col, int noCells) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = col;
        c.gridy = row;
        if (noCells != -1) {
            c.gridwidth = noCells;
        }
        c.insets = new Insets(2, 10, 2, 10);
        return c;
    }

    public static String processDefaultValue(Object defaultValue) {
        String defaultValueAsString = null;
        if (defaultValue != null) {
            if (defaultValue.getClass().isArray()) {
                Object[] array = (Object[])defaultValue;
                defaultValueAsString = "";
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        defaultValueAsString = defaultValueAsString + ",";
                    }
                    defaultValueAsString = defaultValueAsString + array[i].toString();
                }
            } else {
                defaultValueAsString = defaultValue.toString();
            }
        }
        return defaultValueAsString;
    }

    private static <NumberType extends Number> boolean canConvertArrayToNumber(NumberConverter<NumberType> converter, String[] valueSet) {
        if (valueSet != null && valueSet.length > 0) {
            for (int i = 0; i < valueSet.length; ++i) {
                try {
                    Number number = converter.parse(valueSet[i]);
                    if (number != null) continue;
                    return false;
                }
                catch (ConversionException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static {
        typesMap.put("String", String.class);
        typesMap.put("File", File.class);
        typesMap.put("Folder", File.class);
        typesMap.put("Integer", Integer.class);
        typesMap.put("Decimal", Float.class);
        typesMap.put("List", String[].class);
        typesMap.put("Boolean", Boolean.class);
    }
}

