/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterListener;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterRegistry;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.actions.ToolAdapterActionRegistrar;
import org.esa.snap.ui.tooladapter.dialogs.AbstractAdapterEditor;
import org.esa.snap.ui.tooladapter.dialogs.Bundle;
import org.esa.snap.ui.tooladapter.dialogs.ModuleSuiteDialog;
import org.esa.snap.ui.tooladapter.dialogs.ToolAdapterExecutionDialog;
import org.esa.snap.ui.tooladapter.model.OperationType;
import org.esa.snap.ui.tooladapter.model.OperatorsTableModel;
import org.esa.snap.utils.AdapterWatcher;
import org.esa.snap.utils.SpringUtilities;

public class ToolAdaptersManagementDialog
extends ModelessDialog {
    final int CHECK_COLUMN_WIDTH = 20;
    final int LABEL_COLUMN_WIDTH = 250;
    final int COLUMN_WIDTH = 270;
    final int PATH_ROW_HEIGHT = 20;
    final int BUTTON_HEIGHT = 32;
    final Dimension buttonDimension = new Dimension(108, 32);
    private AppContext appContext;
    private JTable operatorsTable = null;
    private Logger logger = Logger.getLogger(ToolAdaptersManagementDialog.class.getName());
    private static ToolAdaptersManagementDialog instance;

    public static void showDialog(AppContext appContext, String helpID) {
        if (instance == null) {
            instance = new ToolAdaptersManagementDialog(appContext, Bundle.Dialog_Title(), helpID);
        }
        instance.show();
    }

    private ToolAdaptersManagementDialog(AppContext appContext, String title, String helpID) {
        super(appContext.getApplicationWindow(), title, 0, helpID);
        this.appContext = appContext;
        JPanel contentPanel = this.createContentPanel();
        this.setContent(contentPanel);
        super.getJDialog().setMinimumSize(contentPanel.getPreferredSize());
        EscapeAction.register(super.getJDialog());
        ToolAdapterRegistry.INSTANCE.addListener(new ToolAdapterListener(){

            public void adapterAdded(ToolAdapterOperatorDescriptor operatorDescriptor) {
                ToolAdaptersManagementDialog.this.refreshContent();
            }

            public void adapterRemoved(ToolAdapterOperatorDescriptor operatorDescriptor) {
                ToolAdaptersManagementDialog.this.refreshContent();
            }

            public void adapterUpdated(ToolAdapterOperatorDescriptor operatorDescriptor) {
                ((OperatorsTableModel)ToolAdaptersManagementDialog.this.operatorsTable.getModel()).fireTableDataChanged();
            }
        });
    }

    private JPanel createContentPanel() {
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        int panelHeight = 0;
        JTable propertiesPanel = this.createPropertiesPanel();
        panelHeight = (int)((double)panelHeight + propertiesPanel.getPreferredSize().getHeight());
        panel.add((Component)propertiesPanel, "First");
        panelHeight += 10;
        SpringLayout springLayout = new SpringLayout();
        JPanel adaptersAndButtonsPanel = new JPanel(springLayout);
        JScrollPane scrollPane = new JScrollPane(this.createAdaptersPanel());
        panelHeight = (int)((double)panelHeight + scrollPane.getPreferredSize().getHeight());
        adaptersAndButtonsPanel.add(scrollPane);
        panelHeight += 10;
        JPanel buttonsPanel = this.createButtonsPanel();
        panelHeight = (int)((double)panelHeight + buttonsPanel.getPreferredSize().getHeight());
        adaptersAndButtonsPanel.add(buttonsPanel);
        springLayout.putConstraint("North", (Component)adaptersAndButtonsPanel, 2, "North", (Component)scrollPane);
        springLayout.putConstraint("West", (Component)adaptersAndButtonsPanel, 2, "West", (Component)scrollPane);
        springLayout.putConstraint("East", (Component)adaptersAndButtonsPanel, 2, "East", (Component)scrollPane);
        springLayout.putConstraint("South", (Component)scrollPane, 2, "North", (Component)buttonsPanel);
        springLayout.putConstraint("East", (Component)adaptersAndButtonsPanel, 2, "East", (Component)buttonsPanel);
        springLayout.putConstraint("West", (Component)adaptersAndButtonsPanel, 2, "West", (Component)buttonsPanel);
        springLayout.putConstraint("South", (Component)adaptersAndButtonsPanel, 2, "South", (Component)buttonsPanel);
        SpringUtilities.makeCompactGrid(adaptersAndButtonsPanel, 2, 1, 0, 0, 2, 2);
        panel.add((Component)adaptersAndButtonsPanel, "Center");
        JPanel sideButtonsPanel = this.createSideButtonsPanel();
        panel.add((Component)sideButtonsPanel, "After");
        panel.setPreferredSize(new Dimension(508, panelHeight + 2));
        return panel;
    }

    private JPanel createSideButtonsPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(this.createButton(null, TangoIcons.actions_list_add((TangoIcons.Res)TangoIcons.Res.R22), Bundle.ToolTipNewOperator_Text(), e -> {
            ToolAdapterOperatorDescriptor newOperatorSpi = new ToolAdapterOperatorDescriptor("org.esa.snap.core.gpf.operators.tooladapter.NewOperator", ToolAdapterOp.class, "NewOperator", null, null, null, null, null, null);
            AbstractAdapterEditor dialog = AbstractAdapterEditor.createEditorDialog(this.appContext, this.getJDialog(), newOperatorSpi, OperationType.NEW);
            dialog.show();
            this.refreshContent();
        }));
        panel.add(this.createButton(null, TangoIcons.actions_edit_copy((TangoIcons.Res)TangoIcons.Res.R22), Bundle.ToolTipCopyOperator_Text(), e -> {
            ToolAdapterOperatorDescriptor operatorDesc = this.requestSelection();
            if (operatorDesc != null) {
                String opName = operatorDesc.getName();
                int newNameIndex = 0;
                while (GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(opName) != null) {
                    opName = operatorDesc.getName() + "_" + ++newNameIndex;
                }
                AbstractAdapterEditor dialog = AbstractAdapterEditor.createEditorDialog(this.appContext, this.getJDialog(), operatorDesc, newNameIndex, OperationType.COPY);
                dialog.show();
                this.refreshContent();
            }
        }));
        panel.add(this.createButton(null, TangoIcons.apps_accessories_text_editor((TangoIcons.Res)TangoIcons.Res.R22), Bundle.ToolTipEditOperator_Text(), e -> {
            ToolAdapterOperatorDescriptor operatorDesc = this.requestSelection();
            if (operatorDesc != null) {
                AbstractAdapterEditor dialog = AbstractAdapterEditor.createEditorDialog(this.appContext, this.getJDialog(), operatorDesc, OperationType.EDIT);
                dialog.show();
                this.refreshContent();
            }
        }));
        panel.add(this.createButton(null, TangoIcons.actions_list_remove((TangoIcons.Res)TangoIcons.Res.R22), Bundle.ToolTipDeleteOperator_Text(), e -> {
            ToolAdapterOperatorDescriptor operatorDescriptor = this.requestSelection();
            if (operatorDescriptor != null && Dialogs.Answer.YES == Dialogs.requestDecision((String)Bundle.MessageConfirmRemoval_TitleText(), (String)Bundle.MessageConfirmRemoval_Text(), (boolean)true, (String)Bundle.MessageConfirmRemovalDontAsk_Text())) {
                if (operatorDescriptor.isFromPackage()) {
                    Dialogs.showWarning((String)String.format(Bundle.MessagePackageModules_Text(), operatorDescriptor.getName()));
                } else {
                    ToolAdapterIO.removeOperator((ToolAdapterOperatorDescriptor)operatorDescriptor);
                }
                this.refreshContent();
            }
        }));
        SpringUtilities.makeCompactGrid(panel, 4, 1, 0, 0, 2, 2);
        return panel;
    }

    private JPanel createButtonsPanel() {
        FlowLayout layout = new FlowLayout(4);
        JPanel panel = new JPanel();
        AbstractButton runButton = this.createButton("Run", TangoIcons.actions_media_playback_start((TangoIcons.Res)TangoIcons.Res.R22), Bundle.ToolTipExecuteOperator_Text(), e -> {
            ToolAdapterOperatorDescriptor operatorDesc = this.requestSelection();
            if (operatorDesc != null) {
                ToolAdapterExecutionDialog operatorDialog = new ToolAdapterExecutionDialog(operatorDesc, this.appContext, operatorDesc.getLabel());
                operatorDialog.getJDialog().setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                operatorDialog.show();
            }
        });
        panel.add(runButton);
        AbstractButton packButton = this.createButton("Pack", TangoIcons.apps_system_installer((TangoIcons.Res)TangoIcons.Res.R22), Bundle.ToolTipExport_Text(), e -> {
            ModuleSuiteDialog dialog = new ModuleSuiteDialog(this.appContext, "Create Adapter Suite", null, this.getSelection());
            dialog.show();
            this.refreshContent();
        });
        panel.add(packButton);
        AbstractButton closeButton = this.createButton("Close", TangoIcons.actions_system_log_out((TangoIcons.Res)TangoIcons.Res.R22), null, e -> this.onClose());
        panel.add(closeButton);
        return panel;
    }

    private AbstractButton createButton(String text, ImageIcon icon, String toolTip, ActionListener actionListener) {
        JButton button = StringUtils.isNullOrEmpty((String)text) ? new JButton(icon) : new JButton(text, icon);
        Dimension dimension = StringUtils.isNullOrEmpty((String)text) ? new Dimension(24, 24) : this.buttonDimension;
        button.setMinimumSize(dimension);
        button.setMaximumSize(dimension);
        button.setPreferredSize(dimension);
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        return button;
    }

    private JTable createPropertiesPanel() {
        DefaultTableModel model = new DefaultTableModel(1, 2){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        model.setValueAt(Bundle.PathLabel_Text(), 0, 0);
        model.setValueAt(ToolAdapterIO.getAdaptersPath(), 0, 1);
        model.addTableModelListener(l -> {
            String newPath = model.getValueAt(0, 1).toString();
            Path path = Paths.get(newPath, new String[0]);
            Path oldPath = ToolAdapterIO.getAdaptersPath();
            try {
                if (Files.isSameFile(oldPath, path)) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!Files.exists(path, new LinkOption[0]) && Dialogs.Answer.YES == Dialogs.requestDecision((String)"Path does not exist", (String)"The path you have entered does not exist.\nDo you want to create it?", (boolean)true, (String)"Don't ask me in the future")) {
                try {
                    Files.createDirectories(Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent(), new FileAttribute[0]);
                }
                catch (IOException ex) {
                    Dialogs.showError((String)"Path could not be created!");
                }
            }
            if (Files.exists(path, new LinkOption[0])) {
                ToolAdapterOperatorDescriptor[] operatorDescriptors;
                for (ToolAdapterOperatorDescriptor descriptor : operatorDescriptors = ToolAdapterActionRegistrar.getActionMap().values().toArray(new ToolAdapterOperatorDescriptor[ToolAdapterActionRegistrar.getActionMap().values().size()])) {
                    ToolAdapterIO.removeOperator((ToolAdapterOperatorDescriptor)descriptor, (boolean)false);
                }
                AdapterWatcher.INSTANCE.unmonitorPath(oldPath);
                ToolAdapterIO.setAdaptersPath((Path)path);
                if (!newPath.equals(oldPath.toAbsolutePath().toString())) {
                    ToolAdapterIO.searchAndRegisterAdapters();
                    this.refreshContent();
                }
                try {
                    AdapterWatcher.INSTANCE.monitorPath(path);
                }
                catch (IOException e) {
                    this.logger.warning(String.format("Could not watch for the new adapter path %s [%s]", path.toString(), e.getMessage()));
                }
            }
        });
        final JTable table = new JTable(model);
        TableColumn labelColumn = table.getColumnModel().getColumn(0);
        labelColumn.setPreferredWidth(135);
        TableColumn pathColumn = table.getColumnModel().getColumn(1);
        pathColumn.setPreferredWidth(270);
        pathColumn.setCellEditor(new FileChooserCellEditor());
        table.setAutoResizeMode(3);
        table.setRowHeight(20);
        table.setBorder(BorderFactory.createLineBorder(Color.black));
        table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                Object source = e.getSource();
                if (!table.equals(source)) {
                    table.editingCanceled(new ChangeEvent(source));
                    table.clearSelection();
                }
            }
        });
        return table;
    }

    private JTable createAdaptersPanel() {
        ArrayList<ToolAdapterOperatorDescriptor> toolboxSpis = new ArrayList<ToolAdapterOperatorDescriptor>();
        toolboxSpis.addAll(ToolAdapterRegistry.INSTANCE.getOperatorMap().values().stream().map(e -> (ToolAdapterOperatorDescriptor)e.getOperatorDescriptor()).collect(Collectors.toList()));
        toolboxSpis.sort(Comparator.comparing(ToolAdapterOperatorDescriptor::getAlias));
        OperatorsTableModel model = new OperatorsTableModel(toolboxSpis);
        this.operatorsTable = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent event) {
                Point point = event.getPoint();
                int col = this.columnAtPoint(point);
                String tip = null;
                if (col == 0) {
                    int row = this.rowAtPoint(point);
                    tip = "<html><p style=\"color:";
                    tip = TangoIcons.emblems_emblem_important((TangoIcons.Res)TangoIcons.Res.R16).equals(this.getValueAt(row, col)) ? tip + "red;\">Tool executable not found!<br/>Verify that the adapter bundle is installed or the tool location is correct." : tip + "green;\">Tool seems properly configured.";
                    tip = tip + "</p></html>";
                }
                return tip;
            }
        };
        this.operatorsTable.setRowHeight(20);
        TableColumnModel columnModel = this.operatorsTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(60);
        columnModel.getColumn(0).setMaxWidth(60);
        columnModel.getColumn(0).setResizable(false);
        columnModel.getColumn(1).setPreferredWidth(250);
        columnModel.getColumn(1).setMaxWidth(300);
        columnModel.getColumn(2).setResizable(true);
        columnModel.getColumn(2).setPreferredWidth(250);
        this.operatorsTable.setAutoResizeMode(3);
        this.operatorsTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    int selectedRow = ToolAdaptersManagementDialog.this.operatorsTable.getSelectedRow();
                    ToolAdaptersManagementDialog.this.operatorsTable.repaint();
                    ToolAdapterOperatorDescriptor operatorDesc = ((OperatorsTableModel)ToolAdaptersManagementDialog.this.operatorsTable.getModel()).getObjectAt(selectedRow);
                    ToolAdaptersManagementDialog.this.operatorsTable.setCursor(Cursor.getPredefinedCursor(3));
                    AbstractAdapterEditor dialog = AbstractAdapterEditor.createEditorDialog(ToolAdaptersManagementDialog.this.appContext, ToolAdaptersManagementDialog.this.getJDialog(), operatorDesc, OperationType.EDIT);
                    ToolAdaptersManagementDialog.this.operatorsTable.setCursor(Cursor.getPredefinedCursor(0));
                    dialog.show();
                    ToolAdaptersManagementDialog.this.refreshContent();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        return this.operatorsTable;
    }

    private Set<ToolAdapterOperatorDescriptor> getSelection() {
        int[] selectedRows;
        HashSet<ToolAdapterOperatorDescriptor> selection = new HashSet<ToolAdapterOperatorDescriptor>();
        for (int idx : selectedRows = this.operatorsTable.getSelectedRows()) {
            selection.add(((OperatorsTableModel)this.operatorsTable.getModel()).getObjectAt(idx));
        }
        return selection;
    }

    private ToolAdapterOperatorDescriptor requestSelection() {
        ToolAdapterOperatorDescriptor selected = null;
        int selectedRow = this.operatorsTable.getSelectedRow();
        if (selectedRow >= 0) {
            selected = ((OperatorsTableModel)this.operatorsTable.getModel()).getObjectAt(selectedRow);
        } else {
            Dialogs.showWarning((String)Bundle.MessageNoSelection_Text());
        }
        return selected;
    }

    private void refreshContent() {
        this.setContent(this.createContentPanel());
        this.getContent().repaint();
    }

    public class FileChooserCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private static final int CLICK_COUNT_TO_START = 2;
        private JButton button;
        private JFileChooser fileChooser;
        private String file;

        public FileChooserCellEditor() {
            super(new JTextField());
            this.file = "";
            this.setClickCountToStart(2);
            this.button = new JButton();
            this.button.setBackground(Color.white);
            this.button.setFont(this.button.getFont().deriveFont(0));
            this.button.setBorder(null);
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(1);
        }

        @Override
        public Object getCellEditorValue() {
            return this.file;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.file = value.toString();
            SwingUtilities.invokeLater(() -> {
                this.fileChooser.setSelectedFile(new File(this.file));
                if (this.fileChooser.showOpenDialog(this.button) == 0) {
                    this.file = this.fileChooser.getSelectedFile().getAbsolutePath();
                }
                this.fireEditingStopped();
            });
            this.button.setText(this.file);
            return this.button;
        }
    }
}

