/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.validators.PatternValidator;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.descriptor.AnnotationOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.dependency.BundleInstaller;
import org.esa.snap.core.gpf.descriptor.dependency.BundleLocation;
import org.esa.snap.core.gpf.descriptor.template.FileTemplate;
import org.esa.snap.core.gpf.descriptor.template.TemplateEngine;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOpSpi;
import org.esa.snap.modules.ModulePackager;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.actions.ToolAdapterActionRegistrar;
import org.esa.snap.ui.tooladapter.dialogs.Bundle;
import org.esa.snap.ui.tooladapter.dialogs.BundleForm;
import org.esa.snap.ui.tooladapter.dialogs.ToolAdapterEditorDialog;
import org.esa.snap.ui.tooladapter.dialogs.ToolAdapterTabbedEditorDialog;
import org.esa.snap.ui.tooladapter.dialogs.components.AnchorLabel;
import org.esa.snap.ui.tooladapter.model.AutoCompleteTextArea;
import org.esa.snap.ui.tooladapter.model.OperationType;
import org.esa.snap.ui.tooladapter.model.OperatorParametersTable;
import org.esa.snap.ui.tooladapter.model.VariablesTable;
import org.esa.snap.ui.tooladapter.validators.DecoratedNotEmptyValidator;
import org.esa.snap.ui.tooladapter.validators.RequiredFieldValidator;
import org.esa.snap.utils.AdapterWatcher;
import org.esa.snap.utils.SpringUtilities;
import org.esa.snap.utils.UIUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;

public abstract class AbstractAdapterEditor
extends ModalDialog {
    private static final String MESSAGE_REQUIRED = "This field is required";
    static final int MIN_WIDTH = 720;
    static final int MIN_HEIGHT = 580;
    static final int MIN_TABBED_WIDTH = 640;
    static final int MIN_TABBED_HEIGHT = 512;
    static int MAX_4K_WIDTH = 4096;
    static int MAX_4K_HEIGHT = 2160;
    private ToolAdapterOperatorDescriptor oldOperatorDescriptor;
    ToolAdapterOperatorDescriptor newOperatorDescriptor;
    private int newNameIndex = -1;
    PropertyContainer propertyContainer;
    BindingContext bindingContext;
    private JTextArea templateContent;
    OperatorParametersTable paramsTable;
    protected AppContext context;
    protected Logger logger;
    private JTextField customMenuLocation;
    private JRadioButton rbMenuNew;
    private static final String helpID = "sta_editor";
    int formWidth;
    int controlHeight = 24;
    private OperationType currentOperation;
    VariablesTable varTable;
    BundleForm bundleForm;
    Map<String, AnchorLabel> anchorLabels = new HashMap<String, AnchorLabel>();
    private JPanel errorPanel;
    Callable<Void> downloadAction;

    static AbstractAdapterEditor createEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, OperationType operation) {
        return new ToolAdapterTabbedEditorDialog(appContext, parent, operatorDescriptor, operation);
    }

    static AbstractAdapterEditor createEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, int newNameIndex, OperationType operation) {
        return new ToolAdapterTabbedEditorDialog(appContext, parent, operatorDescriptor, newNameIndex, operation);
    }

    private AbstractAdapterEditor(AppContext appContext, JDialog parent, String title) {
        super(parent.getOwner(), title, 161, new Object[]{new JButton(Bundle.CTL_Button_Export_Text())}, helpID);
        this.context = appContext;
        this.logger = Logger.getLogger(ToolAdapterEditorDialog.class.getName());
        this.registerButton(-1431655766, new JButton(Bundle.CTL_Button_Export_Text()));
        this.controlHeight = (this.getJDialog().getFont().getSize() + 1) * 2;
        this.errorPanel = new JPanel();
        this.errorPanel.setLayout(new BoxLayout(this.errorPanel, 1));
        this.getButtonPanel().add((Component)this.errorPanel, 0);
    }

    private AbstractAdapterEditor(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor) {
        this(appContext, parent, operatorDescriptor.getAlias());
        ToolParameterDescriptor parameterDescriptor;
        this.oldOperatorDescriptor = operatorDescriptor;
        this.newOperatorDescriptor = new ToolAdapterOperatorDescriptor(this.oldOperatorDescriptor);
        if (this.newOperatorDescriptor.getToolParameterDescriptors().stream().filter(p -> p.getName().equals("sourceProduct")).count() == 0L) {
            parameterDescriptor = new ToolParameterDescriptor("sourceProduct", Product[].class);
            parameterDescriptor.setDescription("Input product");
            this.newOperatorDescriptor.getToolParameterDescriptors().add(parameterDescriptor);
        }
        if (this.newOperatorDescriptor.getToolParameterDescriptors().stream().filter(p -> p.getName().equals("sourceProductFile")).count() == 0L) {
            parameterDescriptor = new ToolParameterDescriptor("sourceProductFile", File[].class);
            parameterDescriptor.setDescription("Input file");
            this.newOperatorDescriptor.getToolParameterDescriptors().add(parameterDescriptor);
        }
        if (this.newOperatorDescriptor.getToolParameterDescriptors().stream().filter(p -> p.getName().equals("targetProductFile")).count() == 0L) {
            parameterDescriptor = new ToolParameterDescriptor("targetProductFile", File.class);
            parameterDescriptor.setDescription("Output file");
            parameterDescriptor.setNotNull(false);
            this.newOperatorDescriptor.getToolParameterDescriptors().add(parameterDescriptor);
        } else {
            Optional<ToolParameterDescriptor> result = this.newOperatorDescriptor.getToolParameterDescriptors().stream().filter(p -> p.getName().equals("targetProductFile")).findFirst();
            result.ifPresent(toolParameterDescriptor -> toolParameterDescriptor.setDescription("Output file"));
        }
        this.propertyContainer = PropertyContainer.createObjectBacked((Object)this.newOperatorDescriptor);
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Object[] writers = registry.getAllProductWriterFormatStrings();
        Arrays.sort(writers);
        this.propertyContainer.getDescriptor("processingWriter").setValueSet(new ValueSet(writers));
        Set spis = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpis();
        ArrayList toolboxSpis = new ArrayList();
        spis.stream().filter(p -> p instanceof ToolAdapterOpSpi && p.getOperatorDescriptor().getClass() != AnnotationOperatorDescriptor.class && !p.getOperatorAlias().equals(this.oldOperatorDescriptor.getAlias())).forEach(operator -> toolboxSpis.add(operator.getOperatorDescriptor().getAlias()));
        toolboxSpis.sort(Comparator.naturalOrder());
        this.propertyContainer.getDescriptor("preprocessorExternalTool").setValueSet(new ValueSet((Object[])toolboxSpis.toArray(new String[toolboxSpis.size()])));
        this.bindingContext = new BindingContext((PropertySet)this.propertyContainer);
        this.paramsTable = new OperatorParametersTable(this.newOperatorDescriptor, appContext);
        this.varTable = new VariablesTable(this.newOperatorDescriptor.getVariables(), appContext);
    }

    AbstractAdapterEditor(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, OperationType operation) {
        this(appContext, parent, operatorDescriptor);
        this.currentOperation = operation;
        this.newNameIndex = -1;
        this.setContent(this.createMainPanel());
        EscapeAction.register(this.getJDialog());
    }

    AbstractAdapterEditor(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, int newNameIndex, OperationType operation) {
        this(appContext, parent, operatorDescriptor);
        this.newNameIndex = newNameIndex;
        this.currentOperation = operation;
        if (this.newNameIndex >= 1) {
            this.newOperatorDescriptor.setName(this.oldOperatorDescriptor.getName() + "_" + this.newNameIndex);
            this.newOperatorDescriptor.setAlias(this.oldOperatorDescriptor.getAlias() + "_" + this.newNameIndex);
        }
        this.setContent(this.createMainPanel());
        EscapeAction.register(this.getJDialog());
    }

    ToolAdapterOperatorDescriptor getUpdatedOperatorDescriptor() {
        return this.newOperatorDescriptor;
    }

    protected abstract JComponent createMainPanel();

    protected abstract JPanel createDescriptorPanel();

    protected abstract JPanel createVariablesPanel();

    protected abstract JPanel createPreProcessingPanel();

    protected abstract JPanel createToolInfoPanel();

    protected abstract JPanel createPatternsPanel();

    protected abstract JPanel createParametersPanel();

    protected abstract JPanel createBundlePanel();

    private boolean shouldValidate() {
        String value = NbPreferences.forModule(Dialogs.class).get("sta.validate.save", null);
        return value != null && Boolean.parseBoolean(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyUserInput() {
        block22: {
            ParameterDescriptor[] parameterDescriptors;
            AnchorLabel anchorLabel;
            boolean problemFound;
            block24: {
                block23: {
                    Path toolLocation;
                    this.varTable.stopVariablesTableEditing();
                    this.paramsTable.stopVariablesTableEditing();
                    if (!this.shouldValidate()) break block22;
                    String fileLocation = this.newOperatorDescriptor.getMainToolFileLocation();
                    File file = null;
                    if (fileLocation != null) {
                        file = new File(fileLocation);
                        Object value = this.bindingContext.getBinding("mainToolFileLocation").getPropertyValue();
                        if (value != null) {
                            file = value instanceof File ? (File)value : new File(value.toString());
                        }
                    }
                    boolean bl = problemFound = file == null;
                    if (!(problemFound || Files.exists(toolLocation = this.newOperatorDescriptor.resolveVariables(this.newOperatorDescriptor.getMainToolFileLocation()).toPath(), new LinkOption[0]) && Files.isExecutable(toolLocation))) {
                        problemFound = true;
                    }
                    anchorLabel = this.anchorLabels.get("mainToolFileLocation");
                    if (problemFound) {
                        if (Arrays.stream(this.errorPanel.getComponents()).noneMatch(anchorLabel::equals)) {
                            this.errorPanel.add(anchorLabel);
                            anchorLabel.markError();
                            this.errorPanel.revalidate();
                        }
                    } else if (Arrays.stream(this.errorPanel.getComponents()).anyMatch(anchorLabel::equals)) {
                        this.errorPanel.remove(anchorLabel);
                        anchorLabel.clearError();
                        this.errorPanel.revalidate();
                    }
                    File workingDir = this.newOperatorDescriptor.resolveVariables(this.newOperatorDescriptor.getWorkingDir());
                    anchorLabel = this.anchorLabels.get("workingDir");
                    if (workingDir == null || !workingDir.exists()) break block23;
                    if (workingDir.isDirectory()) break block24;
                }
                if (!Arrays.stream(this.errorPanel.getComponents()).noneMatch(anchorLabel::equals)) return false;
                this.errorPanel.add(anchorLabel);
                anchorLabel.markError();
                this.errorPanel.revalidate();
                return false;
            }
            if (Arrays.stream(this.errorPanel.getComponents()).anyMatch(anchorLabel::equals)) {
                this.errorPanel.remove(anchorLabel);
                anchorLabel.clearError();
                this.errorPanel.revalidate();
            }
            if (problemFound) {
                return false;
            }
            List variables = this.newOperatorDescriptor.getVariables();
            if (variables != null) {
                for (SystemVariable variable : variables) {
                    String key = variable.getKey();
                    if (key == null || key.isEmpty()) {
                        Dialogs.showWarning((String)Bundle.MSG_Empty_Variable_Key_Text());
                        return false;
                    }
                    String value = variable.getValue();
                    if (value != null && !value.isEmpty()) continue;
                    Dialogs.showWarning((String)String.format(Bundle.MSG_Empty_Variable_Text(), key));
                    return false;
                }
            }
            if ((parameterDescriptors = this.newOperatorDescriptor.getParameterDescriptors()) != null && parameterDescriptors.length > 0) {
                for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
                    Class dataType = parameterDescriptor.getDataType();
                    String defaultValue = parameterDescriptor.getDefaultValue();
                    if (!File.class.isAssignableFrom(dataType) || !parameterDescriptor.isNotNull() && !parameterDescriptor.isNotEmpty() || defaultValue != null && !defaultValue.isEmpty() && Files.exists(Paths.get(defaultValue, new String[0]), new LinkOption[0])) continue;
                    Dialogs.showWarning((String)String.format(Bundle.MSG_Inexistem_Parameter_Value_Text(), parameterDescriptor.getName(), parameterDescriptor.isNotNull() ? "NotNull" : "NotEmpty"));
                    return false;
                }
            }
        }
        if (this.currentOperation.equals((Object)OperationType.COPY) || this.currentOperation.equals((Object)OperationType.NEW) || this.currentOperation.equals((Object)OperationType.COPY) && !this.newOperatorDescriptor.getName().equals(this.oldOperatorDescriptor.getName())) {
            AnchorLabel anchorLabel = this.anchorLabels.get("name");
            JPanel buttonPanel = this.getButtonPanel();
            if (GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(this.newOperatorDescriptor.getName()) != null) {
                if (!Arrays.stream(buttonPanel.getComponents()).noneMatch(anchorLabel::equals)) return false;
                buttonPanel.add((Component)anchorLabel, 0);
                buttonPanel.revalidate();
                return false;
            }
            if (Arrays.stream(buttonPanel.getComponents()).anyMatch(anchorLabel::equals)) {
                buttonPanel.remove(anchorLabel);
                buttonPanel.revalidate();
            }
        }
        if (!this.newOperatorDescriptor.getBundle().getLocation().equals((Object)BundleLocation.LOCAL)) return true;
        File bundleFile = this.newOperatorDescriptor.resolveVariables(this.newOperatorDescriptor.getBundle().getSource());
        if (bundleFile != null && bundleFile.exists()) {
            if (!bundleFile.isDirectory()) return true;
        }
        Dialogs.showWarning((String)Bundle.MSG_Empty_Bundle_Key_Text());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOK() {
        if (!this.verifyUserInput()) {
            Dialogs.showWarning((String)Bundle.MSG_Wrong_Value_Text());
            this.getJDialog().requestFocus();
        } else {
            String templateContent = this.templateContent.getText();
            if (!this.resolveTemplateProductCount(templateContent)) {
                Dialogs.showWarning((String)Bundle.MSG_Wrong_Usage_Array_Text());
                this.getJDialog().requestFocus();
            } else {
                Path backupCopy = null;
                Throwable thrown = null;
                try {
                    String menuLocation;
                    String customMenuLocationText;
                    backupCopy = ToolAdapterIO.backupOperator((ToolAdapterOperatorDescriptor)this.oldOperatorDescriptor);
                    if (this.newOperatorDescriptor.getSourceProductCount() == 0) {
                        Dialogs.showInformation((String)"The template is not using the parameter $sourceProduct.\nNo source product selection will be available at execution time.", (String)"empty.source.info");
                    }
                    if (!this.newOperatorDescriptor.isFromPackage()) {
                        this.newOperatorDescriptor.setSource("user");
                    }
                    FileTemplate template = new FileTemplate(TemplateEngine.createInstance((ToolAdapterOperatorDescriptor)this.newOperatorDescriptor, (TemplateType)TemplateType.VELOCITY), this.newOperatorDescriptor.getAlias() + "-template.vm");
                    template.setContents(templateContent, true);
                    this.newOperatorDescriptor.setTemplate(template);
                    List toolParameterDescriptors = this.newOperatorDescriptor.getToolParameterDescriptors();
                    toolParameterDescriptors.stream().filter(param -> this.paramsTable.getBindingContext().getBinding(param.getName()) != null).filter(param -> this.paramsTable.getBindingContext().getBinding(param.getName()).getPropertyValue() != null).forEach(param -> {
                        Object propertyValue = this.paramsTable.getBindingContext().getBinding(param.getName()).getPropertyValue();
                        if (param.isParameter()) {
                            String defaultValueString = propertyValue.getClass().isArray() ? String.join((CharSequence)",", Arrays.stream((Object[])propertyValue).map(Object::toString).collect(Collectors.toList())) : propertyValue.toString();
                            param.setDefaultValue(defaultValueString);
                        }
                    });
                    List remParameters = toolParameterDescriptors.stream().filter(param -> "sourceProduct".equals(param.getName()) || "sourceProductFile".equals(param.getName())).collect(Collectors.toList());
                    this.newOperatorDescriptor.removeParamDescriptors(remParameters);
                    if (this.rbMenuNew.isSelected() && (customMenuLocationText = this.customMenuLocation.getText()) != null && !customMenuLocationText.isEmpty()) {
                        this.newOperatorDescriptor.setMenuLocation(customMenuLocationText);
                    }
                    if ((menuLocation = this.newOperatorDescriptor.getMenuLocation()) != null && !menuLocation.startsWith("Menu/")) {
                        this.newOperatorDescriptor.setMenuLocation("Menu/" + menuLocation);
                    }
                    this.newOperatorDescriptor.setBundles(this.bundleForm.applyChanges());
                    AdapterWatcher.INSTANCE.suspend();
                    if (this.currentOperation != OperationType.NEW) {
                        ToolAdapterActionRegistrar.removeOperatorMenu(this.oldOperatorDescriptor);
                    }
                    ToolAdapterIO.saveAndRegisterOperator((ToolAdapterOperatorDescriptor)this.newOperatorDescriptor);
                    this.oldOperatorDescriptor = this.newOperatorDescriptor;
                    AdapterWatcher.INSTANCE.resume();
                    ToolAdapterIO.deleteFolder((Path)backupCopy);
                    super.setButtonID(1);
                    super.hide();
                }
                catch (TemplateException tex) {
                    this.logger.warning(tex.getMessage());
                    Dialogs.showError((String)("The adapter template contains errors [" + tex.toString() + "]!"));
                    thrown = tex;
                }
                catch (Exception e) {
                    this.logger.warning(e.getMessage());
                    Dialogs.showError((String)("There was an error on saving the operator; check the disk space and permissions and try again! " + e.toString()));
                    thrown = e;
                }
                finally {
                    if (thrown != null && backupCopy != null) {
                        try {
                            ToolAdapterIO.restoreOperator((ToolAdapterOperatorDescriptor)this.oldOperatorDescriptor, (Path)backupCopy);
                        }
                        catch (IOException e) {
                            this.logger.severe(e.getMessage());
                            Dialogs.showError((String)("The operator could not be restored [" + e.getMessage() + "]"));
                        }
                    }
                }
            }
        }
    }

    public int show() {
        this.getJDialog().revalidate();
        if (this.currentOperation == OperationType.FORCED_EDIT) {
            if (BundleInstaller.isBundleFileAvailable((org.esa.snap.core.gpf.descriptor.dependency.Bundle)this.oldOperatorDescriptor.getBundle())) {
                SwingUtilities.invokeLater(() -> {
                    Dialogs.Answer answer = Dialogs.requestDecision((String)"Bundle Available", (String)"A bundle has been configured for this adapter.\nDo you want to proceed with bundle download/installation?", (boolean)false, null);
                    if (answer == Dialogs.Answer.YES) {
                        if (this.downloadAction != null) {
                            try {
                                this.downloadAction.call();
                            }
                            catch (Exception e) {
                                this.logger.warning(e.getMessage());
                            }
                        }
                    } else {
                        this.onOK();
                    }
                });
            } else {
                SwingUtilities.invokeLater(this::onOK);
            }
        }
        return super.show();
    }

    protected void onOther() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showOpenDialog(this.getButton(-1431655766)) == 0) {
                File targetFolder = fileChooser.getSelectedFile();
                this.newOperatorDescriptor.setSource("package");
                this.onOK();
                ModulePackager.packModule(this.newOperatorDescriptor, new File(targetFolder, this.newOperatorDescriptor.getAlias() + ".nbm"));
                Dialogs.showInformation((String)String.format(Bundle.MSG_Export_Complete_Text(), targetFolder.getAbsolutePath()), null);
            }
        }
        catch (IOException e) {
            this.logger.warning(e.getMessage());
            Dialogs.showError((String)e.getMessage());
        }
    }

    JComponent createCheckboxComponent(String memberName, JComponent toogleComponentEnabled, Boolean value) {
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor(memberName);
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        if (editorComponent instanceof JCheckBox && toogleComponentEnabled != null) {
            ((JCheckBox)editorComponent).setSelected(value);
            toogleComponentEnabled.setEnabled(value);
            ((JCheckBox)editorComponent).addActionListener(e -> toogleComponentEnabled.setEnabled(((JCheckBox)editorComponent).isSelected()));
        }
        return editorComponent;
    }

    JComponent addValidatedTextField(JPanel parent, TextFieldEditor textEditor, String labelText, String propertyName, String validatorRegex) {
        if (validatorRegex == null || validatorRegex.isEmpty()) {
            return this.addTextField(parent, textEditor, labelText, propertyName, false, null);
        }
        JLabel jLabel = new JLabel(labelText);
        parent.add(jLabel);
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor(propertyName);
        propertyDescriptor.setValidator((Validator)new PatternValidator(Pattern.compile(validatorRegex)));
        JComponent editorComponent = textEditor.createEditorComponent(propertyDescriptor, this.bindingContext);
        UIUtils.addPromptSupport(editorComponent, "enter " + labelText.toLowerCase().replace(":", "") + " here");
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        jLabel.setLabelFor(editorComponent);
        parent.add(editorComponent);
        return editorComponent;
    }

    JComponent addTextField(JPanel parent, TextFieldEditor textEditor, String labelText, String propertyName, boolean isRequired, String[] excludedChars) {
        JLabel jLabel = new JLabel(labelText);
        Dimension size = jLabel.getPreferredSize();
        parent.add(jLabel);
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor(propertyName);
        if (isRequired) {
            propertyDescriptor.setValidator((Validator)new DecoratedNotEmptyValidator(jLabel, excludedChars));
            jLabel.setMaximumSize(new Dimension(size.width + 20, size.height));
        }
        JComponent editorComponent = textEditor.createEditorComponent(propertyDescriptor, this.bindingContext);
        UIUtils.addPromptSupport(editorComponent, "enter " + labelText.toLowerCase().replace(":", "") + " here");
        UIUtils.enableUndoRedo(editorComponent);
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        jLabel.setLabelFor(editorComponent);
        parent.add(editorComponent);
        return editorComponent;
    }

    JComponent addComboField(JPanel parent, String labelText, String propertyName, boolean isRequired, boolean isEditable) {
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor(propertyName);
        propertyDescriptor.setNotEmpty(isRequired);
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        if (editorComponent instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)editorComponent;
            comboBox.setEditable(isEditable);
            comboBox.setEnabled(isEditable);
        }
        JLabel jLabel = new JLabel(labelText);
        parent.add(jLabel);
        jLabel.setLabelFor(editorComponent);
        parent.add(editorComponent);
        return editorComponent;
    }

    void addComboField(JPanel parent, String labelText, String propertyName, List<String> values) {
        JLabel jLabel = new JLabel(labelText);
        parent.add(jLabel);
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor(propertyName);
        propertyDescriptor.setNotEmpty(true);
        values.sort(Comparator.naturalOrder());
        propertyDescriptor.setValueSet(new ValueSet(values.toArray()));
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComp = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        if (editorComp instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)editorComp;
            comboBox.setEditable(true);
        }
        editorComp.setMaximumSize(new Dimension(editorComp.getMaximumSize().width, this.controlHeight));
        this.customMenuLocation = new JTextField();
        this.customMenuLocation.setInputVerifier(new RequiredFieldValidator(Bundle.MSG_Empty_MenuLocation_Text()));
        this.customMenuLocation.setEnabled(false);
        JPanel subPanel = new JPanel(new SpringLayout());
        subPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JRadioButton rbExistingMenu = new JRadioButton(Bundle.CTL_Label_RadioButton_ExistingMenus(), true);
        this.rbMenuNew = new JRadioButton(Bundle.CTL_Label_RadioButton_NewMenu());
        ButtonGroup rbGroup = new ButtonGroup();
        rbGroup.add(rbExistingMenu);
        rbGroup.add(this.rbMenuNew);
        rbExistingMenu.setVerifyInputWhenFocusTarget(false);
        rbExistingMenu.addItemListener(e -> {
            editorComp.setEnabled(e.getStateChange() == 1);
            this.customMenuLocation.setEnabled(e.getStateChange() == 2);
        });
        subPanel.add(rbExistingMenu);
        subPanel.add(this.rbMenuNew);
        jLabel.setLabelFor(editorComp);
        subPanel.add(editorComp);
        subPanel.add(this.customMenuLocation);
        Dimension dimension = new Dimension(parent.getWidth() / 2, this.controlHeight);
        editorComp.setPreferredSize(dimension);
        this.customMenuLocation.setPreferredSize(dimension);
        subPanel.setPreferredSize(new Dimension(subPanel.getWidth(), (int)(2.5 * (double)this.controlHeight)));
        subPanel.setMaximumSize(new Dimension(subPanel.getWidth(), (int)(2.5 * (double)this.controlHeight)));
        SpringUtilities.makeCompactGrid(subPanel, 2, 2, 2, 2, 2, 2);
        parent.add(subPanel);
    }

    List<String> getAvailableMenuOptions(FileObject current) {
        FileObject[] children;
        ArrayList<String> resultList = new ArrayList<String>();
        if (current == null) {
            current = FileUtil.getConfigRoot().getFileObject("Menu");
        }
        for (FileObject child : children = current.getChildren()) {
            String entry = child.getPath();
            if (entry.endsWith(".instance") || entry.endsWith(".shadow") || entry.endsWith(".xml")) continue;
            resultList.add(entry);
            resultList.addAll(this.getAvailableMenuOptions(child));
        }
        return resultList;
    }

    private boolean resolveTemplateProductCount(String templateContent) {
        boolean success = true;
        if (templateContent.contains("sourceProduct") || templateContent.contains("sourceProductFile")) {
            int idx = templateContent.lastIndexOf("sourceProduct[");
            if (idx > 0) {
                String value = templateContent.substring(idx + "sourceProduct[".length(), templateContent.indexOf("]", idx));
                int maxNum = Integer.valueOf(value) + 1;
                if (maxNum > 1) {
                    this.newOperatorDescriptor.setSourceProductCount(maxNum);
                } else {
                    success = false;
                }
            } else {
                idx = templateContent.lastIndexOf("sourceProductFile[");
                if (idx > 0) {
                    String value = templateContent.substring(idx + "sourceProductFile[".length(), templateContent.indexOf("]", idx));
                    int maxNum = Integer.valueOf(value) + 1;
                    if (maxNum > 1) {
                        this.newOperatorDescriptor.setSourceProductCount(maxNum);
                    } else {
                        success = false;
                    }
                } else {
                    this.newOperatorDescriptor.setSourceProductCount(1);
                }
            }
        } else {
            this.newOperatorDescriptor.setSourceProductCount(0);
        }
        return success;
    }

    JTextArea createTemplateEditorField() {
        boolean useAutocomplete = Boolean.parseBoolean(NbPreferences.forModule(Dialogs.class).get("sta.autocomplete", "false"));
        this.templateContent = useAutocomplete ? new AutoCompleteTextArea("", 15, 9) : new JTextArea("", 15, 9);
        UIUtils.enableUndoRedo(this.templateContent);
        try {
            if (this.currentOperation == OperationType.NEW || this.currentOperation == OperationType.COPY) {
                FileTemplate template = this.oldOperatorDescriptor.getTemplate();
                if (template != null) {
                    this.templateContent.setText(template.getContents());
                }
            } else {
                FileTemplate template = this.newOperatorDescriptor.getTemplate();
                if (template != null) {
                    this.templateContent.setText(template.getContents());
                }
            }
        }
        catch (IOException | OperatorException e) {
            this.logger.warning(e.getMessage());
        }
        this.templateContent.setInputVerifier(new RequiredFieldValidator(MESSAGE_REQUIRED));
        if (useAutocomplete && this.templateContent instanceof AutoCompleteTextArea) {
            ((AutoCompleteTextArea)this.templateContent).setAutoCompleteEntries(this.getAutocompleteEntries());
            ((AutoCompleteTextArea)this.templateContent).setTriggerChar('$');
        }
        return this.templateContent;
    }

    void adjustDimension(JButton component) {
        FontMetrics metrics = component.getFontMetrics(component.getFont());
        int width = metrics.stringWidth(component.getText());
        component.setPreferredSize(new Dimension(width + 32, this.controlHeight));
        component.setBounds(new Rectangle(component.getLocation(), component.getPreferredSize()));
    }

    private List<String> getAutocompleteEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        entries.addAll(this.newOperatorDescriptor.getVariables().stream().map(SystemVariable::getKey).collect(Collectors.toList()));
        for (ParameterDescriptor parameterDescriptor : this.newOperatorDescriptor.getParameterDescriptors()) {
            entries.add(parameterDescriptor.getName());
        }
        entries.sort(Comparator.naturalOrder());
        return entries;
    }
}

