/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterListener;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOpSpi;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterRegistry;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.tooladapter.actions.ExecuteToolAdapterAction;
import org.esa.snap.utils.AdapterWatcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;

public class ToolAdapterActionRegistrar {
    private static final String DEFAULT_MENU_PATH = "Menu/Tools/External Tools";
    private static FileObject defaultMenu;
    private static final Map<String, ToolAdapterOperatorDescriptor> actionMap;
    private static final ToolAdapterListener listener;

    public static Map<String, ToolAdapterOperatorDescriptor> getActionMap() {
        return actionMap;
    }

    public static String getDefaultMenuLocation() {
        return DEFAULT_MENU_PATH;
    }

    public static void registerOperatorMenu(ToolAdapterOperatorDescriptor operator) {
        String menuGroup = operator.getMenuLocation();
        if (menuGroup == null) {
            operator.setMenuLocation(DEFAULT_MENU_PATH);
        }
        ToolAdapterActionRegistrar.registerOperatorMenu(operator, true);
    }

    public static void registerOperatorMenu(ToolAdapterOperatorDescriptor operator, boolean hasChanged) {
        String menuLocation = operator.getMenuLocation();
        try {
            ToolAdapterActionRegistrar.getDefaultLocation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (menuLocation == null) {
            menuLocation = ToolAdapterActionRegistrar.getDefaultMenuLocation();
            operator.setMenuLocation(menuLocation);
        }
        FileObject menuFolder = FileUtil.getConfigFile((String)menuLocation);
        try {
            String menuKey;
            FileObject newItem;
            if (menuFolder == null) {
                menuFolder = FileUtil.getConfigFile((String)"Menu");
                StringTokenizer tokenizer = new StringTokenizer(menuLocation, "/");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if ("Menu".equals(token)) continue;
                    FileObject subMenu = menuFolder.getFileObject(token);
                    if (subMenu == null) {
                        menuFolder = menuFolder.createFolder(token);
                        continue;
                    }
                    menuFolder = subMenu;
                }
                menuFolder.setAttribute("position", (Object)2000);
            }
            if ((newItem = menuFolder.getFileObject(menuKey = operator.getAlias(), "instance")) == null) {
                newItem = menuFolder.createData(menuKey, "instance");
            }
            ExecuteToolAdapterAction action = new ExecuteToolAdapterAction(menuKey);
            newItem.setAttribute("instanceCreate", (Object)action);
            newItem.setAttribute("instanceClass", (Object)((Object)((Object)action)).getClass().getName());
            if (actionMap.containsKey(menuKey)) {
                actionMap.remove(menuKey);
            }
            actionMap.put(menuKey, operator);
        }
        catch (IOException e) {
            Dialogs.showError((String)("Error:" + e.getMessage()));
        }
    }

    public static void removeOperatorMenu(ToolAdapterOperatorDescriptor operator) {
        FileObject menuFolder = FileUtil.getConfigFile((String)operator.getMenuLocation());
        try {
            FileObject defaultLocation;
            FileObject[] children;
            if (menuFolder != null) {
                FileObject[] children2;
                String operatorAlias = operator.getAlias();
                FileObject newItem = menuFolder.getFileObject(operatorAlias, "instance");
                if (newItem != null) {
                    newItem.delete();
                }
                if (actionMap.containsKey(operatorAlias)) {
                    actionMap.remove(operatorAlias);
                }
                if ((children2 = menuFolder.getChildren()) == null || children2.length == 0) {
                    menuFolder.delete();
                }
            }
            if ((children = (defaultLocation = ToolAdapterActionRegistrar.getDefaultLocation()).getChildren()) == null || children.length == 0) {
                defaultLocation.delete();
            }
        }
        catch (IOException e) {
            Dialogs.showError((String)("Error:" + e.getMessage()));
        }
    }

    private static FileObject getDefaultLocation() throws IOException {
        if (defaultMenu == null) {
            defaultMenu = FileUtil.getConfigFile((String)DEFAULT_MENU_PATH);
            if (defaultMenu == null) {
                defaultMenu = FileUtil.getConfigFile((String)"Menu").getFileObject("Tools");
                defaultMenu = defaultMenu.createFolder(DEFAULT_MENU_PATH.replace("Menu/Tools/", ""));
            }
            FileObject[] objects = defaultMenu.getParent().getChildren();
            int position = 9999;
            Object value = objects[objects.length - 1].getAttribute("position");
            if (value != null) {
                position = (Integer)value + 1;
            }
            defaultMenu.setAttribute("position", (Object)position);
        }
        return defaultMenu;
    }

    static {
        actionMap = new HashMap<String, ToolAdapterOperatorDescriptor>();
        listener = new ToolAdapterListener(){

            public void adapterAdded(ToolAdapterOperatorDescriptor operatorDescriptor) {
                ToolAdapterActionRegistrar.registerOperatorMenu(operatorDescriptor);
            }

            public void adapterRemoved(ToolAdapterOperatorDescriptor operatorDescriptor) {
                ToolAdapterActionRegistrar.removeOperatorMenu(operatorDescriptor);
            }
        };
    }

    public static class StopOp
    implements Runnable {
        @Override
        public void run() {
            AdapterWatcher.INSTANCE.stopMonitor();
        }
    }

    public static class StartOp
    implements Runnable {
        @Override
        public void run() {
            Map<String, File> jarAdapters;
            OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
            Path jarPaths = Paths.get(Places.getUserDirectory().getAbsolutePath(), "modules");
            Map<String, File> map = jarAdapters = Files.exists(jarPaths, new LinkOption[0]) ? this.getJarAdapters(jarPaths.toFile()) : null;
            if (spiRegistry != null) {
                Set operatorSpis = spiRegistry.getOperatorSpis();
                if (operatorSpis != null) {
                    if (operatorSpis.size() == 0) {
                        operatorSpis.addAll(ToolAdapterIO.searchAndRegisterAdapters());
                    }
                    operatorSpis.stream().filter(spi -> spi instanceof ToolAdapterOpSpi).forEach(spi -> {
                        OperatorDescriptor descriptor = spi.getOperatorDescriptor();
                        if (descriptor instanceof ToolAdapterOperatorDescriptor) {
                            ToolAdapterActionRegistrar.registerOperatorMenu((ToolAdapterOperatorDescriptor)descriptor, false);
                        }
                    });
                }
                ToolAdapterRegistry.INSTANCE.addListener(listener);
                AdapterWatcher.INSTANCE.startMonitor();
            }
        }

        private Map<String, File> getJarAdapters(File fromPath) {
            HashMap<String, File> output = new HashMap<String, File>();
            if (fromPath != null && fromPath.exists()) {
                String descriptionKeyName = "OpenIDE-Module-Short-Description";
                Attributes.Name typeKey = new Attributes.Name("OpenIDE-Module-Type");
                File[] files = fromPath.listFiles((dir, name) -> name.endsWith("jar"));
                if (files != null) {
                    try {
                        for (File file : files) {
                            Attributes manifestEntries;
                            JarFile jarFile = new JarFile(file);
                            Manifest manifest = jarFile.getManifest();
                            if (manifest == null || !(manifestEntries = manifest.getMainAttributes()).containsKey(typeKey) || !"STA".equals(manifestEntries.getValue(typeKey.toString()))) continue;
                            output.put(manifestEntries.getValue(descriptionKeyName), file);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return output;
        }
    }
}

