/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.modules;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.esa.snap.core.gpf.descriptor.OSFamily;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.dependency.Bundle;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.modules.InfoBuilder;
import org.esa.snap.modules.ManifestBuilder;
import org.esa.snap.modules.ModuleConfigBuilder;
import org.esa.snap.modules.ModuleSuiteDescriptor;
import org.esa.snap.modules.UpdateBuilder;
import org.openide.modules.Modules;

public final class ModulePackager {
    private static final Manifest _manifest;
    private static final Attributes.Name ATTR_DESCRIPTION_NAME;
    private static final Attributes.Name ATTR_MODULE_NAME;
    private static final Attributes.Name ATTR_MODULE_TYPE;
    private static final Attributes.Name ATTR_MODULE_IMPLEMENTATION;
    private static final Attributes.Name ATTR_MODULE_SPECIFICATION;
    private static final Attributes.Name ATTR_MODULE_DEPENDENCIES;
    private static final Attributes.Name ATTR_MODULE_ALIAS;
    private static final File modulesPath;
    private static final String layerXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE filesystem PUBLIC \"-//NetBeans//DTD Filesystem 1.1//EN\" \"http://www.netbeans.org/dtds/filesystem-1_1.dtd\">\n<filesystem>\n    <folder name=\"Actions\">\n        <folder name=\"Tools\">\n            <file name=\"org-esa-snap-ui-tooladapter-actions-ExecuteToolAdapterAction.instance\"/>\n            <attr name=\"displayName\" stringvalue=\"#NAME#\"/>\n            <attr name=\"instanceCreate\" methodvalue=\"org.openide.awt.Actions.alwaysEnabled\"/>\n        </folder>\n    </folder>\n    <folder name=\"Menu\">\n        <folder name=\"Tools\">\n            <folder name=\"External Tools\">\n                <file name=\"org-esa-snap-ui-tooladapter-actions-ExecuteToolAdapterAction.shadow\">\n                    <attr name=\"originalFile\" stringvalue=\"Actions/Tools/org-esa-snap-ui-tooladapter-actions-ExecuteToolAdapterAction.instance\"/>\n                    <attr name=\"position\" intvalue=\"1000\"/>\n                </file>\n            </folder>\n        </folder>\n    </folder>\n</filesystem>";
    private static final String LAYER_XML_PATH = "org/esa/snap/ui/tooladapter/layer.xml";
    private static final String IMPLEMENTATION_VERSION;
    private static final String SPECIFICATION_VERSION;
    private static final String STA_MODULE = "org.esa.snap.snap.sta";
    private static final String STA_UI_MODULE = "org.esa.snap.snap.sta.ui";
    private static final String SNAP_RCP_MODULE = "org.esa.snap.snap.rcp";
    private static final String SNAP_CORE_MODULE = "org.esa.snap.snap.core";

    public static void packModules(ModuleSuiteDescriptor suiteDescriptor, File suiteFile, Map<OSFamily, Bundle> bundles, ToolAdapterOperatorDescriptor ... descriptors) throws IOException {
        if (suiteFile != null && descriptors != null && descriptors.length > 0) {
            if (descriptors.length == 1) {
                ModulePackager.packModule(descriptors[0], suiteFile);
            } else {
                Path suiteFilePath = suiteFile.toPath();
                if (!Files.isDirectory(suiteFilePath, new LinkOption[0])) {
                    suiteFilePath = suiteFilePath.getParent();
                }
                HashMap<String, String> dependentModules = new HashMap<String, String>();
                UpdateBuilder updateBuilder = new UpdateBuilder();
                for (ToolAdapterOperatorDescriptor descriptor : descriptors) {
                    updateBuilder.moduleManifest(ModulePackager.packModule(descriptor, suiteFilePath.resolve(descriptor.getAlias() + ".nbm").toFile(), true));
                    dependentModules.put(ModulePackager.normalize(descriptor.getName()), SPECIFICATION_VERSION);
                }
                if (bundles != null) {
                    Arrays.stream(descriptors).forEach(d -> d.setBundles(bundles));
                }
                ModulePackager.packSuite(suiteDescriptor, suiteFile, dependentModules, bundles);
                Files.write(suiteFilePath.resolve("updates.xml"), updateBuilder.build(true).getBytes(), new OpenOption[0]);
            }
        }
    }

    public static String packModule(ToolAdapterOperatorDescriptor descriptor, File nbmFile) throws IOException {
        return ModulePackager.packModule(descriptor, nbmFile, false);
    }

    private static String packModule(ToolAdapterOperatorDescriptor descriptor, File nbmFile, boolean isPartOfSuite) throws IOException {
        String manifestXml = null;
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(nbmFile));){
            ZipEntry entry = new ZipEntry("Info/info.xml");
            zipStream.putNextEntry(entry);
            InfoBuilder infoBuilder = new InfoBuilder();
            String javaVersion = System.getProperty("java.version");
            javaVersion = javaVersion.substring(0, javaVersion.indexOf("_"));
            String descriptorName = ModulePackager.normalize(descriptor.getName());
            String description = descriptor.getDescription();
            infoBuilder.moduleName(descriptorName).shortDescription(description).longDescription(description).displayCategory("SNAP").specificationVersion(SPECIFICATION_VERSION).implementationVersion(SPECIFICATION_VERSION).codebase(descriptorName.toLowerCase()).distribution(nbmFile.getName()).downloadSize(0).homePage("https://github.com/senbox-org/s2tbx").needsRestart(true).releaseDate(new Date()).isEssentialModule(false).showInClient(!isPartOfSuite).javaVersion(javaVersion).dependency(STA_MODULE, SPECIFICATION_VERSION).dependency(STA_UI_MODULE, SPECIFICATION_VERSION).dependency(SNAP_RCP_MODULE, SPECIFICATION_VERSION).dependency(SNAP_CORE_MODULE, SPECIFICATION_VERSION);
            byte[] byteBuffer = infoBuilder.build(true).getBytes();
            manifestXml = infoBuilder.build(false);
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            entry = new ZipEntry("META-INF/MANIFEST.MF");
            zipStream.putNextEntry(entry);
            byteBuffer = new ManifestBuilder().build(true).getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            String jarName = descriptorName.replace(".", "-") + ".jar";
            entry = new ZipEntry("netbeans/config/Modules/" + descriptorName.replace(".", "-") + ".xml");
            zipStream.putNextEntry(entry);
            ModuleConfigBuilder mcb = new ModuleConfigBuilder();
            byteBuffer = mcb.name(descriptorName).autoLoad(false).eager(false).enabled(true).jarName(jarName).reloadable(false).build(true).getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            entry = new ZipEntry("netbeans/modules/ext/");
            zipStream.putNextEntry(entry);
            zipStream.closeEntry();
            entry = new ZipEntry("netbeans/modules/" + jarName);
            zipStream.putNextEntry(entry);
            zipStream.write(ModulePackager.packAdapterJar(descriptor));
            zipStream.closeEntry();
            Map bundles = descriptor.getBundles();
            if (!isPartOfSuite && bundles != null) {
                for (Bundle bundle : bundles.values()) {
                    if (!bundle.isLocal() || bundle.getTargetLocation() == null || bundle.getEntryPoint() == null) continue;
                    entry = new ZipEntry("netbeans/modules/lib/");
                    zipStream.putNextEntry(entry);
                    zipStream.closeEntry();
                    String entryPoint = bundle.getEntryPoint();
                    File entryPointPath = bundle.getSource();
                    if (!entryPointPath.exists()) continue;
                    entry = new ZipEntry("netbeans/modules/lib/" + entryPoint);
                    zipStream.putNextEntry(entry);
                    zipStream.write(Files.readAllBytes(entryPointPath.toPath()));
                    zipStream.closeEntry();
                }
            }
            entry = new ZipEntry("netbeans/update_tracking/");
            zipStream.putNextEntry(entry);
            zipStream.closeEntry();
        }
        return manifestXml;
    }

    public static void unpackAdapterJar(File jarFile, File unpackFolder) throws IOException {
        Throwable throwable;
        Attributes attributes;
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        if (unpackFolder == null) {
            unpackFolder = new File(modulesPath, jarFile.getName().replace(".jar", ""));
        }
        if (!unpackFolder.exists()) {
            Files.createDirectories(unpackFolder.toPath(), new FileAttribute[0]);
        }
        if ((attributes = jar.getManifest().getMainAttributes()).containsKey(ATTR_MODULE_IMPLEMENTATION)) {
            String version = attributes.getValue(ATTR_MODULE_IMPLEMENTATION);
            File versionFile = new File(unpackFolder, "version.txt");
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(versionFile);){
                fos.write(version.getBytes());
                fos.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            File f = new File(unpackFolder, file.getName());
            if (file.isDirectory()) {
                Files.createDirectories(f.toPath(), new FileAttribute[0]);
                continue;
            }
            Files.createDirectories(f.getParentFile().toPath(), new FileAttribute[0]);
            InputStream is = jar.getInputStream(file);
            throwable = null;
            try {
                try (FileOutputStream fos = new FileOutputStream(f);){
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                    fos.close();
                }
                is.close();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public static String getAdapterVersion(File jarFile) throws IOException {
        String version = null;
        JarFile jar = new JarFile(jarFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        if (attributes.containsKey(ATTR_MODULE_IMPLEMENTATION)) {
            version = attributes.getValue(ATTR_MODULE_IMPLEMENTATION);
        }
        jar.close();
        return version;
    }

    public static String getAdapterAlias(File jarFile) throws IOException {
        String version = null;
        JarFile jar = new JarFile(jarFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        if (attributes.containsKey(ATTR_MODULE_ALIAS)) {
            version = attributes.getValue(ATTR_MODULE_ALIAS);
        }
        jar.close();
        return version;
    }

    private static void packSuite(ModuleSuiteDescriptor descriptor, File nbmFile, Map<String, String> dependencies, Map<OSFamily, Bundle> bundles) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(nbmFile));){
            ZipEntry entry = new ZipEntry("Info/info.xml");
            zipStream.putNextEntry(entry);
            InfoBuilder infoBuilder = new InfoBuilder();
            String javaVersion = System.getProperty("java.version");
            javaVersion = javaVersion.substring(0, javaVersion.indexOf("_"));
            String descriptorName = descriptor.getName();
            String description = descriptor.getDescription();
            infoBuilder.moduleName(descriptorName).shortDescription(description).longDescription(description).displayCategory("SNAP").specificationVersion(SPECIFICATION_VERSION).implementationVersion(IMPLEMENTATION_VERSION).codebase(descriptorName.toLowerCase()).distribution(nbmFile.getName()).downloadSize(0).homePage("https://github.com/senbox-org/s2tbx").needsRestart(true).releaseDate(new Date()).isEssentialModule(false).showInClient(true).javaVersion(javaVersion).dependency(STA_MODULE, SPECIFICATION_VERSION).dependency(STA_UI_MODULE, SPECIFICATION_VERSION).dependency(SNAP_RCP_MODULE, SPECIFICATION_VERSION).dependency(SNAP_CORE_MODULE, SPECIFICATION_VERSION);
            if (dependencies != null) {
                for (Map.Entry<String, String> mapEntry : dependencies.entrySet()) {
                    infoBuilder.dependency(mapEntry.getKey(), mapEntry.getValue());
                }
            }
            byte[] byteBuffer = infoBuilder.build(true).getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            entry = new ZipEntry("META-INF/MANIFEST.MF");
            zipStream.putNextEntry(entry);
            byteBuffer = new ManifestBuilder().build(true).getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            String jarName = descriptorName.replace(".", "-") + ".jar";
            entry = new ZipEntry("netbeans/config/Modules/" + descriptorName.replace(".", "-") + ".xml");
            zipStream.putNextEntry(entry);
            ModuleConfigBuilder mcb = new ModuleConfigBuilder();
            byteBuffer = mcb.name(descriptorName).autoLoad(false).eager(false).enabled(true).jarName(jarName).reloadable(false).build(true).getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            entry = new ZipEntry("netbeans/modules/" + jarName);
            zipStream.putNextEntry(entry);
            zipStream.write(ModulePackager.packSuiteJar(descriptor, dependencies));
            zipStream.closeEntry();
            if (bundles != null) {
                for (Bundle bundle : bundles.values()) {
                    if (!bundle.isLocal() || bundle.getTargetLocation() == null || bundle.getEntryPoint() == null) continue;
                    entry = new ZipEntry("netbeans/modules/lib/");
                    zipStream.putNextEntry(entry);
                    zipStream.closeEntry();
                    String entryPoint = bundle.getEntryPoint();
                    File entryPointPath = bundle.getSource();
                    if (!entryPointPath.exists()) continue;
                    entry = new ZipEntry("netbeans/modules/lib/" + entryPoint);
                    zipStream.putNextEntry(entry);
                    zipStream.write(Files.readAllBytes(entryPointPath.toPath()));
                    zipStream.closeEntry();
                }
            }
            entry = new ZipEntry("netbeans/update_tracking/");
            zipStream.putNextEntry(entry);
            zipStream.closeEntry();
        }
    }

    private static byte[] packSuiteJar(ModuleSuiteDescriptor descriptor, Map<String, String> modules) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(ATTR_MODULE_NAME, descriptor.getName());
        attributes.put(ATTR_DESCRIPTION_NAME, descriptor.getDescription());
        attributes.put(ATTR_MODULE_SPECIFICATION, SPECIFICATION_VERSION);
        attributes.put(new Attributes.Name("OpenIDE-Module-Java-Dependencies"), "Java > 1.8");
        attributes.put(new Attributes.Name("OpenIDE-Module-Display-Category"), "SNAP");
        attributes.put(ATTR_MODULE_TYPE, "STA");
        String dependenciesValue = "org.esa.snap.snap.sta, org.esa.snap.snap.sta.ui";
        for (Map.Entry<String, String> entry : modules.entrySet()) {
            dependenciesValue = dependenciesValue + ", " + entry.getKey() + " > " + entry.getValue();
        }
        attributes.put(ATTR_MODULE_DEPENDENCIES, dependenciesValue);
        ByteArrayOutputStream fOut = new ByteArrayOutputStream();
        try (JarOutputStream jarOut = new JarOutputStream((OutputStream)fOut, manifest);){
            jarOut.close();
        }
        return fOut.toByteArray();
    }

    private static byte[] packAdapterJar(ToolAdapterOperatorDescriptor descriptor) throws IOException {
        _manifest.getMainAttributes().put(ATTR_DESCRIPTION_NAME, descriptor.getAlias());
        _manifest.getMainAttributes().put(ATTR_MODULE_NAME, descriptor.getName());
        _manifest.getMainAttributes().put(ATTR_MODULE_IMPLEMENTATION, SPECIFICATION_VERSION);
        _manifest.getMainAttributes().put(ATTR_MODULE_SPECIFICATION, SPECIFICATION_VERSION);
        _manifest.getMainAttributes().put(ATTR_MODULE_ALIAS, descriptor.getAlias());
        File moduleFolder = new File(modulesPath, descriptor.getAlias());
        ByteArrayOutputStream fOut = new ByteArrayOutputStream();
        try (JarOutputStream jarOut = new JarOutputStream((OutputStream)fOut, _manifest);){
            File[] files = moduleFolder.listFiles();
            if (files != null) {
                for (File child : files) {
                    try {
                        if (child.getName().endsWith("ModuleInstaller.class")) {
                            child.delete();
                            continue;
                        }
                        ModulePackager.addFile(child, jarOut);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                String contents = layerXml.replace("#NAME#", descriptor.getLabel());
                JarEntry entry = new JarEntry(LAYER_XML_PATH);
                jarOut.putNextEntry(entry);
                byte[] buffer = contents.getBytes();
                jarOut.write(buffer, 0, buffer.length);
                jarOut.closeEntry();
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            jarOut.close();
        }
        return fOut.toByteArray();
    }

    private static void addFile(File source, JarOutputStream target) throws IOException {
        String entryName = source.getPath().replace(modulesPath.getAbsolutePath(), "").replace("\\", "/").substring(1);
        if (!(entryName = entryName.substring(entryName.indexOf("/") + 1)).toLowerCase().endsWith("manifest.mf")) {
            if (source.isDirectory()) {
                File[] files;
                if (!entryName.isEmpty()) {
                    if (!entryName.endsWith("/")) {
                        entryName = entryName + "/";
                    }
                    JarEntry entry = new JarEntry(entryName);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                if ((files = source.listFiles()) != null) {
                    for (File nestedFile : files) {
                        ModulePackager.addFile(nestedFile, target);
                    }
                }
                return;
            }
            JarEntry entry = new JarEntry(entryName);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            ModulePackager.writeBytes(source, target);
            target.closeEntry();
        }
    }

    private static void addFile(Class fromClass, JarOutputStream target) throws IOException {
        String classEntry = fromClass.getName().replace('.', '/') + ".class";
        URL classURL = fromClass.getClassLoader().getResource(classEntry);
        if (classURL != null) {
            JarEntry entry = new JarEntry(classEntry);
            target.putNextEntry(entry);
            if (!classURL.toString().contains("!")) {
                String fileName = classURL.getFile();
                ModulePackager.writeBytes(fileName, target);
            } else {
                try (InputStream stream = fromClass.getClassLoader().getResourceAsStream(classEntry);){
                    ModulePackager.writeBytes(stream, target);
                }
            }
            target.closeEntry();
        }
    }

    private static void writeBytes(String fileName, JarOutputStream target) throws IOException {
        ModulePackager.writeBytes(new File(fileName), target);
    }

    private static void writeBytes(File file, JarOutputStream target) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(file);
             BufferedInputStream inputStream = new BufferedInputStream(fileStream);){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = inputStream.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
        }
    }

    private static void writeBytes(InputStream stream, JarOutputStream target) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = stream.read(buffer)) != -1) {
            target.write(buffer, 0, count);
        }
    }

    private static String normalize(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Empty value");
        }
        return input.replace("-", ".").replace(" ", "_");
    }

    static {
        String implementationVersion = Modules.getDefault().ownerOf(ModulePackager.class).getImplementationVersion();
        IMPLEMENTATION_VERSION = implementationVersion.indexOf("-") > 0 ? implementationVersion.substring(implementationVersion.indexOf("-") + 1) : implementationVersion;
        SPECIFICATION_VERSION = implementationVersion.indexOf("-") > 0 ? implementationVersion.substring(0, implementationVersion.indexOf("-")) : implementationVersion;
        _manifest = new Manifest();
        Attributes attributes = _manifest.getMainAttributes();
        ATTR_DESCRIPTION_NAME = new Attributes.Name("OpenIDE-Module-Short-Description");
        ATTR_MODULE_NAME = new Attributes.Name("OpenIDE-Module");
        ATTR_MODULE_TYPE = new Attributes.Name("OpenIDE-Module-Type");
        ATTR_MODULE_IMPLEMENTATION = new Attributes.Name("OpenIDE-Module-Implementation-Version");
        ATTR_MODULE_SPECIFICATION = new Attributes.Name("OpenIDE-Module-Specification-Version");
        ATTR_MODULE_ALIAS = new Attributes.Name("OpenIDE-Module-Alias");
        ATTR_MODULE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Module-Dependencies");
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("OpenIDE-Module-Java-Dependencies"), "Java > 1.8");
        attributes.put(ATTR_MODULE_DEPENDENCIES, "org.esa.snap.snap.sta, org.esa.snap.snap.sta.ui");
        attributes.put(new Attributes.Name("OpenIDE-Module-Display-Category"), "SNAP");
        attributes.put(ATTR_MODULE_TYPE, "STA");
        attributes.put(ATTR_DESCRIPTION_NAME, "External tool adapter");
        modulesPath = ToolAdapterIO.getAdaptersPath().toFile();
    }
}

