/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.modules;

import java.util.HashMap;
import java.util.Map;
import org.esa.snap.modules.AbstractBuilder;

public class ManifestBuilder
extends AbstractBuilder {
    private String version = "1.0";
    private String javaVersion = this.javaVersion.substring(0, this.javaVersion.indexOf("_"));
    private Map<String, String> properties = new HashMap<String, String>();

    public ManifestBuilder version(String value) {
        this.version = value;
        return this;
    }

    public ManifestBuilder javaVersion(String value) {
        this.javaVersion = value;
        return this;
    }

    public ManifestBuilder property(String name, String value) {
        this.properties.putIfAbsent(name, value);
        return this;
    }

    @Override
    public String build(boolean standalone) {
        StringBuilder builder = new StringBuilder();
        builder.append("Manifest-Version: ").append(this.safeValue(this.version)).append("\n").append("Created-By: ").append(this.safeValue(this.javaVersion)).append("\n");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return builder.toString();
    }
}

