/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.modules;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.modules.AbstractBuilder;

public class InfoBuilder
extends AbstractBuilder {
    private String codebaseName;
    private String distribution;
    private int downloadSize;
    private String homePage;
    private boolean needsRestart;
    private Date releaseDate;
    private boolean isEssentialModule;
    private boolean showInClient;
    private String moduleName;
    private String longDescription;
    private String shortDescription;
    private String displayCategory;
    private String implementationVersion;
    private String specificationVersion;
    private String javaVersion;
    private Map<String, String> dependencies = new HashMap<String, String>();

    public InfoBuilder codebase(String value) {
        this.codebaseName = value;
        return this;
    }

    public InfoBuilder distribution(String value) {
        this.distribution = value;
        return this;
    }

    public InfoBuilder downloadSize(int value) {
        this.downloadSize = value;
        return this;
    }

    public InfoBuilder homePage(String value) {
        this.homePage = value;
        return this;
    }

    public InfoBuilder longDescription(String value) {
        this.longDescription = value;
        return this;
    }

    public InfoBuilder shortDescription(String value) {
        this.shortDescription = value;
        return this;
    }

    public InfoBuilder displayCategory(String value) {
        this.displayCategory = value;
        return this;
    }

    public InfoBuilder implementationVersion(String value) {
        this.implementationVersion = value;
        return this;
    }

    public InfoBuilder specificationVersion(String value) {
        this.specificationVersion = value;
        return this;
    }

    public InfoBuilder javaVersion(String value) {
        this.javaVersion = value;
        return this;
    }

    public InfoBuilder dependency(String name, String version) {
        this.dependencies.put(name, version);
        return this;
    }

    public InfoBuilder releaseDate(Date value) {
        this.releaseDate = value;
        return this;
    }

    public InfoBuilder needsRestart(boolean value) {
        this.needsRestart = value;
        return this;
    }

    public InfoBuilder isEssentialModule(boolean value) {
        this.isEssentialModule = value;
        return this;
    }

    public InfoBuilder showInClient(boolean value) {
        this.showInClient = value;
        return this;
    }

    public InfoBuilder moduleName(String value) {
        this.moduleName = value;
        return this;
    }

    @Override
    public String build(boolean standalone) {
        StringBuilder xmlBuilder = new StringBuilder();
        if (standalone) {
            xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Autoupdate Module Info 2.5//EN\" \"http://www.netbeans.org/dtds/autoupdate-info-2_5.dtd\">");
        }
        xmlBuilder.append("<module codenamebase=\"").append(this.safeValue(this.codebaseName).toLowerCase()).append("\" ").append("distribution=\"").append(this.safeValue(this.distribution)).append("\" ").append("downloadsize=\"").append(this.downloadSize).append("\" ").append("homepage=\"").append(this.safeValue(this.homePage)).append("\" ").append("needsrestart=\"").append(this.safeValue(this.needsRestart)).append("\" ").append("releasedate=\"").append(new SimpleDateFormat("yyyy/MM/dd").format(this.releaseDate != null ? this.releaseDate : new Date())).append("\">\n").append("<manifest AutoUpdate-Essential-Module=\"").append(this.safeValue(this.isEssentialModule)).append("\" ").append("AutoUpdate-Show-In-Client=\"").append(this.safeValue(this.showInClient)).append("\" ").append("OpenIDE-Module=\"").append(this.safeValue(this.moduleName)).append("\" ").append("OpenIDE-Module-Display-Category=\"").append(this.safeValue(this.displayCategory)).append("\" ").append("OpenIDE-Module-Implementation-Version=\"").append(this.safeValue(this.implementationVersion)).append("\" ").append("OpenIDE-Module-Java-Dependencies=\"Java &gt; ").append(this.safeValue(this.javaVersion)).append("\" ").append("OpenIDE-Module-Long-Description=\"&lt;p&gt;").append(this.safeValue(this.longDescription)).append("&lt;/p&gt;\" ").append("OpenIDE-Module-Module-Dependencies=\"");
        String depValues = "";
        for (Map.Entry<String, String> entry : this.dependencies.entrySet()) {
            depValues = depValues + entry.getKey() + " &gt; " + entry.getValue() + ", ";
        }
        if (depValues.length() > 0) {
            depValues = depValues.substring(0, depValues.length() - 2);
        }
        xmlBuilder.append(depValues);
        xmlBuilder.append("\" ").append("OpenIDE-Module-Name=\"").append(this.moduleName).append("\" ").append("OpenIDE-Module-Requires=\"org.openide.modules.ModuleFormat1\" ").append("OpenIDE-Module-Short-Description=\"").append(this.shortDescription).append("\" ").append("OpenIDE-Module-Specification-Version=\"").append(this.safeValue(this.specificationVersion)).append("\"/>\n</module>");
        return xmlBuilder.toString();
    }
}

