/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.writer;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;

public class CsvProductWriter
extends AbstractProductWriter {
    public static final int WRITE_PROPERTIES = 1;
    public static final int WRITE_FEATURES = 2;
    protected final int config;
    protected Writer writer;
    private String separator;
    private boolean productWritten;

    public CsvProductWriter(ProductWriterPlugIn plugIn, int config, Writer writer) {
        super(plugIn);
        this.writer = writer;
        this.config = config;
        this.productWritten = false;
    }

    protected void writeProductNodesImpl() throws IOException {
        if (this.writer == null) {
            this.writer = new FileWriter(new File(this.getOutput().toString()));
        }
        this.getSeparatorFromMetaData();
        this.writeProperties();
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        TiePointGrid[] tiePointGrids;
        Band[] bands = this.getSourceProduct().getBands();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFeatureIdColumnNameFromMetadata());
        for (Band band : bands) {
            builder.append(this.separator);
            builder.append(band.getName());
            builder.append(":");
            int dataType = band.getGeophysicalImage().getData().getDataBuffer().getDataType();
            builder.append(this.getJavaType(dataType));
        }
        for (TiePointGrid tpg : tiePointGrids = this.getSourceProduct().getTiePointGrids()) {
            builder.append(this.separator);
            builder.append(tpg.getName());
            builder.append(":");
            int dataType = tpg.getGeophysicalImage().getData().getDataBuffer().getDataType();
            builder.append(this.getJavaType(dataType));
        }
        this.writeLine(builder.toString());
    }

    private String getJavaType(int dataType) {
        switch (dataType) {
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 0: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 1: {
                return "ushort";
            }
            case 3: {
                return "int";
            }
        }
        throw new IllegalArgumentException("Unsupported type '" + dataType + "'.");
    }

    private void writeLine(String line) throws IOException {
        this.writer.write(line);
        this.writer.write("\n");
    }

    private void writeProperties() throws IOException {
        if ((this.config & 1) != 1) {
            return;
        }
        this.writeLine("#sceneRasterWidth=" + this.getSourceProduct().getSceneRasterWidth());
    }

    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        if (this.productWritten) {
            return;
        }
        Band[] bands = this.getSourceProduct().getBands();
        DataBuffer[] bandDataBuffers = new DataBuffer[bands.length];
        int[] bandTypes = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            Band band = bands[i];
            bandDataBuffers[i] = band.getGeophysicalImage().getData().getDataBuffer();
            bandTypes[i] = bandDataBuffers[i].getDataType();
        }
        TiePointGrid[] tiePointGrids = this.getSourceProduct().getTiePointGrids();
        DataBuffer[] tpgDataBuffers = new DataBuffer[tiePointGrids.length];
        int[] tpgTypes = new int[tiePointGrids.length];
        for (int i = 0; i < tiePointGrids.length; ++i) {
            TiePointGrid tpg = tiePointGrids[i];
            tpgDataBuffers[i] = tpg.getGeophysicalImage().getData().getDataBuffer();
            tpgTypes[i] = tpgDataBuffers[i].getDataType();
        }
        for (int j = 0; j < this.getSourceProduct().getSceneRasterHeight(); ++j) {
            for (int i = 0; i < this.getSourceProduct().getSceneRasterWidth(); ++i) {
                Number elem;
                int type;
                DataBuffer buffer;
                int k;
                StringBuilder line = new StringBuilder();
                int index = j * this.getSourceProduct().getSceneRasterWidth() + i;
                line.append(this.getFeatureIdFromMetadata(index));
                for (k = 0; k < bandDataBuffers.length; ++k) {
                    buffer = bandDataBuffers[k];
                    line.append(this.separator);
                    type = bandTypes[k];
                    if (type == 3 || type == 2 || type == 1 || type == 0) {
                        elem = buffer.getElem(index);
                    } else if (type == 4) {
                        elem = Float.valueOf(buffer.getElemFloat(index));
                    } else if (type == 5) {
                        elem = buffer.getElemDouble(index);
                    } else {
                        throw new IllegalArgumentException("Undefined band data type '" + type + "' in source product.");
                    }
                    line.append(elem);
                }
                for (k = 0; k < tpgDataBuffers.length; ++k) {
                    buffer = tpgDataBuffers[k];
                    line.append(this.separator);
                    type = tpgTypes[k];
                    if (type == 3 || type == 2 || type == 1 || type == 0) {
                        elem = buffer.getElem(index);
                    } else if (type == 4) {
                        elem = Float.valueOf(buffer.getElemFloat(index));
                    } else if (type == 5) {
                        elem = buffer.getElemDouble(index);
                    } else {
                        throw new IllegalArgumentException("Undefined tie point grid data type '" + type + "' in source product.");
                    }
                    line.append(elem);
                }
                this.writeLine(line.toString());
            }
        }
        this.productWritten = true;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void deleteOutput() throws IOException {
    }

    private void getSeparatorFromMetaData() {
        this.separator = "\t";
    }

    private String getFeatureIdFromMetadata(int rowIndex) {
        return rowIndex + "";
    }

    private String getFeatureIdColumnNameFromMetadata() {
        return "featureId";
    }
}

