/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.reader;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.stream.DoubleStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelTimeCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TimeCoding;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.csv.dataio.Constants;
import org.esa.snap.csv.dataio.CsvFile;
import org.esa.snap.csv.dataio.CsvSource;
import org.esa.snap.csv.dataio.CsvSourceParser;
import org.opengis.feature.type.AttributeDescriptor;

public class CsvProductReader
extends AbstractProductReader {
    private CsvSourceParser parser;
    private CsvSource source;
    private Product product;

    protected CsvProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public void close() throws IOException {
        super.close();
        if (this.parser != null) {
            this.parser.close();
        }
    }

    protected Product readProductNodesImpl() throws IOException {
        int sceneRasterHeight;
        int sceneRasterWidth;
        File inputFile = this.getInputFile();
        this.parser = CsvFile.createCsvSourceParser(inputFile.getAbsolutePath());
        this.source = this.parser.parseMetadata();
        String sceneRasterWidthProperty = this.source.getProperties().get("sceneRasterWidth");
        int recordCount = this.source.getRecordCount();
        if (sceneRasterWidthProperty != null) {
            sceneRasterWidth = Integer.parseInt(sceneRasterWidthProperty);
            sceneRasterHeight = recordCount % sceneRasterWidth == 0 ? recordCount / sceneRasterWidth : recordCount / sceneRasterWidth + 1;
        } else {
            sceneRasterWidth = CsvProductReader.isSquareNumber(recordCount) ? (int)Math.sqrt(recordCount) : (int)Math.sqrt(recordCount) + 1;
            sceneRasterHeight = sceneRasterWidth;
        }
        String productName = StringUtils.createValidName((String)FileUtils.getFilenameWithoutExtension((File)inputFile), null, (char)'_');
        this.product = new Product(productName, "CSV", sceneRasterWidth, sceneRasterHeight);
        this.product.setPreferredTileSize(sceneRasterWidth, sceneRasterHeight);
        this.product.setFileLocation(inputFile);
        this.product.setProductReader((ProductReader)this);
        this.initTimeCoding();
        this.initBands();
        this.initGeocoding();
        return this.product;
    }

    private void initGeocoding() {
        Band latBand = this.fetchBand(Constants.LAT_NAMES);
        if (latBand == null) {
            SystemUtils.LOG.info("Latitude information not available.");
            SystemUtils.LOG.warning("Unable to initialize PixelGeoCoding.");
            return;
        }
        Band lonBand = this.fetchBand(Constants.LON_NAMES);
        if (lonBand == null) {
            SystemUtils.LOG.info("Longitude information not available.");
            SystemUtils.LOG.warning("Unable to initialize PixelGeoCoding.");
            return;
        }
        String validMask = latBand.getValidMaskExpression();
        int searchRadius = 5;
        BasicPixelGeoCoding gc = GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)validMask, (int)5);
        this.product.setSceneGeoCoding((GeoCoding)gc);
    }

    private Band fetchBand(String[] names) {
        for (String name : names) {
            if (!this.product.containsBand(name)) continue;
            return this.product.getBand(name);
        }
        return null;
    }

    private void initTimeCoding() throws IOException {
        String timePattern;
        String timeColumnName = this.source.getProperties().get("timeColumn");
        if (StringUtils.isNotNullAndNotEmpty((String)timeColumnName)) {
            this.addCsvHeaderProperty("timeColumn", timeColumnName);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)(timePattern = this.source.getProperties().get("timePattern")))) {
            this.addCsvHeaderProperty("timePattern", timePattern);
        }
        for (AttributeDescriptor descriptor : this.source.getFeatureType().getAttributeDescriptors()) {
            double[] timeMJD;
            String colName = descriptor.getName().toString();
            if (timeColumnName != null && !timeColumnName.equals(colName) || !this.isUTC(descriptor) || (timeMJD = this.getTimeMJD(colName)) == null) continue;
            int width = this.product.getSceneRasterWidth();
            int height = this.product.getSceneRasterHeight();
            this.product.setSceneTimeCoding((TimeCoding)new CSVTimeCoding(timeMJD, width, height, colName));
            this.initStartEndTime(timeMJD);
            return;
        }
        SystemUtils.LOG.warning("Not able to create PixelTimeCoding for product '" + this.product.getFileLocation().getAbsolutePath() + "'");
    }

    private void addCsvHeaderProperty(String name, String stringValue) {
        MetadataElement headerElement = this.getCsvMetadataHeader();
        headerElement.addAttribute(new MetadataAttribute(name, ProductData.createInstance((String)stringValue), true));
    }

    private MetadataElement getCsvMetadataHeader() {
        MetadataElement headerElement;
        MetadataElement metadataRoot = this.product.getMetadataRoot();
        if (metadataRoot.containsElement("CSV Header Properties")) {
            headerElement = metadataRoot.getElement("CSV Header Properties");
        } else {
            headerElement = new MetadataElement("CSV Header Properties");
            metadataRoot.addElement(headerElement);
        }
        return headerElement;
    }

    private void initStartEndTime(double[] timeMJD) {
        this.product.setStartTime(new ProductData.UTC(DoubleStream.of(timeMJD).min().getAsDouble()));
        this.product.setEndTime(new ProductData.UTC(DoubleStream.of(timeMJD).max().getAsDouble()));
    }

    private boolean isUTC(AttributeDescriptor descriptor) {
        Class binding = descriptor.getType().getBinding();
        return binding.getSimpleName().toLowerCase().equals("utc");
    }

    private double[] getTimeMJD(String colName) throws IOException {
        Object[] objects = this.parser.parseRecords(0, this.source.getRecordCount(), colName);
        double[] timeMJD = new double[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ProductData.UTC date = (ProductData.UTC)objects[i];
            if (date == null) {
                return null;
            }
            timeMJD[i] = date.getMJD();
        }
        return timeMJD;
    }

    private void initBands() {
        for (AttributeDescriptor descriptor : this.source.getFeatureType().getAttributeDescriptors()) {
            Class binding = descriptor.getType().getBinding();
            if (!this.isAccessibleBandType(binding)) continue;
            int type = this.getProductDataType(binding);
            this.product.addBand(descriptor.getName().toString(), type);
        }
    }

    private File getInputFile() throws FileNotFoundException {
        File inputFile = new File(this.getInput().toString());
        if (!inputFile.exists()) {
            throw new FileNotFoundException(inputFile.getPath());
        }
        return inputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Object[] values;
        SystemUtils.LOG.log(Level.FINEST, MessageFormat.format("reading band data (" + destBand.getName() + ") from {0} to {1}", destOffsetY * destWidth, sourceOffsetY * destWidth + destWidth * destHeight));
        pm.beginTask("reading band data...", destWidth * destHeight);
        CsvSourceParser csvSourceParser = this.parser;
        synchronized (csvSourceParser) {
            values = this.parser.parseRecords(destOffsetY * destBand.getRasterWidth() + destOffsetX, destWidth * destHeight, destBand.getName());
        }
        this.getProductData(values, destBuffer);
        pm.done();
    }

    void getProductData(Object[] elems, ProductData destBuffer) {
        switch (destBuffer.getType()) {
            case 30: {
                for (int i = 0; i < destBuffer.getNumElems(); ++i) {
                    Object elem = i < elems.length ? (elems[i] != null ? elems[i] : Float.valueOf(Float.NaN)) : Float.valueOf(Float.NaN);
                    destBuffer.setElemFloatAt(i, ((Float)elem).floatValue());
                }
                break;
            }
            case 31: {
                for (int i = 0; i < destBuffer.getNumElems(); ++i) {
                    Object elem = i < elems.length ? (elems[i] != null ? elems[i] : Double.valueOf(Double.NaN)) : Double.valueOf(Double.NaN);
                    destBuffer.setElemDoubleAt(i, ((Double)elem).doubleValue());
                }
                break;
            }
            case 10: {
                for (int i = 0; i < elems.length; ++i) {
                    Object elem = elems[i] != null ? elems[i] : Integer.valueOf(0);
                    destBuffer.setElemIntAt(i, (int)((Byte)elem).byteValue());
                }
                break;
            }
            case 11: {
                for (int i = 0; i < elems.length; ++i) {
                    Object elem = elems[i] != null ? elems[i] : Integer.valueOf(0);
                    destBuffer.setElemIntAt(i, (int)((Short)elem).shortValue());
                }
                break;
            }
            case 12: {
                for (int i = 0; i < elems.length; ++i) {
                    Object elem = elems[i] != null ? elems[i] : Integer.valueOf(0);
                    destBuffer.setElemIntAt(i, ((Integer)elem).intValue());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type '" + ProductData.getTypeString((int)destBuffer.getType()) + "'.");
            }
        }
    }

    int getProductDataType(Class<?> type) {
        if (type.getSimpleName().toLowerCase().equals("string")) {
            return 41;
        }
        if (type.getSimpleName().toLowerCase().equals("float")) {
            return 30;
        }
        if (type.getSimpleName().toLowerCase().equals("double")) {
            return 31;
        }
        if (type.getSimpleName().toLowerCase().equals("byte")) {
            return 10;
        }
        if (type.getSimpleName().toLowerCase().equals("short")) {
            return 11;
        }
        if (type.getSimpleName().toLowerCase().equals("integer")) {
            return 12;
        }
        if (type.getSimpleName().toLowerCase().equals("utc")) {
            return 51;
        }
        throw new IllegalArgumentException("Unsupported type '" + type + "'.");
    }

    static boolean isSquareNumber(int number) {
        int temp = (int)Math.sqrt(number);
        return temp * temp == number;
    }

    private boolean isAccessibleBandType(Class<?> type) {
        String className = type.getSimpleName().toLowerCase();
        return className.equals("float") || className.equals("double") || className.equals("byte") || className.equals("short") || className.equals("integer");
    }

    static class CSVTimeCoding
    extends PixelTimeCoding {
        private final String dataSourceName;

        public CSVTimeCoding(double[] timeMJD, int rasterWidth, int rasterHeight, String dataSourceName) {
            super(timeMJD, rasterWidth, rasterHeight);
            this.dataSourceName = dataSourceName;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }
    }
}

