/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.sun.media.imageio.stream.FileChannelImageInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.geometry.VectorDataNodeIO;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.converters.JavaTypeConverter;
import org.esa.snap.csv.dataio.Constants;
import org.esa.snap.csv.dataio.CsvSource;
import org.esa.snap.csv.dataio.CsvSourceParser;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CsvFile
implements CsvSourceParser,
CsvSource {
    public static final String DEFAULT_HEADER_NAME = "csv";
    private final Map<String, String> properties = new HashMap<String, String>();
    private final File csv;
    private final SortedMap<Long, Long> bytePositionForOffset = new TreeMap<Long, Long>();
    private SimpleFeatureType simpleFeatureType;
    private ListFeatureCollection featureCollection;
    private CoordinateReferenceSystem crs;
    private boolean propertiesParsed = false;
    private boolean hasFeatureId = false;
    private boolean recordsParsed = false;
    private ImageInputStream stream;
    private int headerByteSize;
    private int propertiesByteSize;
    private Converter<?>[] converters;

    private CsvFile(String csv) throws IOException {
        this(new File(csv), null);
    }

    private CsvFile(File csv, CoordinateReferenceSystem crs) throws IOException {
        this.csv = csv;
        ConverterRegistry.getInstance().setConverter(ProductData.UTC.class, (Converter)new UTCConverter());
        this.crs = crs;
        RandomAccessFile randomAccessFile = new RandomAccessFile(csv, "r");
        this.stream = new FileChannelImageInputStream(randomAccessFile.getChannel());
    }

    public static CsvSourceParser createCsvSourceParser(String csv) throws IOException {
        return new CsvFile(csv);
    }

    @Override
    public void checkReadingFirstRecord() throws IOException {
        this.skipToLine(0L);
        String line = this.stream.readLine();
        String[] tokens = this.getTokens(line);
        for (int i = 0; i < this.converters.length; ++i) {
            Converter<?> converter = this.converters[i];
            try {
                converter.parse(tokens[i + (this.hasFeatureId ? 1 : 0)]);
                continue;
            }
            catch (ConversionException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Object[] parseRecords(int offset, int numRecords, String colName) throws IOException {
        String line;
        AttributeDescriptor attributeDescriptor = this.simpleFeatureType.getDescriptor(colName);
        int expectedTokenCount = this.simpleFeatureType.getAttributeCount();
        expectedTokenCount += this.hasFeatureId ? 1 : 0;
        int colIndex = this.simpleFeatureType.getAttributeDescriptors().indexOf(attributeDescriptor);
        int tokenIndex = colIndex + (this.hasFeatureId ? 1 : 0);
        ArrayList<Object> values = new ArrayList<Object>(numRecords);
        this.skipToLine(offset);
        long featureCount = offset;
        while ((numRecords == -1 || featureCount < (long)(offset + numRecords)) && (line = this.stream.readLine()) != null) {
            String[] tokens = this.getTokens(line);
            if (tokens.length != expectedTokenCount) continue;
            ++featureCount;
            String token = tokens[tokenIndex];
            try {
                Object value = null;
                if (!"[null]".equals(token)) {
                    value = this.converters[colIndex].parse(token);
                }
                values.add(value);
            }
            catch (ConversionException e) {
                SystemUtils.LOG.warning(String.format("Problem in '%s': %s", this.csv.getPath(), e.getMessage()));
            }
            this.bytePositionForOffset.put(featureCount, this.stream.getStreamPosition());
        }
        return values.toArray();
    }

    @Override
    public void parseRecords(int offset, int numRecords) throws IOException {
        String line;
        this.featureCollection = new ListFeatureCollection(this.simpleFeatureType);
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.simpleFeatureType);
        this.skipToLine(offset);
        long featureCount = offset;
        while ((numRecords == -1 || featureCount < (long)(offset + numRecords)) && (line = this.stream.readLine()) != null) {
            String[] tokens = this.getTokens(line);
            int expectedTokenCount = this.simpleFeatureType.getAttributeCount();
            if (tokens.length != (expectedTokenCount += this.hasFeatureId ? 1 : 0)) continue;
            builder.reset();
            String featureId = "" + featureCount++;
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (i == 0 && this.hasFeatureId) {
                    featureId = token;
                    continue;
                }
                try {
                    Object value = null;
                    int currentIndex = i;
                    currentIndex -= this.hasFeatureId ? 1 : 0;
                    if (!"[null]".equals(token)) {
                        value = this.converters[currentIndex].parse(token);
                    }
                    builder.set(this.simpleFeatureType.getDescriptor(currentIndex).getLocalName(), value);
                    continue;
                }
                catch (ConversionException e) {
                    SystemUtils.LOG.warning(String.format("Problem in '%s': %s", this.csv.getPath(), e.getMessage()));
                }
            }
            SimpleFeature simpleFeature = builder.buildFeature(featureId);
            this.featureCollection.add(simpleFeature);
            this.bytePositionForOffset.put(featureCount, this.stream.getStreamPosition());
        }
        this.recordsParsed = true;
    }

    @Override
    public CsvSource parseMetadata() throws IOException {
        this.parseProperties();
        this.parseHeader();
        this.initConverters();
        return this;
    }

    private void initConverters() throws IOException {
        this.converters = VectorDataNodeIO.getConverters((SimpleFeatureType)this.simpleFeatureType);
        String timePattern = this.properties.get("timePattern");
        if (StringUtils.isNotNullAndNotEmpty((String)timePattern)) {
            List attributeTypes = this.getFeatureType().getTypes();
            for (int i = 0; i < attributeTypes.size(); ++i) {
                Class type = ((AttributeType)attributeTypes.get(i)).getBinding();
                if (type != ProductData.UTC.class) continue;
                this.converters[i] = new UTCConverter(timePattern);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getRecordCount() throws IOException {
        int readChars;
        int count = 1;
        byte[] buffer = new byte[102400];
        long currentPosInStream = this.stream.getStreamPosition();
        this.stream.seek(0L);
        while ((readChars = this.stream.read(buffer)) != -1) {
            for (int i = 0; i < readChars - 1; ++i) {
                if (buffer[i] != 10) continue;
                ++count;
            }
        }
        count -= this.properties.size();
        boolean headerLineCount = true;
        this.stream.seek(currentPosInStream);
        return --count;
    }

    @Override
    public SimpleFeature[] getSimpleFeatures() {
        if (!this.recordsParsed) {
            throw new IllegalStateException("The records have not been parsed yet.");
        }
        Object[] objects = this.featureCollection.toArray(new Object[this.featureCollection.size()]);
        SimpleFeature[] simpleFeatures = new SimpleFeature[objects.length];
        for (int i = 0; i < simpleFeatures.length; ++i) {
            simpleFeatures[i] = (SimpleFeature)objects[i];
        }
        return simpleFeatures;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.simpleFeatureType;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    private void parseProperties() throws IOException {
        String line;
        this.stream.seek(0L);
        this.propertiesByteSize = 0;
        long posInStream = 0L;
        while ((line = this.stream.readLine()) != null) {
            if (!line.startsWith("#")) {
                this.stream.seek(posInStream);
                break;
            }
            this.propertiesByteSize = (int)((long)this.propertiesByteSize + (this.stream.getStreamPosition() - posInStream));
            posInStream = this.stream.getStreamPosition();
            int pos = (line = line.substring(1)).indexOf(61);
            if (pos == -1) {
                throw new IOException("Missing '=' in '" + line + "'");
            }
            String name = line.substring(0, pos).trim();
            if (name.isEmpty()) {
                throw new IOException("Empty property name in '" + line + "'");
            }
            String value = line.substring(pos + 1).trim();
            try {
                if (this.contains(Constants.CRS_IDENTIFIERS, name) && this.crs != null) {
                    this.crs = CRS.parseWKT((String)value);
                }
            }
            catch (FactoryException e) {
                throw new IOException(e);
            }
            this.properties.put(name, value);
        }
        this.propertiesParsed = true;
    }

    private void skipToLine(long lineOffset) throws IOException {
        if (this.bytePositionForOffset.containsKey(lineOffset)) {
            this.stream.seek((Long)this.bytePositionForOffset.get(lineOffset));
            return;
        }
        Map.Entry<Long, Long> entry = this.getBestOffset(lineOffset);
        this.stream.seek(entry.getValue());
        long linesToSkip = lineOffset - entry.getKey();
        int i = 0;
        while ((long)i < linesToSkip) {
            this.stream.readLine();
            ++i;
        }
        this.bytePositionForOffset.put(lineOffset, this.stream.getStreamPosition());
    }

    private Map.Entry<Long, Long> getBestOffset(long lineOffset) {
        Map.Entry<Long, Long> result = new AbstractMap.SimpleEntry<Long, Long>(0L, (long)this.propertiesByteSize + (long)this.headerByteSize);
        for (Map.Entry<Long, Long> entry : this.bytePositionForOffset.entrySet()) {
            if (entry.getKey() > lineOffset) {
                return result;
            }
            result = entry;
        }
        return result;
    }

    private void createFeatureType(String[] headerLine) throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setCRS((CoordinateReferenceSystem)(this.crs != null ? this.crs : DefaultGeographicCRS.WGS84));
        CsvJavaTypeConverter jtc = new CsvJavaTypeConverter();
        builder.setName(DEFAULT_HEADER_NAME);
        for (String token : headerLine) {
            Class attributeType;
            String attributeName;
            if (token.toLowerCase().equals("featureId".toLowerCase())) {
                this.hasFeatureId = true;
                continue;
            }
            int colonPos = token.indexOf(58);
            if (colonPos == 0) {
                throw new IOException(String.format("Missing name specifier in attribute descriptor '%s'", token));
            }
            if (colonPos == -1) {
                attributeName = token;
                attributeType = Double.class;
            } else {
                attributeName = token.substring(0, colonPos);
                String attributeTypeName = token.substring(colonPos + 1).toLowerCase();
                if (attributeTypeName.equals("int")) {
                    attributeType = Integer.class;
                } else {
                    attributeTypeName = attributeTypeName.substring(0, 1).toUpperCase() + attributeTypeName.substring(1);
                    try {
                        attributeType = jtc.parse(attributeTypeName);
                    }
                    catch (ConversionException e) {
                        throw new IOException(String.format("Unknown type in attribute descriptor '%s'", token), e);
                    }
                }
            }
            builder.add(attributeName, attributeType);
        }
        this.simpleFeatureType = builder.buildFeatureType();
    }

    private void parseHeader() throws IOException {
        String line;
        if (!this.propertiesParsed) {
            throw new IllegalStateException("Properties need to be parsed before header.");
        }
        this.stream.seek(this.propertiesByteSize);
        long posInStream = this.stream.getStreamPosition();
        while ((line = this.stream.readLine()) != null) {
            if (line.startsWith("#")) {
                this.propertiesByteSize = (int)((long)this.propertiesByteSize + (this.stream.getStreamPosition() - posInStream));
                posInStream = this.stream.getStreamPosition();
                continue;
            }
            this.headerByteSize = (int)((long)this.headerByteSize + (this.stream.getStreamPosition() - posInStream));
            String separator = this.getProperty("separator", "\t");
            this.createFeatureType(line.split(separator));
            break;
        }
    }

    private String[] getTokens(String line) {
        int pos2;
        int pos1 = 0;
        ArrayList<String> strings = new ArrayList<String>();
        String separator = this.getProperty("separator", "\t");
        while ((pos2 = line.indexOf(separator, pos1)) >= 0) {
            strings.add(line.substring(pos1, pos2).trim());
            pos1 = pos2 + 1;
        }
        strings.add(line.substring(pos1).trim());
        return strings.toArray(new String[strings.size()]);
    }

    private boolean contains(String[] possibleStrings, String s) {
        for (String possibleString : possibleStrings) {
            if (!possibleString.toLowerCase().equals(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private String getProperty(String propertyName, String defaultValue) {
        return this.properties.get(propertyName) != null ? this.properties.get(propertyName) : defaultValue;
    }

    private class CsvJavaTypeConverter
    extends JavaTypeConverter {
        private CsvJavaTypeConverter() {
        }

        public Class parse(String text) throws ConversionException {
            Class<?> result;
            try {
                result = super.parse(text);
            }
            catch (ConversionException e) {
                try {
                    if (CsvFile.this.contains(Constants.TIME_NAMES, text.toLowerCase())) {
                        result = ((Object)((Object)this)).getClass().getClassLoader().loadClass(ProductData.UTC.class.getName());
                    }
                    if ("ubyte".toLowerCase().equals(text.toLowerCase())) {
                        result = ((Object)((Object)this)).getClass().getClassLoader().loadClass(Byte.class.getName());
                    }
                    if ("ushort".toLowerCase().equals(text.toLowerCase())) {
                        result = ((Object)((Object)this)).getClass().getClassLoader().loadClass(Short.class.getName());
                    }
                    if ("uint".toLowerCase().equals(text.toLowerCase())) {
                        result = ((Object)((Object)this)).getClass().getClassLoader().loadClass(Integer.class.getName());
                    }
                    throw new ConversionException((Throwable)e);
                }
                catch (ClassNotFoundException e1) {
                    throw new ConversionException((Throwable)e1);
                }
            }
            return result;
        }
    }

    private static class UTCConverter
    implements Converter<ProductData.UTC> {
        private final String timePattern;

        public UTCConverter() {
            this("yyyy-MM-dd'T'HH:mm:ss");
        }

        private UTCConverter(String timePattern) {
            this.timePattern = timePattern;
        }

        public Class<? extends ProductData.UTC> getValueType() {
            return ProductData.UTC.class;
        }

        public ProductData.UTC parse(String text) throws ConversionException {
            try {
                return ProductData.UTC.parse((String)text, (String)this.timePattern);
            }
            catch (ParseException e) {
                throw new ConversionException((Throwable)e);
            }
        }

        public String format(ProductData.UTC value) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.timePattern);
            return sdf.format(value.getAsDate());
        }
    }
}

