/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDListBox
extends Box {
    private short num;
    private byte[][] uuids;

    public UUIDListBox(short s, byte[][] byArray) {
        super(10 + (byArray.length << 4), 1970041716, null);
        this.num = s;
        this.uuids = byArray;
    }

    public UUIDListBox(byte[] byArray) {
        super(8 + byArray.length, 1970041716, byArray);
    }

    public UUIDListBox(Node node) throws IIOInvalidTreeException {
        super(node);
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        int n2 = 0;
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (!"NumberUUID".equals(node2.getNodeName())) continue;
            this.num = Box.getShortElementValue(node2);
            this.uuids = new byte[this.num][];
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (!"UUID".equals(node2.getNodeName()) || n2 >= this.num) continue;
            this.uuids[n2++] = Box.getByteArrayElementValue(node2);
        }
    }

    protected void parse(byte[] byArray) {
        this.num = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.uuids = new byte[this.num][];
        int n = 2;
        for (int i = 0; i < this.num; ++i) {
            this.uuids[i] = new byte[16];
            System.arraycopy(byArray, n, this.uuids[i], 0, 16);
            n += 16;
        }
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("NumberUUID");
        iIOMetadataNode2.setUserObject(new Short(this.num));
        iIOMetadataNode2.setNodeValue("" + this.num);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        for (int i = 0; i < this.num; ++i) {
            iIOMetadataNode2 = new IIOMetadataNode("UUID");
            iIOMetadataNode2.setUserObject(this.uuids[i]);
            iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(this.uuids[i]));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[2 + this.num * 16];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int n = 2;
        for (int i = 0; i < this.num; ++i) {
            System.arraycopy(this.uuids[i], 0, this.data, n, 16);
            n += 16;
        }
    }
}

