/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import java.util.HashMap;
import java.util.Map;

public class TIFFTag {
    public static final int TIFF_BYTE = 1;
    public static final int TIFF_ASCII = 2;
    public static final int TIFF_SHORT = 3;
    public static final int TIFF_LONG = 4;
    public static final int TIFF_RATIONAL = 5;
    public static final int TIFF_SBYTE = 6;
    public static final int TIFF_UNDEFINED = 7;
    public static final int TIFF_SSHORT = 8;
    public static final int TIFF_SLONG = 9;
    public static final int TIFF_SRATIONAL = 10;
    public static final int TIFF_FLOAT = 11;
    public static final int TIFF_DOUBLE = 12;
    public static final int TIFF_IFD_POINTER = 13;
    public static final int MIN_DATATYPE = 1;
    public static final int MAX_DATATYPE = 13;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 4};
    int number;
    String name;
    int dataTypes;
    TIFFTagSet tagSet = null;
    Map valueNames = null;

    public TIFFTag(String string, int n, int n2, TIFFTagSet tIFFTagSet) {
        this.name = string;
        this.number = n;
        this.dataTypes = n2;
        this.tagSet = tIFFTagSet;
    }

    public TIFFTag(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public static int getSizeOfType(int n) {
        if (n < 1 || n > 13) {
            throw new IllegalArgumentException("dataType out of range!");
        }
        return sizeOfType[n];
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public int getDataTypes() {
        return this.dataTypes;
    }

    public boolean isDataTypeOK(int n) {
        if (n < 1 || n > 13) {
            throw new IllegalArgumentException("datatype not in range!");
        }
        return (this.dataTypes & 1 << n) != 0;
    }

    public TIFFTagSet getTagSet() {
        return this.tagSet;
    }

    public boolean isIFDPointer() {
        return this.tagSet != null || (this.dataTypes & 0x2000) != 0;
    }

    public boolean hasValueNames() {
        return this.valueNames != null;
    }

    protected void addValueName(int n, String string) {
        if (this.valueNames == null) {
            this.valueNames = new HashMap();
        }
        this.valueNames.put(new Integer(n), string);
    }

    public String getValueName(int n) {
        if (this.valueNames == null) {
            return null;
        }
        return (String)this.valueNames.get(new Integer(n));
    }
}

