/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.util.ArrayList;
import java.util.List;

public class ThreadManager {
    private int numConsecutiveThreads = Runtime.getRuntime().availableProcessors();
    private final List<Thread> threadList = new ArrayList<Thread>(this.numConsecutiveThreads);

    public void add(Thread worker) throws InterruptedException {
        this.threadList.add(worker);
        worker.start();
        if (this.threadList.size() >= this.numConsecutiveThreads) {
            for (Thread t : this.threadList) {
                t.join();
            }
            this.threadList.clear();
        }
    }

    public void finish() throws InterruptedException {
        if (!this.threadList.isEmpty()) {
            for (Thread t : this.threadList) {
                t.join();
            }
        }
    }

    public int getNumConsecutiveThreads() {
        return this.numConsecutiveThreads;
    }

    public void setNumConsecutiveThreads(int numThreads) {
        this.numConsecutiveThreads = numThreads;
    }
}

