/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public final class ProcessTimeMonitor {
    private Date executeStartTime = null;

    public void start() {
        this.executeStartTime = Calendar.getInstance().getTime();
    }

    public long stop() {
        return this.getCurrentDuration();
    }

    public long getCurrentDuration() {
        Date now = Calendar.getInstance().getTime();
        return (now.getTime() - this.executeStartTime.getTime()) / 1000L;
    }

    public static String formatDuration(long dur) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (dur > 7200L) {
            return df.format((float)dur / 3600.0f) + " hours";
        }
        if (dur > 120L) {
            return df.format((float)dur / 60.0f) + " minutes";
        }
        return df.format(dur) + " seconds";
    }
}

