/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.download.opendata;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.Credentials;
import org.esa.snap.engine_utilities.download.opendata.HTTPDownloader;

public class OpenData {
    private final String host;
    private final String odataRoot;
    private final Credentials.CredentialInfo credentialInfo;
    private final HTTPDownloader downloader;
    private final Edm edm;
    private static final String APPLICATION_XML = "application/xml";
    private static final int MAX_DOWNLOAD_TRIES = 5;

    public OpenData(String host, String odataRoot) throws IOException {
        this.host = host;
        this.odataRoot = odataRoot;
        this.credentialInfo = this.getCredentialInfo();
        this.downloader = new HTTPDownloader();
        try {
            String odataMetaLink = odataRoot + "$metadata";
            InputStream content = HTTPDownloader.connect(odataMetaLink, APPLICATION_XML, "GET", this.credentialInfo.getUser(), this.credentialInfo.getPassword());
            this.edm = EntityProvider.readMetadata((InputStream)content, (boolean)false);
            if (content != null) {
                content.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Entry getEntryByID(String id) throws IOException {
        return this.readEntry(this.odataRoot, APPLICATION_XML, "Products", id, "?");
    }

    public void getManifest(String id, Entry entry, File outputFolder, ProgressMonitor pm) throws IOException {
        int tries = 1;
        HTTPDownloader.EntryFileProperty entryFp = null;
        while (entryFp == null || entryFp.getSize() != entry.contentLength.longValue()) {
            String manifest = "/Nodes('" + entry.name + ".SAFE')/Nodes('manifest.safe')/\\";
            String downloadURL = this.odataRoot + "Products('" + id + "')" + manifest + "$value?";
            SystemUtils.LOG.info(downloadURL);
            entryFp = HTTPDownloader.getEntryFilePropertyFromUrlString(downloadURL, entry.fileName, entry.contentLength, entry.contentType, outputFolder, this.credentialInfo.getUser(), this.credentialInfo.getPassword(), pm);
            if (entryFp != null && entryFp.getSize() == entry.contentLength.longValue()) break;
            try {
                SystemUtils.LOG.info("Try " + tries + " did not work. Please wait 30s...");
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (tries > 5 && (entryFp == null || entryFp.getSize() != entry.contentLength.longValue())) {
                SystemUtils.LOG.info("Skiping...");
                break;
            }
            ++tries;
        }
        if (tries > 5) {
            SystemUtils.LOG.warning("Resuming tries for file " + entry.fileName + " did not work.");
        } else if (entryFp.getMd5Checksum().equalsIgnoreCase(entry.hexChecksum)) {
            SystemUtils.LOG.info("Filename: " + entry.fileName + " downloaded and checked " + entry.hexChecksum);
        } else {
            SystemUtils.LOG.severe("Filename: " + entry.fileName + " downloaded [INVALID CHECKSUM]");
        }
    }

    public void getProduct(String id, Entry entry, File outputFolder, ProgressMonitor pm) throws IOException {
        int tries = 1;
        HTTPDownloader.EntryFileProperty entryFp = null;
        while (entryFp == null || entryFp.getSize() != entry.contentLength.longValue()) {
            String downloadURL = this.odataRoot + "Products('" + id + "')" + "/$value?";
            entryFp = HTTPDownloader.getEntryFilePropertyFromUrlString(downloadURL, entry.fileName, entry.contentLength, entry.contentType, outputFolder, this.credentialInfo.getUser(), this.credentialInfo.getPassword(), pm);
            if (entryFp != null && entryFp.getSize() == entry.contentLength.longValue() || pm.isCanceled()) break;
            try {
                SystemUtils.LOG.info("Try " + tries + " did not work. Please wait 30s...");
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (tries > 5 && (entryFp == null || entryFp.getSize() != entry.contentLength.longValue()) || pm.isCanceled()) {
                SystemUtils.LOG.info("Skiping...");
                break;
            }
            ++tries;
        }
        if (pm.isCanceled()) {
            SystemUtils.LOG.info("OpenData: Download is cancelled");
            return;
        }
        if (tries > 5) {
            SystemUtils.LOG.warning("Resuming tries for file " + entry.fileName + " did not work.");
            throw new IOException(entry.fileName);
        }
        if (entryFp.getMd5Checksum().equalsIgnoreCase(entry.hexChecksum)) {
            SystemUtils.LOG.info("Filename: " + entry.fileName + " downloaded and checked " + entry.hexChecksum);
        } else {
            SystemUtils.LOG.severe("Filename: " + entry.fileName + " downloaded [INVALID CHECKSUM]");
        }
    }

    private Entry readEntry(String serviceUri, String contentType, String entitySetName, String keyValue, String params) throws IOException {
        try {
            EdmEntityContainer entityContainer = this.edm.getDefaultEntityContainer();
            InputStream content = HTTPDownloader.connect(serviceUri + entitySetName + "('" + keyValue + "')" + params, contentType, "GET", this.credentialInfo.getUser(), this.credentialInfo.getPassword());
            ODataEntry oDataEntry = EntityProvider.readEntry((String)contentType, (EdmEntitySet)entityContainer.getEntitySet(entitySetName), (InputStream)content, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
            return new Entry(oDataEntry);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Credentials.CredentialInfo getCredentialInfo() throws IOException {
        Credentials.CredentialInfo credentialInfo = Credentials.instance().get(this.host);
        if (credentialInfo == null) {
            throw new IOException("Credentials for " + this.host + " not set");
        }
        return credentialInfo;
    }

    public static class Entry {
        public final String hexChecksum;
        public final Long contentLength;
        public final String fileName;
        public final String name;
        public final String contentType;
        public final GeoPos[] footprint;
        private static final String gmlCoordStart = "<gml:coordinates>";
        private static final String gmlCoordEnd = "</gml:coordinates>";

        public Entry(ODataEntry oDataEntry) {
            Map propMap = oDataEntry.getProperties();
            this.contentLength = Long.parseLong(propMap.get("ContentLength").toString());
            this.contentType = propMap.get("ContentType").toString();
            this.name = propMap.get("Name").toString();
            this.fileName = propMap.get("Name") + ".zip";
            HashMap checksum = (HashMap)propMap.get("Checksum");
            this.hexChecksum = checksum.get("Value").toString();
            this.footprint = Entry.getCoordinates((String)propMap.get("ContentGeometry"));
        }

        private static GeoPos[] getCoordinates(String geomStr) {
            String values = geomStr.substring(geomStr.indexOf(gmlCoordStart) + gmlCoordStart.length(), geomStr.indexOf(gmlCoordEnd)).trim();
            values = values.replace(' ', ',');
            ArrayList<Object> geoPosList = new ArrayList<Object>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreTokens()) {
                String latStr = st.nextToken();
                String lonStr = st.nextToken();
                geoPosList.add(new GeoPos(Double.parseDouble(latStr), Double.parseDouble(lonStr)));
            }
            geoPosList.add(geoPosList.get(0));
            return geoPosList.toArray(new GeoPos[geoPosList.size()]);
        }
    }
}

